/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.Session;
import org.hibernate.tuple.ValueGenerator;

interface TimestampGenerators {

    public static class CurrentSqlTimestampGenerator
    implements ValueGenerator<Timestamp> {
        @Override
        public Timestamp generateValue(Session session, Object owner) {
            return new Timestamp(new Date().getTime());
        }
    }

    public static class CurrentSqlTimeGenerator
    implements ValueGenerator<Time> {
        @Override
        public Time generateValue(Session session, Object owner) {
            return new Time(new Date().getTime());
        }
    }

    public static class CurrentSqlDateGenerator
    implements ValueGenerator<java.sql.Date> {
        @Override
        public java.sql.Date generateValue(Session session, Object owner) {
            return new java.sql.Date(new Date().getTime());
        }
    }

    public static class CurrentCalendarGenerator
    implements ValueGenerator<Calendar> {
        @Override
        public Calendar generateValue(Session session, Object owner) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            return calendar;
        }
    }

    public static class CurrentDateGenerator
    implements ValueGenerator<Date> {
        @Override
        public Date generateValue(Session session, Object owner) {
            return new Date();
        }
    }
}

