/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.ichtyometer.feed.FeedReader;
import fr.ifremer.tutti.service.ClosedPersistenceService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.bigfin.BigfinImportService;
import fr.ifremer.tutti.service.catches.ValidateCruiseOperationsService;
import fr.ifremer.tutti.service.catches.WeightCleaningService;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.catches.multipost.MultiPostExportService;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportService;
import fr.ifremer.tutti.service.export.generic.TuttiExportService;
import fr.ifremer.tutti.service.export.pdf.CatchesPdfExportService;
import fr.ifremer.tutti.service.export.sumatra.CatchesSumatraExportService;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.service.psionimport.PsionImportService;
import fr.ifremer.tutti.service.pupitri.PupitriImportExportService;
import fr.ifremer.tutti.service.referential.ReferentialExportService;
import fr.ifremer.tutti.service.referential.ReferentialImportService;
import fr.ifremer.tutti.service.referential.TuttiReferentialSynchronizeService;
import fr.ifremer.tutti.service.report.ReportService;
import fr.ifremer.tutti.ui.swing.TuttiActionFactory;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.UIMessageNotifier;
import fr.ifremer.tutti.ui.swing.util.auth.AuthenticationInfo;
import fr.ifremer.tutti.ui.swing.util.auth.LoginUI;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpBroker;
import jaxx.runtime.swing.help.JAXXHelpUIHandler;
import jaxx.runtime.swing.session.BeanDoubleListState;
import jaxx.runtime.swing.session.BeanFilterableComboBoxState;
import jaxx.runtime.swing.session.SwingSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.converter.ConverterUtil;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.i18n.init.UserI18nInitializer;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.ApplicationConfiguration;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.listener.PropagatePropertyChangeListener;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.action.ApplicationActionEngine;
import org.nuiton.jaxx.application.swing.action.ApplicationActionFactory;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUI;
import org.nuiton.jaxx.application.swing.action.ApplicationUIAction;
import org.nuiton.jaxx.application.swing.util.ApplicationErrorHelper;

public class TuttiUIContext
extends AbstractBean
implements Closeable,
UIMessageNotifier,
JAXXHelpUIHandler,
PropagatePropertyChangeListener.PropagatePropertyChange,
ApplicationUIContext {
    private static final Log log = LogFactory.getLog(TuttiUIContext.class);
    public static final String PROPERTY_PROGRAM_ID = "programId";
    public static final String PROPERTY_CRUISE_ID = "cruiseId";
    public static final String PROPERTY_PROTOCOL_ID = "protocolId";
    public static final String PROPERTY_SCREEN = "screen";
    public static final String PROPERTY_PROGRAM_FILLED = "programFilled";
    public static final String PROPERTY_CRUISE__FILLED = "cruiseFilled";
    public static final String PROPERTY_PROTOCOL_FILLED = "protocolFilled";
    public static final String PROPERTY_VALIDATION_CONTEXT = "validationContext";
    public static final String PROPERTY_ICHTYOMETER_CONNECTED = "ichtyometerConnected";
    public static final String PROPERTY_BUSY = "busy";
    public static final String PROPERTY_HIDE_BODY = "hideBody";
    public static final String PROPERTY_LOCALE = "locale";
    public static final Set<String> PROPERTIES_TO_SAVE = Sets.newHashSet((Object[])new String[]{"programId", "cruiseId", "protocolId", "locale"});
    public static final String PROPERTY_DB_EXIST = "dbExist";
    public static final String PROPERTY_DB_LOADED = "dbLoaded";
    private static TuttiUIContext applicationContext;
    protected final TuttiConfiguration config;
    protected final TuttiServiceContext serviceContext;
    protected final SwingSession swingSession;
    protected final ApplicationErrorHelper errorHelper;
    protected TuttiDataContext dataContext;
    protected TuttiHelpBroker helpBroker;
    protected TuttiScreen screen;
    protected Locale locale;
    protected boolean busy;
    protected boolean hideBody;
    protected final Set<UIMessageNotifier> messageNotifiers;
    private String validationContext;
    private MainUI mainUI;
    private ApplicationActionUI actionUI;
    private boolean dbExist;
    private boolean dbLoaded;
    private Properties helpMapping;
    private final ApplicationActionFactory tuttiActionFactory;
    private final ApplicationActionEngine tuttiActionEngine;
    private final Map<String, AuthenticationInfo> updateAuthenticationStore;
    private FeedReader ichtyometerReader;
    private File lock;
    private boolean closed;

    public static TuttiUIContext newContext(TuttiConfiguration config) {
        Preconditions.checkNotNull((Object)((Object)config));
        Preconditions.checkState((applicationContext == null ? 1 : 0) != 0, (Object)"Application context was already opened!");
        applicationContext = new TuttiUIContext(config);
        return applicationContext;
    }

    public static TuttiUIContext getApplicationContext() {
        return applicationContext;
    }

    public ApplicationErrorHelper getErrorHelper() {
        return TuttiUIContext.applicationContext.errorHelper;
    }

    public String getI18nPrefix() {
        return "tutti.property.";
    }

    public String getDateFormat() {
        return this.getConfig().getDateFormat();
    }

    public boolean isActionInProgress(ApplicationUIAction action) {
        return false;
    }

    public void setActionInProgress(ApplicationUIAction action, boolean actionInProgress) {
    }

    protected TuttiUIContext(TuttiConfiguration config) {
        this.config = config;
        this.serviceContext = new TuttiServiceContext(config);
        HashMap additionalStates = Maps.newHashMap();
        additionalStates.put(BeanFilterableComboBox.class, new BeanFilterableComboBoxState());
        additionalStates.put(BeanDoubleList.class, new BeanDoubleListState());
        this.swingSession = SwingSession.newSession((File)this.getConfig().getUIConfigFile(), (boolean)false, (Map)additionalStates);
        this.errorHelper = new ApplicationErrorHelper(this){

            public void showWarningDialog(String message) {
                JOptionPane.showMessageDialog((Component)this.context.getActionUI(), "<html><body>" + message + "</body></html>", I18n.t((String)"application.error.ui.business.warning", (Object[])new Object[0]), 2);
            }

            public void showErrorDialog(String message, Throwable cause) {
                super.showErrorDialog(message, cause);
            }
        };
        this.dataContext = this.serviceContext.getDataContext();
        PropagatePropertyChangeListener.listenAndPropagateAll((AbstractBean)this.dataContext, (PropagatePropertyChangeListener.PropagatePropertyChange)this);
        UIMessageNotifier logMessageNotifier = new UIMessageNotifier(){

            @Override
            public void showInformationMessage(String message) {
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    message = message.replaceAll("\\<strong\\>", "");
                    message = message.replaceAll("\\<.strong\\>", "");
                    message = message.replaceAll("\\<li\\>", "");
                    message = message.replaceAll("\\<.li\\>", "");
                    message = message.replaceAll("\\<ul\\>", "");
                    message = message.replaceAll("\\<.ul\\>", "");
                    if (log.isInfoEnabled()) {
                        log.info((Object)message);
                    }
                }
            }
        };
        this.messageNotifiers = Sets.newHashSet();
        this.addMessageNotifier(logMessageNotifier);
        this.tuttiActionFactory = new TuttiActionFactory();
        this.tuttiActionEngine = new ApplicationActionEngine(this.tuttiActionFactory);
        this.updateAuthenticationStore = Maps.newTreeMap();
    }

    public ApplicationConfiguration getConfiguration() {
        return this.config;
    }

    public Component getBodyUI() {
        MainUI mainUI = this.getMainUI();
        return mainUI == null ? null : mainUI.getBody();
    }

    public Component getStatusUI() {
        MainUI mainUI = this.getMainUI();
        return mainUI == null ? null : mainUI.getStatus();
    }

    public void init() {
        this.config.prepareDirectories();
        ConverterUtil.deregister();
        ConverterUtil.initConverters();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (!TuttiUIContext.this.closed) {
                    TuttiUIContext.this.close();
                }
            }
        }));
        this.config.initConfig();
        File i18nDirectory = this.config.getI18nDirectory();
        if (!this.config.isFullLaunchMode() && (i18nDirectory = new File(this.config.getDataDirectory(), "i18n")).exists()) {
            ApplicationIOUtil.cleanDirectory((File)i18nDirectory, (String)I18n.t((String)"tutti.i18n.deleteCache.error", (Object[])new Object[]{i18nDirectory}));
        }
        ApplicationIOUtil.forceMkdir((File)i18nDirectory, (String)I18n.t((String)"tutti.i18n.mkDir.error", (Object[])new Object[]{i18nDirectory}));
        if (log.isDebugEnabled()) {
            log.debug((Object)("I18N directory: " + i18nDirectory));
        }
        Locale i18nLocale = this.config.getI18nLocale();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Starts i18n with locale [%s] at [%s]", i18nLocale, i18nDirectory));
        }
        I18n.init((I18nInitializer)new UserI18nInitializer(i18nDirectory, new DefaultI18nInitializer("tutti-i18n")), (Locale)i18nLocale);
        this.lock = new File(this.config.getBasedir(), "tutti.lock");
        if (this.lock.exists()) {
            this.lock = null;
            throw new ApplicationBusinessException(I18n.t((String)"tutti.error.application.already.started", (Object[])new Object[0]));
        }
        ApplicationIOUtil.writeContent((File)this.lock, (String)new Date().toString(), (String)"Could not create lock file");
        if (log.isInfoEnabled()) {
            log.info((Object)("Create lock file: " + this.lock));
        }
        File helpDirectory = this.config.getHelpDirectory();
        if (!this.config.isFullLaunchMode() && !helpDirectory.exists()) {
            helpDirectory = new File(this.config.getDataDirectory(), "help");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Help directory: " + helpDirectory));
        }
        ApplicationIOUtil.forceMkdir((File)helpDirectory, (String)I18n.t((String)"tutti.help.mkDir.error", (Object[])new Object[]{helpDirectory}));
        String mappingProperties = "/tutti-help-fr.properties";
        try {
            InputStream resourceAsStream = this.getClass().getResourceAsStream(mappingProperties);
            this.helpMapping = new Properties();
            this.helpMapping.load(resourceAsStream);
        }
        catch (Exception eee) {
            log.error((Object)("Failed to load help mapping file at '" + mappingProperties + "'"), (Throwable)eee);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Starts help with locale at [%s]", helpDirectory));
        }
        this.setActionUI(new ApplicationActionUI(null, (ApplicationUIContext)this));
    }

    public void open() {
        this.setLocale(this.config.getI18nLocale());
        if (this.getProgramId() == null) {
            this.setProgramId(this.config.getProgramId());
        }
        if (this.getCruiseId() == null) {
            this.setCruiseId(this.config.getCruiseId());
        }
        if (this.getProtocolId() == null) {
            this.setProtocolId(this.config.getProtocolId());
        }
        boolean dbExists = this.config.isDbExists();
        this.setDbExist(dbExists);
        if (!dbExists) {
            this.setProtocolId(null);
            this.setProgramId(null);
            this.setCruiseId(null);
            this.setDbLoaded(false);
        }
        this.saveContextToConfig();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (PROPERTIES_TO_SAVE.contains(evt.getPropertyName())) {
                    TuttiUIContext.this.saveContextToConfig();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Closing application context...");
        }
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Application was already closed.");
        try {
            PropertyChangeListener[] listeners;
            this.messageNotifiers.clear();
            this.validationContext = null;
            IOUtils.closeQuietly((Closeable)this.dataContext);
            this.setScreen(null);
            IOUtils.closeQuietly((Closeable)this.serviceContext);
            IOUtils.closeQuietly((Closeable)this.ichtyometerReader);
            for (PropertyChangeListener listener : listeners = this.getPropertyChangeListeners()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Remove listener: " + listener));
                }
                this.removePropertyChangeListener(listener);
            }
            this.setMainUI(null);
            if (this.actionUI != null) {
                this.actionUI.getModel().clear();
            }
            this.setActionUI(null);
        }
        finally {
            this.closed = true;
            if (this.lock != null) {
                ApplicationIOUtil.deleteFile((File)this.lock, (String)"Could not delete lock file");
                if (log.isInfoEnabled()) {
                    log.info((Object)("Delete lock file: " + this.lock));
                }
            }
        }
    }

    public PersistenceService getPersistenceService() {
        PersistenceService service;
        if (this.useRealPersistenceService()) {
            service = this.dataContext.getService();
            if (service == null) {
                service = (PersistenceService)this.serviceContext.getService(PersistenceService.class);
                this.dataContext.open(this.config, service);
            }
        } else {
            service = (PersistenceService)this.serviceContext.getService(ClosedPersistenceService.class);
        }
        return service;
    }

    public DecoratorService getDecoratorService() {
        return (DecoratorService)this.serviceContext.getService(DecoratorService.class);
    }

    public TuttiReferentialSynchronizeService getTuttiReferentialSynchronizeService() {
        return (TuttiReferentialSynchronizeService)this.serviceContext.getService(TuttiReferentialSynchronizeService.class);
    }

    public ProtocolImportExportService getTuttiProtocolImportExportService() {
        return (ProtocolImportExportService)this.serviceContext.getService(ProtocolImportExportService.class);
    }

    public PupitriImportExportService getTuttiPupitriImportExportService() {
        return (PupitriImportExportService)this.serviceContext.getService(PupitriImportExportService.class);
    }

    public PsionImportService getTuttiPsionImportService() {
        return (PsionImportService)this.serviceContext.getService(PsionImportService.class);
    }

    public BigfinImportService getTuttiBigfinImportService() {
        return (BigfinImportService)this.serviceContext.getService(BigfinImportService.class);
    }

    public ReferentialImportService getTuttiReferentialImportService() {
        return (ReferentialImportService)this.serviceContext.getService(ReferentialImportService.class);
    }

    public ReferentialExportService getTuttiReferentialExportService() {
        return (ReferentialExportService)this.serviceContext.getService(ReferentialExportService.class);
    }

    public WeightComputingService getWeightComputingService() {
        return (WeightComputingService)this.serviceContext.getService(WeightComputingService.class);
    }

    public WeightCleaningService getWeightCleaningService() {
        return (WeightCleaningService)this.serviceContext.getService(WeightCleaningService.class);
    }

    public ValidateCruiseOperationsService getValidateCruiseOperationsService() {
        return (ValidateCruiseOperationsService)this.serviceContext.getService(ValidateCruiseOperationsService.class);
    }

    public ValidationService getValidationService() {
        return (ValidationService)this.serviceContext.getService(ValidationService.class);
    }

    public CatchesPdfExportService getGeneratePDFService() {
        return (CatchesPdfExportService)this.serviceContext.getService(CatchesPdfExportService.class);
    }

    public TuttiExportService getTuttiExportService() {
        return (TuttiExportService)this.serviceContext.getService(TuttiExportService.class);
    }

    public CatchesSumatraExportService getCatchesSumatraExportService() {
        return (CatchesSumatraExportService)this.serviceContext.getService(CatchesSumatraExportService.class);
    }

    public MultiPostImportService getMultiPostImportService() {
        return (MultiPostImportService)this.serviceContext.getService(MultiPostImportService.class);
    }

    public MultiPostExportService getMultiPostExportService() {
        return (MultiPostExportService)this.serviceContext.getService(MultiPostExportService.class);
    }

    public ReportService getReportService() {
        return (ReportService)this.serviceContext.getService(ReportService.class);
    }

    public boolean useRealPersistenceService() {
        return this.isDbExist() && this.isDbLoaded();
    }

    public PersistenceService reloadPersistenceService() {
        try {
            this.serviceContext.close();
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.context.service.close.error", (Object[])new Object[0]), (Throwable)e);
        }
        this.dataContext.close();
        return this.getPersistenceService();
    }

    public void reloadDecoratorService() {
        this.serviceContext.reloadService(DecoratorService.class);
    }

    public TuttiDataContext getDataContext() {
        return this.dataContext;
    }

    public boolean isCruiseFilled() {
        return this.dataContext.isCruiseFilled();
    }

    public String getProgramId() {
        return this.dataContext.getProgramId();
    }

    public boolean isProtocolFilled() {
        return this.dataContext.isProtocolFilled();
    }

    public String getProtocolId() {
        return this.dataContext.getProtocolId();
    }

    public String getCruiseId() {
        return this.dataContext.getCruiseId();
    }

    public boolean isProgramFilled() {
        return this.dataContext.isProgramFilled();
    }

    public void setProgramId(String programId) {
        this.dataContext.setProgramId(programId);
    }

    public void setCruiseId(String cruiseId) {
        this.dataContext.setCruiseId(cruiseId);
    }

    public void setProtocolId(String protocolId) {
        this.dataContext.setProtocolId(protocolId);
    }

    public void clearDbContext() {
        this.dataContext.clearContext();
    }

    public void checkDbContext() {
        this.getPersistenceService();
        this.dataContext.checkDbContext();
        this.saveContextToConfig();
    }

    public boolean isDbExist() {
        return this.dbExist;
    }

    public void setDbExist(boolean dbExist) {
        this.dbExist = dbExist;
        this.firePropertyChange(PROPERTY_DB_EXIST, null, dbExist);
    }

    public boolean isDbLoaded() {
        return this.dbLoaded;
    }

    public void setDbLoaded(boolean dbLoaded) {
        this.dbLoaded = dbLoaded;
        this.firePropertyChange(PROPERTY_DB_LOADED, null, dbLoaded);
    }

    public TuttiConfiguration getConfig() {
        return this.config;
    }

    protected void saveContextToConfig() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Save config (programId: " + this.getProgramId() + ", cruiseId: " + this.getCruiseId() + ", protocolId: " + this.getProtocolId() + ", locale: " + this.getLocale() + ")"));
        }
        this.config.setProgramId(this.getProgramId());
        this.config.setCruiseId(this.getCruiseId());
        this.config.setProtocolId(this.getProtocolId());
        this.config.setI18nLocale(this.getLocale());
        this.config.save();
    }

    public MainUI getMainUI() {
        return this.mainUI;
    }

    public void setMainUI(MainUI mainUI) {
        this.mainUI = mainUI;
    }

    public ApplicationActionUI getActionUI() {
        return this.actionUI;
    }

    public ApplicationActionUI getExistingActionUI() {
        while (this.actionUI == null || !this.actionUI.isShowing()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.actionUI;
    }

    public void setActionUI(ApplicationActionUI actionUI) {
        this.actionUI = actionUI;
    }

    public void addInSwingSession(Component c, boolean replace) {
        block2: {
            try {
                this.swingSession.add(c, replace);
                this.saveSwingSession();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)("Could not add component " + c + "in swingSession file: " + this.swingSession.getFile()), (Throwable)e);
            }
        }
    }

    public void saveSwingSession() {
        block2: {
            try {
                this.swingSession.save();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)("Could not save ui config file: " + this.swingSession.getFile()), (Throwable)e);
            }
        }
    }

    public TuttiScreen getScreen() {
        return this.screen;
    }

    public void setScreen(TuttiScreen screen) {
        TuttiScreen oldValue = this.getScreen();
        this.screen = screen;
        this.firePropertyChange(PROPERTY_SCREEN, (Object)oldValue, (Object)screen);
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
        this.firePropertyChange(PROPERTY_BUSY, null, busy);
    }

    public boolean isHideBody() {
        return this.hideBody;
    }

    public void setHideBody(boolean hideBody) {
        this.hideBody = hideBody;
        this.firePropertyChange(PROPERTY_HIDE_BODY, null, hideBody);
    }

    public Color getColorBlockingLayer() {
        return this.getConfig().getColorBlockingLayer();
    }

    public ApplicationActionFactory getActionFactory() {
        return this.tuttiActionFactory;
    }

    public ApplicationActionEngine getActionEngine() {
        return this.tuttiActionEngine;
    }

    public void addMessageNotifier(UIMessageNotifier messageNotifier) {
        this.messageNotifiers.add(messageNotifier);
    }

    public void removeMessageNotifier(UIMessageNotifier messageNotifier) {
        this.messageNotifiers.remove(messageNotifier);
    }

    @Override
    public void showInformationMessage(String message) {
        for (UIMessageNotifier messageNotifier : this.messageNotifiers) {
            messageNotifier.showInformationMessage(message);
        }
    }

    public TuttiHelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public void setHelpBroker(TuttiHelpBroker helpBroker) {
        this.helpBroker = helpBroker;
    }

    public void showHelp(JAXXContext context, JAXXHelpBroker broker, String helpId) {
        String value;
        if (helpId == null) {
            helpId = broker.getDefaultID();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("show help " + helpId));
        }
        if ((value = (String)this.helpMapping.get(helpId)) == null) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.context.helpPage.notFound", (Object[])new Object[]{helpId}));
        }
        String helpDirectory = this.getConfig().getHelpResourceWithLocale(value);
        boolean withFragment = helpDirectory.contains("#");
        String fragment = null;
        if (withFragment) {
            fragment = StringUtils.substringAfter((String)helpDirectory, (String)"#");
            helpDirectory = StringUtils.substringBefore((String)helpDirectory, (String)"#");
        }
        URI resolvedUri = new File(helpDirectory).toURI();
        try {
            if (withFragment) {
                resolvedUri = new URI(resolvedUri.toString() + "#" + fragment);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("help uri = " + resolvedUri));
            }
            TuttiUIUtil.openLink((URI)resolvedUri);
        }
        catch (URISyntaxException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.context.helpPage.notFound", (Object[])new Object[]{resolvedUri}));
        }
    }

    public AuthenticationInfo getAuthenticationInfo(String url) {
        AuthenticationInfo authentication = this.updateAuthenticationStore.get(url);
        if ((authentication = new LoginUI(this).open(url, authentication).getAuthenticationInfo()) != null) {
            this.updateAuthenticationStore.put(url, authentication);
        }
        return authentication;
    }

    public FeedReader getIchtyometerReader() {
        return this.ichtyometerReader;
    }

    public void setIchtyometerReader(FeedReader ichtyometerReader) {
        this.ichtyometerReader = ichtyometerReader;
        this.firePropertyChange(PROPERTY_ICHTYOMETER_CONNECTED, null, this.isIchtyometerConnected());
    }

    public boolean isIchtyometerConnected() {
        return this.ichtyometerReader != null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.firePropertyChange(PROPERTY_LOCALE, null, locale);
    }

    public void setValidationContext(String validationContext) {
        String oldValue = this.getValidationContext();
        this.validationContext = validationContext;
        this.firePropertyChange(PROPERTY_VALIDATION_CONTEXT, oldValue, validationContext);
    }

    public String getValidationContext() {
        return this.validationContext;
    }

    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void setFallBackScreen() {
        if (this.isDbLoaded()) {
            this.setScreen(TuttiScreen.SELECT_CRUISE);
        } else {
            this.setScreen(TuttiScreen.MANAGE_DB);
        }
    }

    public boolean checkUpdateApplicationReachable(boolean showErrorInPopup) {
        boolean result = true;
        TuttiConfiguration config = this.getConfig();
        String url = config.getUpdateApplicationUrl();
        try {
            TuttiUIUtil.tryToConnectToUpdateUrl(url, I18n.n((String)"tutti.error.update.bad.url.syntax", (Object[])new Object[0]), I18n.n((String)"tutti.error.update.could.not.reach.url", (Object[])new Object[0]), I18n.n((String)"tutti.error.update.could.not.found.url", (Object[])new Object[0]));
        }
        catch (ApplicationBusinessException e) {
            if (showErrorInPopup) {
                this.getErrorHelper().showWarningDialog(e.getMessage());
            } else {
                this.showInformationMessage(e.getMessage());
            }
            result = false;
        }
        return result;
    }

    public boolean checkUpdateDataReachable(boolean showErrorInPopup) {
        boolean result = true;
        TuttiConfiguration config = this.getConfig();
        String url = config.getUpdateDataUrl();
        try {
            TuttiUIUtil.tryToConnectToUpdateUrl(url, I18n.n((String)"tutti.error.update.bad.url.syntax", (Object[])new Object[0]), I18n.n((String)"tutti.error.update.could.not.reach.url", (Object[])new Object[0]), I18n.n((String)"tutti.error.update.could.not.found.url", (Object[])new Object[0]));
        }
        catch (ApplicationBusinessException e) {
            if (showErrorInPopup) {
                this.getErrorHelper().showWarningDialog(e.getMessage());
            } else {
                this.showInformationMessage(e.getMessage());
            }
            result = false;
        }
        return result;
    }
}

