/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Attachments;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.pupitri.CarrouselRow;
import fr.ifremer.tutti.service.pupitri.CarrouselRowModel;
import fr.ifremer.tutti.service.pupitri.PupitriCatch;
import fr.ifremer.tutti.service.pupitri.PupitriImportResult;
import fr.ifremer.tutti.service.pupitri.Signs;
import fr.ifremer.tutti.service.pupitri.SpeciesRow;
import fr.ifremer.tutti.service.pupitri.SpeciesRowModel;
import fr.ifremer.tutti.service.pupitri.TrunkRow;
import fr.ifremer.tutti.service.pupitri.TrunkRowModel;
import fr.ifremer.tutti.util.Weights;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class PupitriImportExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(PupitriImportExportService.class);
    protected DecoratorService decoratorService;
    protected PersistenceService persistenceService;
    protected TuttiDataContext dataContext;
    protected CaracteristicQualitativeValue sortedCaracteristic;
    protected CaracteristicQualitativeValue unsortedCaracteristic;
    protected Map<Signs, CaracteristicQualitativeValue> signsToCaracteristicValue;
    public static final Set<Signs> DEFAULT_SIGNS = Sets.newHashSet((Object[])new Signs[]{Signs.DEFAULT});
    public static final Set<Signs> UNSORTED_SIGNS = Sets.newHashSet((Object[])new Signs[]{Signs.UNSORTED});
    public static final Set<Signs> SEX_SIGNS = Sets.newHashSet((Object[])new Signs[]{Signs.DEFAULT, Signs.MALE, Signs.FEMALE});
    public static final Set<Signs> SIZE_SIGNS = Sets.newHashSet((Object[])new Signs[]{Signs.SMALL, Signs.MEDIUM, Signs.BIG});

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.dataContext = context.getDataContext();
        this.signsToCaracteristicValue = Maps.newEnumMap(Signs.class);
        Caracteristic caracteristic = this.persistenceService.getSortedUnsortedCaracteristic();
        this.sortedCaracteristic = CaracteristicQualitativeValues.getQualitativeValue((Caracteristic)caracteristic, (Integer)QualitativeValueId.SORTED_VRAC.getValue());
        this.unsortedCaracteristic = CaracteristicQualitativeValues.getQualitativeValue((Caracteristic)caracteristic, (Integer)QualitativeValueId.SORTED_HORS_VRAC.getValue());
        caracteristic = this.persistenceService.getSexCaracteristic();
        Signs.DEFAULT.registerSign(caracteristic, this.signsToCaracteristicValue);
        Signs.FEMALE.registerSign(caracteristic, this.signsToCaracteristicValue);
        Signs.MALE.registerSign(caracteristic, this.signsToCaracteristicValue);
        caracteristic = this.persistenceService.getSizeCategoryCaracteristic();
        Signs.SMALL.registerSign(caracteristic, this.signsToCaracteristicValue);
        Signs.MEDIUM.registerSign(caracteristic, this.signsToCaracteristicValue);
        Signs.BIG.registerSign(caracteristic, this.signsToCaracteristicValue);
    }

    public PupitriImportResult importPupitri(File trunkFile, File carrouselFile, FishingOperation operation, CatchBatch catchBatch) {
        PupitriImportResult result = new PupitriImportResult(trunkFile, carrouselFile);
        this.importPupitriTrunk(result, trunkFile, operation);
        this.importPupitriCarrousel(result, carrouselFile, operation);
        if (result.isFishingOperationFound()) {
            result.prepareMelag();
            this.savePupitriImportResult(result, operation, catchBatch);
        }
        return result;
    }

    public void exportSpecies(List<Species> species, File target) {
        SpeciesRowModel speciesCsvModel = new SpeciesRowModel(';');
        List rows = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(species)) {
            rows = Lists.transform(species, (Function)new Function<Species, SpeciesRow>(){

                public SpeciesRow apply(Species input) {
                    SpeciesRow row = new SpeciesRow(input);
                    return row;
                }
            });
        }
        try {
            Export.exportToFile((ExportModel)speciesCsvModel, (Iterable)rows, (File)target, (Charset)Charsets.UTF_8, (boolean)false);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.pupitri.export.species.error", (Object[])new Object[]{target}), (Throwable)e);
        }
    }

    protected void addFileAsAttachment(File f, CatchBatch catchBatch) {
        Attachment attachment = Attachments.newAttachment();
        attachment.setObjectType(ObjectTypeCode.CATCH_BATCH);
        attachment.setObjectId(Integer.valueOf(catchBatch.getId()));
        attachment.setName(f.getName());
        String date = DateFormat.getDateTimeInstance().format(this.context.currentDate());
        String comment = I18n.t((String)"tutti.service.pupitri.import.attachment.comment", (Object[])new Object[]{date});
        attachment.setComment(comment);
        this.persistenceService.createAttachment(attachment, f);
    }

    protected void importPupitriTrunk(PupitriImportResult result, File file, FishingOperation operation) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import pupitri operation [" + operation.toString() + "] trunk from file: " + file));
        }
        float sortedWeight = 0.0f;
        float rejectedWeight = 0.0f;
        Import importer = null;
        TrunkRowModel csvModel = new TrunkRowModel(',');
        File fileWithHeaders = this.createFileWithHeaders(csvModel, file);
        Reader reader = ApplicationIOUtil.newReader((File)fileWithHeaders, (String)I18n.n((String)"tutti.service.puttiri.carroussel.import.error", (Object[])new Object[0]));
        try {
            importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            for (TrunkRow bean : importer) {
                if (bean.acceptOperation(operation)) {
                    switch (bean.getDirection()) {
                        case VAT: {
                            sortedWeight += bean.getWeight().floatValue();
                            break;
                        }
                        case VNT: {
                            rejectedWeight += bean.getWeight().floatValue();
                        }
                    }
                    result.incrementNbTrunkImported();
                    continue;
                }
                result.incrementNbTrunkNotImported();
            }
            importer.close();
            reader.close();
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.pupitri.import.trunk.error", (Object[])new Object[]{operation.toString(), file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)importer);
            IOUtils.closeQuietly((Reader)reader);
            FileUtils.deleteQuietly((File)fileWithHeaders);
        }
        result.setSortedWeight(Float.valueOf(Weights.roundKiloGram((float)sortedWeight)));
        if (rejectedWeight > 0.0f) {
            result.setRejectedWeight(Float.valueOf(Weights.roundKiloGram((float)rejectedWeight)));
        }
    }

    protected void importPupitriCarrousel(PupitriImportResult result, File carrouselFile, FishingOperation operation) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import pupitri operation [" + operation.toString() + "] carrousel from file: " + carrouselFile));
        }
        ArrayListMultimap speciesBySurveyCode = ArrayListMultimap.create();
        speciesBySurveyCode.putAll(Speciess.splitBySurveyCode(this.dataContext.getReferentSpeciesWithSurveyCode()));
        speciesBySurveyCode.putAll(Speciess.splitByRefTaxCode(this.dataContext.getReferentSpecies()));
        Float carrouselSortedWeight = Float.valueOf(0.0f);
        ArrayList catches = Lists.newArrayList();
        HashSet notFoundSpecies = Sets.newHashSet();
        Import importer = null;
        CarrouselRowModel carrouselCsvModel = new CarrouselRowModel(',');
        File fileWithHeaders = this.createFileWithHeaders(carrouselCsvModel, carrouselFile);
        Reader reader = ApplicationIOUtil.newReader((File)fileWithHeaders, (String)I18n.n((String)"tutti.service.puttiri.carroussel.import.error", (Object[])new Object[0]));
        try {
            importer = Import.newImport((ImportModel)carrouselCsvModel, (Reader)reader);
            for (CarrouselRow bean : importer) {
                boolean sorted;
                if (!bean.acceptOperation(operation)) continue;
                result.incrementNbCarrousselImported();
                String speciesId = bean.getSpeciesId();
                List speciesList = speciesBySurveyCode.get((Object)speciesId);
                Float beanWeight = bean.getWeight();
                if (beanWeight.floatValue() < 0.0f) {
                    beanWeight = Float.valueOf(0.0f);
                }
                if (sorted = bean.isSorted()) {
                    carrouselSortedWeight = Float.valueOf(carrouselSortedWeight.floatValue() + beanWeight.floatValue());
                }
                if (CollectionUtils.isNotEmpty((Collection)speciesList)) {
                    Species species = (Species)speciesList.get(0);
                    PupitriCatch pupitriCatch = new PupitriCatch(species, sorted);
                    int catchIndex = catches.indexOf(pupitriCatch);
                    if (catchIndex >= 0) {
                        pupitriCatch = (PupitriCatch)catches.get(catchIndex);
                    } else {
                        catches.add(pupitriCatch);
                    }
                    pupitriCatch.addToSign(bean.getSign(), beanWeight);
                    continue;
                }
                notFoundSpecies.add(speciesId);
            }
            importer.close();
            reader.close();
        }
        catch (Exception e) {
            DecoratorService service = this.getService(DecoratorService.class);
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.pupitri.import.carrousel.error", (Object[])new Object[]{carrouselFile, service.getDecorator(operation).toString((Object)operation)}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)importer);
            IOUtils.closeQuietly((Reader)reader);
            FileUtils.deleteQuietly((File)fileWithHeaders);
        }
        result.setNbCarrousselNotImported(notFoundSpecies.size());
        result.setCarrouselSortedWeight(Float.valueOf(Weights.roundKiloGram((float)carrouselSortedWeight.floatValue())));
        result.setCatches(catches);
    }

    protected void savePupitriImportResult(PupitriImportResult result, FishingOperation operation, CatchBatch catchBatch) {
        this.addFileAsAttachment(result.getTrunkFile(), catchBatch);
        this.addFileAsAttachment(result.getCarrousselFile(), catchBatch);
        catchBatch.setCatchTotalSortedTremisWeight(result.getSortedWeight());
        catchBatch.setCatchTotalRejectedWeight(result.getRejectedWeight());
        catchBatch.setCatchTotalSortedCarousselWeight(result.getCarrouselSortedWeight());
        BatchContainer<SpeciesBatch> rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(operation.getId(), false);
        for (SpeciesBatch batch : rootSpeciesBatch.getChildren()) {
            this.persistenceService.deleteSpeciesBatch(batch.getId());
        }
        Decorator<Species> speciesDecorator = this.decoratorService.getDecoratorByType(Species.class);
        for (PupitriCatch pupitriCatch : result.getCatches()) {
            Species species = pupitriCatch.getSpecies();
            CaracteristicQualitativeValue cqv = pupitriCatch.isSorted() ? this.sortedCaracteristic : this.unsortedCaracteristic;
            boolean splitSpecies = this.isSplitSpecies(pupitriCatch);
            Map<Signs, MutableFloat> weightBySign = pupitriCatch.getWeightBySign();
            if (splitSpecies) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Create a categorized batches for species " + speciesDecorator.toString((Object)species)));
                }
                SpeciesBatch batch = this.createSpeciesBatch(operation, species, null, PmfmId.SORTED_UNSORTED.getValue(), (Serializable)cqv);
                batch = this.persistenceService.createSpeciesBatch(batch, null);
                String parentBatchId = batch.getId();
                for (Map.Entry<Signs, MutableFloat> entry : weightBySign.entrySet()) {
                    Signs signs = entry.getKey();
                    float catchWeight = entry.getValue().floatValue();
                    Integer categoryId = signs.getCategory();
                    CaracteristicQualitativeValue splitCqv = this.signsToCaracteristicValue.get((Object)signs);
                    SpeciesBatch childBatch = this.createSpeciesBatch(operation, species, Float.valueOf(catchWeight), categoryId, (Serializable)splitCqv);
                    this.persistenceService.createSpeciesBatch(childBatch, parentBatchId);
                }
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create a unique batch for species " + speciesDecorator.toString((Object)species)));
            }
            float totalWeight = 0.0f;
            for (MutableFloat weight : weightBySign.values()) {
                totalWeight += weight.floatValue();
            }
            SpeciesBatch batch = this.createSpeciesBatch(operation, species, Float.valueOf(totalWeight), PmfmId.SORTED_UNSORTED.getValue(), (Serializable)cqv);
            this.persistenceService.createSpeciesBatch(batch, null);
        }
        this.persistenceService.saveCatchBatch(catchBatch);
    }

    private boolean isSplitSpecies(PupitriCatch speciesCatch) {
        boolean contains;
        Map<Signs, MutableFloat> weightBySign = speciesCatch.getWeightBySign();
        HashSet signs = Sets.newHashSet(weightBySign.keySet());
        boolean result = DEFAULT_SIGNS.equals(signs) ? false : (UNSORTED_SIGNS.equals(signs) ? false : ((contains = signs.removeAll(SEX_SIGNS)) ? signs.isEmpty() : ((contains = signs.removeAll(SIZE_SIGNS)) ? signs.isEmpty() : false)));
        return result;
    }

    protected SpeciesBatch createSpeciesBatch(FishingOperation operation, Species species, Float catchWeight, Integer categoryId, Serializable cqv) {
        SpeciesBatch batch = SpeciesBatchs.newSpeciesBatch();
        batch.setFishingOperation(operation);
        batch.setSampleCategoryId(categoryId);
        batch.setSampleCategoryValue(cqv);
        batch.setSpecies(species);
        batch.setSampleCategoryWeight(catchWeight == null ? null : Float.valueOf(Weights.roundKiloGram((float)catchWeight.floatValue())));
        return batch;
    }

    protected File createFileWithHeaders(TuttiCsvUtil.ImportModelWithHeader<?> model, File file) {
        File fileWithHeaders = new File(FileUtils.getTempDirectory(), file.getName());
        String headers = StringUtils.join((Object[])model.getHeader(), (char)model.getSeparator());
        try {
            FileUtils.writeLines((File)fileWithHeaders, Collections.singletonList(headers));
            FileUtils.writeLines((File)fileWithHeaders, (Collection)FileUtils.readLines((File)file), (boolean)true);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not create file with header " + file, (Throwable)e);
        }
        return fileWithHeaders;
    }
}

