/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.executor.doc.Segment;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;

public abstract class ContainerExecutor
extends ReportItemExecutor {
    private boolean needPrepareNext = true;
    protected boolean prepareFirstChild = true;
    protected Object[][] sections = null;
    protected boolean useNextSection = true;
    protected int nextSection = -1;
    protected long nextOffset = -1L;
    private IReportItemExecutor childExecutor;

    protected ContainerExecutor(ExecutorManager manager, int type) {
        super(manager, type);
    }

    @Override
    public void close() {
        if (this.nextOffset != -1L) {
            this.reader.unloadContent(this.nextOffset);
            this.nextOffset = -1L;
        }
        this.prepareFirstChild = true;
        this.needPrepareNext = true;
        this.sections = null;
        this.useNextSection = true;
        this.nextSection = -1;
        this.nextOffset = -1L;
        super.close();
    }

    @Override
    public boolean hasNextChild() {
        if (this.needPrepareNext) {
            try {
                this.childExecutor = this.prepareChildExecutor();
            }
            catch (Exception ex) {
                this.childExecutor = null;
                logger.log(Level.WARNING, ex.getMessage(), ex);
                this.context.addException(this.getDesign(), (BirtException)new EngineException(ex.getLocalizedMessage(), ex));
            }
            this.needPrepareNext = false;
        }
        return this.childExecutor != null;
    }

    @Override
    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            this.needPrepareNext = true;
            return this.childExecutor;
        }
        return null;
    }

    protected IReportItemExecutor prepareChildExecutor() throws Exception {
        IContent childContent;
        ReportItemExecutor childExecutor;
        if (this.prepareFirstChild) {
            DocumentExtension docExt;
            if (this.fragment == null && this.nextOffset == -1L && (docExt = (DocumentExtension)this.content.getExtension(0)) != null) {
                this.nextOffset = docExt.getFirstChild();
            }
            if (this.fragment != null && this.sections == null) {
                this.sections = this.fragment.getSections();
                this.nextSection = -1;
                this.useNextSection = true;
            }
            this.prepareFirstChild = false;
        }
        if (this.fragment != null && this.useNextSection) {
            this.useNextSection = false;
            ++this.nextSection;
            if (this.sections == null || this.nextSection >= this.sections.length) {
                return null;
            }
            Object leftEdge = this.sections[this.nextSection][0];
            if (leftEdge == Segment.LEFT_MOST_EDGE) {
                DocumentExtension docExt = (DocumentExtension)this.content.getExtension(0);
                if (docExt != null) {
                    this.nextOffset = docExt.getFirstChild();
                }
            } else {
                DocumentExtension docExt;
                InstanceIndex leftIndex = (InstanceIndex)leftEdge;
                InstanceID leftId = leftIndex.getInstanceID();
                long leftOffset = leftIndex.getOffset();
                if (leftOffset == -1L && (docExt = (DocumentExtension)this.content.getExtension(0)) != null) {
                    leftOffset = docExt.getFirstChild();
                }
                while (leftOffset != -1L) {
                    IContent leftContent = this.reader.loadContent(leftOffset);
                    InstanceID contentId = leftContent.getInstanceID();
                    if (this.compare(leftId, contentId) <= 0) break;
                    this.reader.unloadContent(leftOffset);
                    DocumentExtension docExt2 = (DocumentExtension)leftContent.getExtension(0);
                    assert (docExt2 != null);
                    leftOffset = docExt2.getNext();
                }
                this.nextOffset = leftOffset;
                this.doSkipToExecutor(leftId, this.nextOffset);
                this.uniqueId = leftId.getUniqueID();
            }
        }
        if ((childExecutor = this.doCreateExecutor(this.nextOffset)) != null && (childContent = childExecutor.execute()) != null) {
            DocumentExtension docExt;
            if (this.fragment != null) {
                InstanceIndex rightIndex;
                InstanceID rightId;
                Object rightEdge;
                InstanceID childId = childContent.getInstanceID();
                Fragment childFragment = this.fragment.getFragment(childId);
                if (childFragment != null) {
                    childExecutor.setFragment(childFragment);
                }
                if ((rightEdge = this.sections[this.nextSection][1]) != Segment.RIGHT_MOST_EDGE && this.isSameInstance(rightId = (rightIndex = (InstanceIndex)rightEdge).getInstanceID(), childId)) {
                    this.useNextSection = true;
                }
            }
            if ((docExt = (DocumentExtension)childContent.getExtension(0)) != null && docExt.getIndex() == this.nextOffset) {
                this.nextOffset = docExt.getNext();
            }
        }
        return childExecutor;
    }

    protected abstract ReportItemExecutor doCreateExecutor(long var1) throws Exception;

    protected abstract void doSkipToExecutor(InstanceID var1, long var2) throws Exception;
}

