/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapCellComponent;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapColumnUIHandler;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellEditor;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.table.CaracteristicColumnIdentifier;
import fr.ifremer.tutti.util.Numbers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;
import org.nuiton.validator.NuitonValidatorResult;

public class IndividualObservationBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<IndividualObservationBatchRowModel, IndividualObservationBatchUIModel, IndividualObservationBatchTableModel, IndividualObservationBatchUI>
implements CaracteristicMapColumnUIHandler {
    private static final Log log = LogFactory.getLog(IndividualObservationBatchUIHandler.class);
    protected WeightUnit weightUnit;
    protected WeightUnit speciesWeightUnit;
    public Integer PMFM_ID_SORTED_UNSORTED;

    public IndividualObservationBatchUIHandler() {
        super("species", "weight", "size", "lengthStepCaracteristic", "caracteristics", "defaultCaracteristics", "comment", "attachment");
    }

    @Override
    protected ColumnIdentifier<IndividualObservationBatchRowModel> getCommentIdentifier() {
        return IndividualObservationBatchTableModel.COMMENT;
    }

    @Override
    protected ColumnIdentifier<IndividualObservationBatchRowModel> getAttachementIdentifier() {
        return IndividualObservationBatchTableModel.ATTACHMENT;
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        IndividualObservationBatchUIModel model = (IndividualObservationBatchUIModel)this.getModel();
        if (empty) {
            rows = null;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Get individualObservation batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew(bean)) {
                PersistenceService persistenceService = this.getPersistenceService();
                List batches = persistenceService.getAllIndividualObservationBatch(bean.getId());
                for (IndividualObservationBatch aBatch : batches) {
                    List speciesList;
                    int i;
                    if (this.getDataContext().isProtocolFilled() && (i = (speciesList = this.getDataContext().getReferentSpeciesWithSurveyCode()).indexOf(aBatch.getSpecies())) > -1) {
                        aBatch.setSpecies((Species)speciesList.get(i));
                    }
                    IndividualObservationBatchRowModel entry = new IndividualObservationBatchRowModel(this.weightUnit, aBatch, ((IndividualObservationBatchUIModel)this.getModel()).getDefaultCaracteristic());
                    List attachments = persistenceService.getAllAttachments(entry.getObjectType(), entry.getObjectId());
                    entry.addAllAttachment(attachments);
                    rows.add(entry);
                }
            }
        }
        model.setRows(rows);
    }

    public IndividualObservationBatchTableModel getTableModel() {
        return (IndividualObservationBatchTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((IndividualObservationBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(IndividualObservationBatchRowModel row) {
        IndividualObservationBatch batch = (IndividualObservationBatch)row.toBean();
        NuitonValidatorResult validator = this.getValidationService().validateEditIndividualObservationBatch(batch);
        boolean result = !validator.hasErrorMessagess();
        return result;
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<IndividualObservationBatchRowModel> rowMonitor, IndividualObservationBatchRowModel row) {
        if (row != null && row.isValid() && rowMonitor.wasModified()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Row " + row + " was modified, will save it"));
            }
            String title = this.buildReminderLabelTitle(row.getSpecies(), null, "Sauvegarde de Donn\u00e9es individuelles : ", "Ligne :" + (this.getTableModel().getRowIndex(row) + 1));
            this.showInformationMessage(title);
            rowMonitor.setBean(null);
            this.saveRow(row);
            rowMonitor.setBean(row);
            rowMonitor.clearModified();
        }
    }

    public SwingValidator<IndividualObservationBatchUIModel> getValidator() {
        return ((IndividualObservationBatchUI)this.ui).getValidator();
    }

    public void beforeInit(IndividualObservationBatchUI ui) {
        super.beforeInit((ApplicationUI)ui);
        if (log.isDebugEnabled()) {
            log.debug((Object)("beforeInit: " + ui));
        }
        this.weightUnit = this.getConfig().getIndividualObservationWeightUnit();
        this.speciesWeightUnit = this.getConfig().getSpeciesWeightUnit();
        this.PMFM_ID_SORTED_UNSORTED = this.getPersistenceService().getSortedUnsortedCaracteristic().getIdAsInt();
        List defaultCaracteristic = this.getDataContext().getDefaultIndividualObservationCaracteristics();
        EditCatchesUIModel catchesUIModel = ui.getContextValue(EditCatchesUIModel.class);
        IndividualObservationBatchUIModel model = new IndividualObservationBatchUIModel(catchesUIModel, defaultCaracteristic);
        ui.setContextValue(model);
    }

    public void afterInit(IndividualObservationBatchUI ui) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("afterInit: " + ui));
        }
        this.initUI(ui);
        JXTable table = this.getTable();
        table.setColumnControlVisible(true);
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        Decorator<Caracteristic> caracteristicDecorator = this.getDecorator(Caracteristic.class, "parameterOnlyWithUnit");
        Decorator<Caracteristic> caracteristicTipDecorator = this.getDecorator(Caracteristic.class, "withUnit");
        Decorator<CaracteristicQualitativeValue> caracteristicQualitativeDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        Decorator<Species> speciesDecorator = this.getDecorator(Species.class, "fromProtocol");
        this.addComboDataColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.SPECIES, speciesDecorator, this.getDataContext().getReferentSpeciesWithSurveyCode());
        this.addFloatColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.WEIGHT, this.weightUnit, (JTable)table);
        this.addFloatColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.SIZE, "\\d{0,6}(\\.\\d{0,3})?", (JTable)table);
        this.addComboDataColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.LENGTH_STEP_CARACTERISTIC, this.getDecorator(Caracteristic.class, null), this.getDataContext().getLengthStepCaracteristics());
        List<Caracteristic> defaultCaracteristic = ((IndividualObservationBatchUIModel)this.getModel()).getDefaultCaracteristic();
        for (Caracteristic caracteristic : defaultCaracteristic) {
            String header = caracteristicDecorator.toString((Object)caracteristic);
            String headerTip = caracteristicTipDecorator.toString((Object)caracteristic);
            CaracteristicColumnIdentifier id = CaracteristicColumnIdentifier.newCaracteristicId(caracteristic, "defaultCaracteristics", header, headerTip);
            switch (caracteristic.getCaracteristicType()) {
                case NUMBER: {
                    this.addFloatColumnToModel((TableColumnModel)columnModel, id, "\\d{0,6}(\\.\\d{0,3})?", (JTable)table);
                    break;
                }
                case QUALITATIVE: {
                    List<CaracteristicQualitativeValue> values = caracteristic.getQualitativeValue();
                    this.addComboDataColumnToModel((TableColumnModel)columnModel, id, caracteristicQualitativeDecorator, values);
                    break;
                }
                case TEXT: {
                    this.addColumnToModel((TableColumnModel)columnModel, id);
                }
            }
        }
        Set<Caracteristic> caracteristicsToSkip = Collections.unmodifiableSet(Sets.newHashSet(((IndividualObservationBatchUIModel)this.getModel()).getDefaultCaracteristic()));
        this.addColumnToModel((TableColumnModel)columnModel, CaracteristicMapCellComponent.newEditor(ui, caracteristicsToSkip), CaracteristicMapCellComponent.newRender(this.getContext()), IndividualObservationBatchTableModel.OTHER_CARACTERISTICS);
        this.addColumnToModel((TableColumnModel)columnModel, CommentCellEditor.newEditor(ui), CommentCellRenderer.newRender(), IndividualObservationBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(ui), AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null)), IndividualObservationBatchTableModel.ATTACHMENT);
        IndividualObservationBatchTableModel tableModel = new IndividualObservationBatchTableModel(this.weightUnit, (TableColumnModelExt)columnModel);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModelExt)columnModel, tableModel);
    }

    protected void beforeOpenPopup(int rowIndex, int columnIndex) {
        super.beforeOpenPopup(rowIndex, columnIndex);
        boolean enableRemove = false;
        if (rowIndex != -1) {
            enableRemove = true;
        }
        IndividualObservationBatchUIModel model = (IndividualObservationBatchUIModel)this.getModel();
        model.setRemoveBatchEnabled(enableRemove);
    }

    protected JComponent getComponentToFocus() {
        return ((IndividualObservationBatchUI)this.getUI()).getTable();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
    }

    @Override
    public CaracteristicMapEditorUI getCaracteristicMapEditor() {
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        return parent.getIndividualObservationCaracteristicMapEditor();
    }

    @Override
    public void showCaracteristicMapEditor(Species species) {
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        parent.getHandler().setIndividualObservationSelectedCard("caracteristicsCard", species);
    }

    @Override
    public void hideCaracteristicMapEditor() {
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        parent.getHandler().setIndividualObservationSelectedCard("main");
    }

    public void createBatch() {
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        CreateIndividualObservationBatchUI createBatchEditor = parent.getIndividualObservationTabCreateBatch();
        createBatchEditor.getHandler().openUI((IndividualObservationBatchUIModel)this.getModel());
        parent.getHandler().setIndividualObservationSelectedCard("createBatch");
    }

    public void addBatch(CreateIndividualObservationBatchUIModel model) {
        if (model.isValid()) {
            IndividualObservationBatchTableModel tableModel = this.getTableModel();
            if (model.isCreateFromBatch()) {
                boolean create;
                Species species = model.getSpecies();
                String speciesStr = this.decorate(species);
                if (!model.isSpeciesFromBatchWithCount()) {
                    String htmlMessage = String.format("<html>%s</html>", I18n.t((String)"tutti.createIndividualObservationBatch.warn.nocount", (Object[])new Object[]{speciesStr}));
                    JOptionPane.showMessageDialog(this.getContext().getMainUI(), htmlMessage, I18n.t((String)"tutti.createIndividualObservationBatch.warn.nocount.title", (Object[])new Object[0]), 2);
                    return;
                }
                Set<Species> speciesUsed = ((IndividualObservationBatchUIModel)this.getModel()).getSpeciesUsed();
                if (speciesUsed.contains(species)) {
                    boolean create2;
                    String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.createIndividualObservationBatch.confirm.alreadyUsedSpecies.message", (Object[])new Object[]{speciesStr}), I18n.t((String)"tutti.createIndividualObservationBatch.confirm.alreadyUsedSpecies.help", (Object[])new Object[0]));
                    int response = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n.t((String)"tutti.createIndividualObservationBatch.confirm.alreadyUsedSpecies.title", (Object[])new Object[0]), 2, 2);
                    boolean bl = create2 = response == 0;
                    if (!create2) {
                        return;
                    }
                }
                EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
                SpeciesBatchUIModel speciesBatchUIModel = parent.getSpeciesTabContent().getModel();
                List<SpeciesBatchRowModel> leafs = speciesBatchUIModel.getLeafs(species);
                ArrayList rowsToCreate = Lists.newArrayList();
                CaracteristicMap defaultCaracteristics = new CaracteristicMap();
                defaultCaracteristics.putAll(model.getCaracteristics());
                ArrayList defaultCaracteristic = Lists.newArrayList(model.getDefaultCaracteristic());
                defaultCaracteristic.addAll(defaultCaracteristics.keySet());
                for (SpeciesBatchRowModel leaf : leafs) {
                    CaracteristicMap batchCaracteristics = new CaracteristicMap();
                    for (SampleCategory<?> sampleCategory : leaf) {
                        if (this.PMFM_ID_SORTED_UNSORTED.equals(sampleCategory.getCategoryId()) || sampleCategory.getCategoryValue() == null) continue;
                        if (defaultCaracteristic.contains(sampleCategory.getCategoryDef().getCaracteristic())) {
                            defaultCaracteristics.put(sampleCategory.getCategoryDef().getCaracteristic(), sampleCategory.getCategoryValue());
                            continue;
                        }
                        batchCaracteristics.put(sampleCategory.getCategoryDef().getCaracteristic(), sampleCategory.getCategoryValue());
                    }
                    List<SpeciesFrequencyRowModel> frequencies = leaf.getFrequency();
                    if (CollectionUtils.isEmpty(frequencies)) {
                        int nbRow = Numbers.getValueOrComputedValue(leaf.getNumber(), 0);
                        for (int i = 0; i < nbRow; ++i) {
                            IndividualObservationBatchRowModel newRow = tableModel.createNewRow();
                            newRow.setSpecies(species);
                            newRow.getCaracteristics().putAll(batchCaracteristics);
                            rowsToCreate.add(newRow);
                        }
                        if (nbRow != 1) continue;
                        IndividualObservationBatchRowModel lastRow = (IndividualObservationBatchRowModel)rowsToCreate.get(rowsToCreate.size() - 1);
                        Float weight = Numbers.getValueOrComputedValue(leaf.getWeight(), leaf.getFinestCategory().getCategoryWeight());
                        if (weight != null) {
                            weight = this.speciesWeightUnit.toEntity(weight);
                            weight = this.weightUnit.fromEntity(weight);
                        }
                        lastRow.setWeight(weight);
                        continue;
                    }
                    boolean withOneFrequency = frequencies.size() == 1;
                    for (SpeciesFrequencyRowModel frequency : frequencies) {
                        int nbRow = Numbers.getValueOrComputedValue(frequency.getNumber(), 0);
                        Float weight = null;
                        if (nbRow == 1) {
                            weight = frequency.getWeight();
                            if (weight == null && withOneFrequency) {
                                weight = Numbers.getValueOrComputedValue(leaf.getWeight(), leaf.getFinestCategory().getCategoryWeight());
                            }
                            if (weight != null) {
                                weight = this.speciesWeightUnit.toEntity(weight);
                                weight = this.weightUnit.fromEntity(weight);
                            }
                        }
                        for (int i = 0; i < nbRow; ++i) {
                            IndividualObservationBatchRowModel newRow = tableModel.createNewRow();
                            newRow.setSpecies(species);
                            newRow.setWeight(weight);
                            newRow.setSize(frequency.getLengthStep());
                            newRow.setLengthStepCaracteristic(frequency.getLengthStepCaracteristic());
                            newRow.getCaracteristics().putAll(batchCaracteristics);
                            newRow.getDefaultCaracteristics().putAll(defaultCaracteristics);
                            rowsToCreate.add(newRow);
                        }
                    }
                }
                int nbRowsToCreate = rowsToCreate.size();
                int maxIndividualObservationRowsToCreate = this.getConfig().getMaxIndividualObservationRowsToCreate();
                if (maxIndividualObservationRowsToCreate < nbRowsToCreate) {
                    String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.createIndividualObservationBatch.confirm.message", (Object[])new Object[]{speciesStr, nbRowsToCreate}), I18n.t((String)"tutti.createIndividualObservationBatch.confirm.help", (Object[])new Object[0]));
                    int response = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n.t((String)"tutti.createIndividualObservationBatch.confirm.title", (Object[])new Object[0]), 2, 2);
                    create = response == 0;
                } else {
                    create = true;
                }
                if (create) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Will create " + rowsToCreate.size() + " individual observation batches"));
                    }
                    for (IndividualObservationBatchRowModel newRow : rowsToCreate) {
                        this.recomputeRowValidState(newRow);
                        this.saveRow(newRow);
                        tableModel.addNewRow(newRow);
                    }
                    TuttiUIUtil.selectFirstCellOnLastRow((JXTable)this.getTable());
                }
            } else {
                IndividualObservationBatchRowModel newRow = tableModel.createNewRow();
                newRow.setSpecies(model.getSpecies());
                newRow.setWeight(model.getWeight());
                newRow.setSize(model.getSize());
                newRow.setLengthStepCaracteristic(model.getLengthStepCaracteristic());
                newRow.getDefaultCaracteristics().putAll(model.getCaracteristics());
                this.recomputeRowValidState(newRow);
                this.saveRow(newRow);
                tableModel.addNewRow(newRow);
                TuttiUIUtil.selectFirstCellOnLastRow((JXTable)this.getTable());
            }
        }
    }

    protected void saveRow(IndividualObservationBatchRowModel row) {
        Serializable value;
        IndividualObservationBatch entityToSave = row.toEntity();
        CaracteristicMap caracteristics = new CaracteristicMap();
        entityToSave.setCaracteristics(caracteristics);
        for (Map.Entry entry : row.getCaracteristics().entrySet()) {
            value = (Serializable)entry.getValue();
            if (value == null) continue;
            caracteristics.put(entry.getKey(), value);
        }
        for (Map.Entry entry : row.getDefaultCaracteristics().entrySet()) {
            value = (Serializable)entry.getValue();
            if (value == null) continue;
            caracteristics.put(entry.getKey(), value);
        }
        FishingOperation fishingOperation = ((IndividualObservationBatchUIModel)this.getModel()).getFishingOperation();
        entityToSave.setFishingOperation(fishingOperation);
        if (TuttiEntities.isNew(entityToSave)) {
            entityToSave = this.getPersistenceService().createIndividualObservationBatch(entityToSave);
            row.setId(entityToSave.getId());
        } else {
            this.getPersistenceService().saveIndividualObservationBatch(entityToSave);
        }
        ((IndividualObservationBatchUIModel)this.getModel()).fireBatchUpdated(row);
    }
}

