/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeValue;
import org.eclipse.birt.core.btree.BTreeValues;

public class SingleValueList<K, V>
implements BTreeValues<V> {
    private BTree<K, V> btree;
    private SingleValue value;

    SingleValueList(BTree<K, V> btree) {
        this.btree = btree;
    }

    SingleValueList(BTree<K, V> btree, BTreeValue<V> v) {
        this.btree = btree;
        this.value = new SingleValue(v);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void read(DataInput in) throws IOException {
        BTreeValue<V> v = this.btree.readValue(in);
        this.value = new SingleValue(v);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.btree.writeValue(out, this.value.getValue());
    }

    @Override
    public int getValueCount() {
        return 1;
    }

    @Override
    public int getValueSize() {
        return this.btree.getValueSize(this.value.getValue());
    }

    @Override
    public BTreeValues.Value<V> getFirstValue() {
        return this.value;
    }

    @Override
    public BTreeValues.Value<V> getLastValue() {
        return this.value;
    }

    @Override
    public BTreeValues.Value<V> append(BTreeValue<V> value) {
        throw new UnsupportedOperationException("append");
    }

    private class SingleValue
    implements BTreeValues.Value<V> {
        BTreeValue<V> value;

        SingleValue(BTreeValue<V> value) {
            this.value = value;
        }

        @Override
        public BTreeValues.Value<V> getNext() throws IOException {
            return null;
        }

        @Override
        public BTreeValues.Value<V> getPrev() throws IOException {
            return null;
        }

        @Override
        public BTreeValue<V> getValue() {
            return this.value;
        }
    }
}

