/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

class ListingElementExecutorUtil {
    private static final int EXECUTE_FROM_CURRENT_ROW = 0;
    private static final int EXECUTE_FROM_NEXT_ROW = 1;
    private static final int EXECUTE_END = 3;
    int group;
    ReportItemDesign header;
    ReportItemDesign child;
    ReportItemDesign footer;
    IQueryResultSet rset;
    int executeState;
    boolean includeHeader;

    ListingElementExecutorUtil(int group, ReportItemDesign header, ReportItemDesign footer, ReportItemDesign child, IQueryResultSet rset) {
        this(group, header, footer, child, rset, true);
    }

    ListingElementExecutorUtil(int group, ReportItemDesign header, ReportItemDesign footer, ReportItemDesign child, IQueryResultSet rset, boolean fromBegin) {
        this.group = group;
        this.header = header;
        this.footer = footer;
        this.child = child;
        this.rset = rset;
        this.executeState = 0;
        this.includeHeader = fromBegin;
    }

    public void startFromCurrentRow() {
        if (this.executeState != 3) {
            this.executeState = 0;
        }
    }

    int collectExecutableElements(ReportItemDesign[] executableElements) throws BirtException {
        while (this.executeState != 3) {
            int totalElements = this.doCollectExecutableElements(executableElements);
            if (totalElements == 0) continue;
            return totalElements;
        }
        return 0;
    }

    private int doCollectExecutableElements(ReportItemDesign[] executableElements) throws BirtException {
        int totalElements = 0;
        switch (this.executeState) {
            case 0: {
                if (this.includeHeader && this.header != null) {
                    this.includeHeader = false;
                    executableElements[totalElements++] = this.header;
                }
                if (this.child != null) {
                    executableElements[totalElements++] = this.child;
                }
                this.executeState = 1;
                if (!this.isGroupEnd()) break;
                if (this.footer != null) {
                    executableElements[totalElements++] = this.footer;
                }
                this.executeState = 3;
                break;
            }
            case 1: {
                if (this.isGroupEnd()) {
                    if (this.footer != null) {
                        executableElements[totalElements++] = this.footer;
                    }
                    this.executeState = 3;
                    return totalElements;
                }
                if (!this.rset.next()) break;
                if (this.child != null) {
                    executableElements[totalElements++] = this.child;
                }
                if (this.isGroupEnd()) {
                    if (this.footer != null) {
                        executableElements[totalElements++] = this.footer;
                    }
                    this.executeState = 3;
                }
                return totalElements;
            }
        }
        return totalElements;
    }

    boolean isGroupEnd() throws BirtException {
        int groupLevel = this.rset.getEndingGroupLevel();
        return groupLevel <= this.group;
    }
}

