/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.util.concurrent.TimeUnit;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SuccessCallback;

public class AsyncResult<V>
implements ListenableFuture<V> {
    private final V value;

    public AsyncResult(V value) {
        this.value = value;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return true;
    }

    public V get() {
        return this.value;
    }

    public V get(long timeout, TimeUnit unit) {
        return this.value;
    }

    public void addCallback(ListenableFutureCallback<? super V> callback) {
        this.addCallback((SuccessCallback<? super V>)callback, (FailureCallback)callback);
    }

    public void addCallback(SuccessCallback<? super V> successCallback, FailureCallback failureCallback) {
        try {
            successCallback.onSuccess(this.value);
        }
        catch (Throwable t) {
            failureCallback.onFailure(t);
        }
    }
}

