/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.referential;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.AbstractSpeciess;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Speciess
extends AbstractSpeciess {
    public static final Comparator<Species> SPECIES_BY_NAME_COMPARATOR = new Comparator<Species>(){

        @Override
        public int compare(Species o1, Species o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    };
    public static final Function<Species, String> GET_TAXON_ID = new Function<Species, String>(){

        public String apply(Species input) {
            return String.valueOf(input.getReferenceTaxonId());
        }
    };
    public static final Function<Species, String> GET_REF_TAX_CODE = new Function<Species, String>(){

        public String apply(Species input) {
            return String.valueOf(input.getRefTaxCode());
        }
    };
    public static final Function<Species, String> GET_SURVEY_CODE = new Function<Species, String>(){

        public String apply(Species input) {
            return String.valueOf(input.getSurveyCode());
        }
    };

    public static Map<String, Species> splitByTaxonId(Iterable<Species> list) {
        return Maps.uniqueIndex(list, GET_TAXON_ID);
    }

    public static Multimap<String, Species> splitByReferenceTaxonId(Iterable<Species> list) {
        return Multimaps.index(list, GET_TAXON_ID);
    }

    public static Multimap<String, Species> splitByRefTaxCode(Iterable<Species> list) {
        return Multimaps.index(list, GET_REF_TAX_CODE);
    }

    public static Multimap<String, Species> splitBySurveyCode(Iterable<Species> list) {
        return Multimaps.index(list, GET_SURVEY_CODE);
    }

    public static Set<String> toTaxonIds(List<Species> list) {
        HashSet result = list == null ? Collections.emptySet() : Sets.newHashSet((Iterable)Lists.transform(list, GET_TAXON_ID));
        return result;
    }
}

