/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.util.List;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfo;

public final class GroupUtil {
    static final int rowidIndex = 0;
    static final String rowidName = "_rowPosition";

    private GroupUtil() {
    }

    public static boolean isRowIdColumn(int columnIndex, String columnName) {
        return columnIndex == 0 || columnName.matches("\\Q_{$TEMP_GROUP_\\E.*\\QROWID$}_\\E");
    }

    static boolean isWithinInterval(double startValue, double intervalValue, double currValue, double prevValue) {
        assert (intervalValue != 0.0);
        boolean isSame = false;
        double curr = (currValue - startValue) / intervalValue;
        double prev = (prevValue - startValue) / intervalValue;
        if (curr < 0.0 && prev < 0.0) {
            return true;
        }
        if (curr < 0.0 || prev < 0.0) {
            return false;
        }
        int currDiv = (int)curr;
        int prevDiv = (int)prev;
        if (currDiv == prevDiv) {
            isSame = true;
        }
        return isSame;
    }

    public static int getGroupFirstRowIndex(int groupLevel, int groupIndex, List[] groups, int count) {
        int rowIndex;
        if (groupIndex < groups[groupLevel - 1].size()) {
            int i = groupLevel - 1;
            while (i < groups.length) {
                GroupInfo groupInfo = GroupUtil.findGroup(i, groupIndex, groups);
                groupIndex = groupInfo.firstChild;
                ++i;
            }
            rowIndex = groupIndex;
        } else {
            rowIndex = count;
        }
        return rowIndex;
    }

    static GroupInfo findGroup(int groupLevel, int groupIndex, List[] groups) {
        if (groupIndex >= groups[groupLevel].size()) {
            return null;
        }
        return (GroupInfo)groups[groupLevel].get(groupIndex);
    }
}

