/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor;

import com.google.common.base.Preconditions;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatterFactory;
import jaxx.runtime.spi.UIHandler;
import jaxx.runtime.swing.editor.NumberEditor2;
import jaxx.runtime.swing.editor.NumberEditor2Model;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.swing.editor.gis.DmdCoordinate;
import jaxx.runtime.swing.editor.gis.DmdCoordinateConverter;
import jaxx.runtime.swing.editor.gis.MaskFormatterFromConverter;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NumberEditor2Handler
implements UIHandler<NumberEditor2> {
    private static final Log log = LogFactory.getLog(NumberEditor2Handler.class);
    protected NumberEditor2 ui;
    protected JFormattedTextField editor;
    protected DmdCoordinateConverter signedConverter;
    protected DmdCoordinateConverter unsignedConverter;
    protected DefaultFormatterFactory signedFormatterFactory;
    protected DefaultFormatterFactory unsignedFormatterFactory;
    protected Method mutator;
    protected Method getter;
    protected Boolean acceptNull;
    protected NumberEditor2Model model;
    protected String lastValidText;

    public void beforeInit(NumberEditor2 ui) {
        this.ui = ui;
    }

    public void afterInit(NumberEditor2 ui) {
        this.model = ui.getModel();
        this.editor = ui.getEditor();
    }

    public void init() {
        MaskFormatterFromConverter<DmdCoordinate> maskFormatter;
        Preconditions.checkNotNull((Object)this.model.getBean(), (Object)("could not find bean in " + (Object)((Object)this.model)));
        Preconditions.checkNotNull((Object)this.model.getBeanProperty(), (Object)("could not find beanProperty in " + (Object)((Object)this.model)));
        Preconditions.checkNotNull(this.model.getNumberType(), (Object)("could not find numberType in " + (Object)((Object)this.model)));
        Object bean = this.model.getBean();
        this.mutator = BeanUIUtil.getMutator(bean, this.model.getBeanProperty());
        Preconditions.checkNotNull((Object)this.mutator, (Object)("could not find mutator for " + this.model.getBeanProperty()));
        String pattern = this.getMaskFormatterPattern(false);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DmdCoordinate.class, pattern, (Converter)this.unsignedConverter);
            maskFormatter.setValidCharacters(" 01234567890.");
            maskFormatter.setCommitsOnValidEdit(true);
            this.unsignedFormatterFactory = new DefaultFormatterFactory(maskFormatter);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        pattern = this.getMaskFormatterPattern(true);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DmdCoordinate.class, pattern, (Converter)this.signedConverter);
            maskFormatter.setValidCharacters(" 01234567890.");
            maskFormatter.setCommitsOnValidEdit(true);
            this.signedFormatterFactory = new DefaultFormatterFactory(maskFormatter);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public void setModel(Object model) {
    }

    void addChar(String s) {
        char c = s.charAt(0);
        try {
            this.editor.getDocument().insertString(this.editor.getCaretPosition(), c + "", null);
        }
        catch (BadLocationException e) {
            log.warn((Object)e);
        }
    }

    public void removeChar() {
    }

    public void toggleSign() {
    }

    void addChar(ActionEvent event) {
        String text = ((JButton)event.getSource()).getText();
        this.addChar(text);
    }

    public void setPopupVisible(Boolean newValue) {
        if (log.isTraceEnabled()) {
            log.trace((Object)newValue);
        }
        if (newValue == null || !newValue.booleanValue()) {
            this.ui.getPopup().setVisible(false);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent invoker = NumberEditor2Handler.this.model.isShowPopup() ? NumberEditor2Handler.this.ui.getShowPopUpButton() : NumberEditor2Handler.this.ui;
                Dimension dim = NumberEditor2Handler.this.ui.getPopup().getPreferredSize();
                int x = (int)(invoker.getPreferredSize().getWidth() - dim.getWidth());
                NumberEditor2Handler.this.ui.getPopup().show(invoker, x, invoker.getHeight());
                NumberEditor2Handler.this.ui.getEditor().requestFocus();
            }
        });
    }

    protected String getMaskFormatterPattern(boolean useSign) {
        String pattern = "############";
        if (useSign) {
            pattern = "-" + pattern;
        }
        return pattern;
    }

    public void validate() {
    }

    public void resetEditor() {
    }

    public void onKeyReleased(KeyEvent event) {
    }

    public void setValue(Number value, boolean b) {
    }

    protected class PopupListener
    extends MouseAdapter {
        protected PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        protected void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            if (NumberEditor2Handler.this.model.isAutoPopup()) {
                if (NumberEditor2Handler.this.model.isPopupVisible()) {
                    if (!NumberEditor2Handler.this.ui.getPopup().isVisible()) {
                        NumberEditor2Handler.this.setPopupVisible(true);
                    }
                } else {
                    NumberEditor2Handler.this.model.setPopupVisible(true);
                }
            } else if (NumberEditor2Handler.this.model.isPopupVisible()) {
                NumberEditor2Handler.this.setPopupVisible(true);
            }
        }
    }
}

