// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.location;

import fr.ifremer.adagio.core.dao.referential.Status;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
 * surfacique.
 * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche, un
 * quartier maritime, une criée, etc.
 * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités : 200
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Location
    implements Serializable, Comparable<Location>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 302507620770234855L;

    // Generate 7 attributes
    private Integer id;

    /**
     * Identifiant unique du lieu. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant unique du lieu. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String label;

    /**
     * Code du lieuExemple : pour les ports : BR, SB
     * @return this.label String
     */
    public String getLabel()
    {
        return this.label;
    }

    /**
     * Code du lieuExemple : pour les ports : BR, SB
     * @param labelIn String
     */
    public void setLabel(String labelIn)
    {
        this.label = labelIn;
    }

    private String name;

    /**
     * Libellé du lieu
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Libellé du lieu
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private Float bathymetry;

    /**
     * Valeur de la bathymétrie sur le lieu (optionnel). La bathymétrie peut être positive ou
     * négative.
     * @return this.bathymetry Float
     */
    public Float getBathymetry()
    {
        return this.bathymetry;
    }

    /**
     * Valeur de la bathymétrie sur le lieu (optionnel). La bathymétrie peut être positive ou
     * négative.
     * @param bathymetryIn Float
     */
    public void setBathymetry(Float bathymetryIn)
    {
        this.bathymetry = bathymetryIn;
    }

    private Short utFormat;

    /**
     * Format UT (Universal Time) de l'heure pour le lieu (0, +1, -4...).
     * En France métropolitaine, par exemple : +1 (= heure Europe/Paris)
     * @return this.utFormat Short
     */
    public Short getUtFormat()
    {
        return this.utFormat;
    }

    /**
     * Format UT (Universal Time) de l'heure pour le lieu (0, +1, -4...).
     * En France métropolitaine, par exemple : +1 (= heure Europe/Paris)
     * @param utFormatIn Short
     */
    public void setUtFormat(Short utFormatIn)
    {
        this.utFormat = utFormatIn;
    }

    private Boolean daylightSavingTime;

    /**
     * Indique s'il faut opérer le changement d'heure hiver-été, vrai par défaut.
     * En France métropolitaine, par exemple : Vrai.
     * @return this.daylightSavingTime Boolean
     */
    public Boolean getDaylightSavingTime()
    {
        return this.daylightSavingTime;
    }

    /**
     * Indique s'il faut opérer le changement d'heure hiver-été, vrai par défaut.
     * En France métropolitaine, par exemple : Vrai.
     * @param daylightSavingTimeIn Boolean
     */
    public void setDaylightSavingTime(Boolean daylightSavingTimeIn)
    {
        this.daylightSavingTime = daylightSavingTimeIn;
    }

    // Generate 47 associations
    private LocationLevel locationLevel;

    /**
     * Niveau de lieu, ou catégorie. Il s'agit d'un regroupement de haut niveau d'un ensemble de
     * lieux de
     * meme nature géographique.
     * Par exemple, pour la classification de lieu "Secteur maritime", on aura :
     * - Zone FAO,
     * - Sous-Zone FAO,
     * - Division CIEM,
     * - Sous-division CIEM
     * - etc.
     * Pour la classification de lieu "lieux territoriaux", on aura :
     * - Pays
     * - Region,
     * - Département,
     * - Quartier Maritme,
     * - Port
     * - ...
     * On pourra trouver d'autre niveau de lieu, comme :
     * - implantation Ifremer
     * - laboratoire côtier, ...
     * @return this.locationLevel LocationLevel
     */
    public LocationLevel getLocationLevel()
    {
        return this.locationLevel;
    }

    /**
     * Niveau de lieu, ou catégorie. Il s'agit d'un regroupement de haut niveau d'un ensemble de
     * lieux de
     * meme nature géographique.
     * Par exemple, pour la classification de lieu "Secteur maritime", on aura :
     * - Zone FAO,
     * - Sous-Zone FAO,
     * - Division CIEM,
     * - Sous-division CIEM
     * - etc.
     * Pour la classification de lieu "lieux territoriaux", on aura :
     * - Pays
     * - Region,
     * - Département,
     * - Quartier Maritme,
     * - Port
     * - ...
     * On pourra trouver d'autre niveau de lieu, comme :
     * - implantation Ifremer
     * - laboratoire côtier, ...
     * @param locationLevelIn LocationLevel
     */
    public void setLocationLevel(LocationLevel locationLevelIn)
    {
        this.locationLevel = locationLevelIn;
    }

    private LocationClassification locationClassification;

    /**
     * Classification d'une hierachie de lieu.
     * Par exemple :
     * - lieu territoriaux (Pays, region, port, ...)
     * - secteurs maritimes (Zone FAO, sous-zone FAO, etc...)
     * - zone d'effort (B,J,C)
     * - implantation Ifremer
     * - laboratoire côtier, ...
     * @return this.locationClassification LocationClassification
     */
    public LocationClassification getLocationClassification()
    {
        return this.locationClassification;
    }

    /**
     * Classification d'une hierachie de lieu.
     * Par exemple :
     * - lieu territoriaux (Pays, region, port, ...)
     * - secteurs maritimes (Zone FAO, sous-zone FAO, etc...)
     * - zone d'effort (B,J,C)
     * - implantation Ifremer
     * - laboratoire côtier, ...
     * @param locationClassificationIn LocationClassification
     */
    public void setLocationClassification(LocationClassification locationClassificationIn)
    {
        this.locationClassification = locationClassificationIn;
    }

    private Status status;

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @return this.status Status
     */
    public Status getStatus()
    {
        return this.status;
    }

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @param statusIn Status
     */
    public void setStatus(Status statusIn)
    {
        this.status = statusIn;
    }

    /**
     * Returns <code>true</code> if the argument is an Location instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Location))
        {
            return false;
        }
        final Location that = (Location)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Location}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Location}.
         * @return new LocationImpl()
         */
        public static Location newInstance()
        {
            return new LocationImpl();
        }

        /**
         * Constructs a new instance of {@link Location}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param locationLevel LocationLevel
         * @param locationClassification LocationClassification
         * @param status Status
         * @return newInstance
         */
        public static Location newInstance(String name, LocationLevel locationLevel, LocationClassification locationClassification, Status status)
        {
            final Location entity = new LocationImpl();
            entity.setName(name);
            entity.setLocationLevel(locationLevel);
            entity.setLocationClassification(locationClassification);
            entity.setStatus(status);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Location}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param label String
         * @param name String
         * @param updateDate Timestamp
         * @param bathymetry Float
         * @param utFormat Short
         * @param daylightSavingTime Boolean
         * @param locationLevel LocationLevel
         * @param locationClassification LocationClassification
         * @param status Status
         * @return newInstance Location
         */
        public static Location newInstance(String label, String name, Timestamp updateDate, Float bathymetry, Short utFormat, Boolean daylightSavingTime, LocationLevel locationLevel, LocationClassification locationClassification, Status status)
        {
            final Location entity = new LocationImpl();
            entity.setLabel(label);
            entity.setName(name);
            entity.setUpdateDate(updateDate);
            entity.setBathymetry(bathymetry);
            entity.setUtFormat(utFormat);
            entity.setDaylightSavingTime(daylightSavingTime);
            entity.setLocationLevel(locationLevel);
            entity.setLocationClassification(locationClassification);
            entity.setStatus(status);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Location o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getLabel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLabel().compareTo(o.getLabel()));
            }
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getBathymetry() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getBathymetry().compareTo(o.getBathymetry()));
            }
            if (this.getUtFormat() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUtFormat().compareTo(o.getUtFormat()));
            }
            if (this.getDaylightSavingTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDaylightSavingTime().compareTo(o.getDaylightSavingTime()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Location.java merge-point
}