/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hibernate.internal.jaxb.mapping.orm.JaxbColumnResult;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEntityResult;
import org.hibernate.internal.jaxb.mapping.orm.JaxbFieldResult;
import org.hibernate.internal.jaxb.mapping.orm.JaxbNamedNativeQuery;
import org.hibernate.internal.jaxb.mapping.orm.JaxbNamedQuery;
import org.hibernate.internal.jaxb.mapping.orm.JaxbQueryHint;
import org.hibernate.internal.jaxb.mapping.orm.JaxbSequenceGenerator;
import org.hibernate.internal.jaxb.mapping.orm.JaxbSqlResultSetMapping;
import org.hibernate.internal.jaxb.mapping.orm.JaxbTableGenerator;
import org.hibernate.metamodel.source.annotations.xml.mocker.AbstractMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.GlobalAnnotations;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

class GlobalAnnotationMocker
extends AbstractMocker {
    private GlobalAnnotations globalAnnotations;

    GlobalAnnotationMocker(IndexBuilder indexBuilder, GlobalAnnotations globalAnnotations) {
        super(indexBuilder);
        this.globalAnnotations = globalAnnotations;
    }

    void process() {
        Collection<Object> namedQueries;
        if (!this.globalAnnotations.getTableGeneratorMap().isEmpty()) {
            for (JaxbTableGenerator jaxbTableGenerator : this.globalAnnotations.getTableGeneratorMap().values()) {
                this.parserTableGenerator(jaxbTableGenerator);
            }
        }
        if (!this.globalAnnotations.getSequenceGeneratorMap().isEmpty()) {
            for (JaxbSequenceGenerator jaxbSequenceGenerator : this.globalAnnotations.getSequenceGeneratorMap().values()) {
                this.parserSequenceGenerator(jaxbSequenceGenerator);
            }
        }
        if (!this.globalAnnotations.getNamedQueryMap().isEmpty()) {
            namedQueries = this.globalAnnotations.getNamedQueryMap().values();
            if (namedQueries.size() > 1) {
                this.parserNamedQueries(namedQueries);
            } else {
                this.parserNamedQuery((JaxbNamedQuery)namedQueries.iterator().next());
            }
        }
        if (!this.globalAnnotations.getNamedNativeQueryMap().isEmpty()) {
            namedQueries = this.globalAnnotations.getNamedNativeQueryMap().values();
            if (namedQueries.size() > 1) {
                this.parserNamedNativeQueries(namedQueries);
            } else {
                this.parserNamedNativeQuery((JaxbNamedNativeQuery)namedQueries.iterator().next());
            }
        }
        if (!this.globalAnnotations.getSqlResultSetMappingMap().isEmpty()) {
            this.parserSqlResultSetMappings(this.globalAnnotations.getSqlResultSetMappingMap().values());
        }
        this.indexBuilder.finishGlobalConfigurationMocking(this.globalAnnotations);
    }

    private AnnotationInstance parserSqlResultSetMappings(Collection<JaxbSqlResultSetMapping> namedQueries) {
        AnnotationValue[] values = new AnnotationValue[namedQueries.size()];
        int i = 0;
        Iterator<JaxbSqlResultSetMapping> iterator = namedQueries.iterator();
        while (iterator.hasNext()) {
            AnnotationInstance annotationInstance = this.parserSqlResultSetMapping(iterator.next());
            values[i++] = MockHelper.nestedAnnotationValue("", annotationInstance);
        }
        return this.create(SQL_RESULT_SET_MAPPINGS, null, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"values", (AnnotationValue[])values)});
    }

    private AnnotationInstance parserSqlResultSetMapping(JaxbSqlResultSetMapping mapping) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", mapping.getName(), annotationValueList);
        this.nestedEntityResultList("entities", mapping.getEntityResult(), annotationValueList);
        this.nestedColumnResultList("columns", mapping.getColumnResult(), annotationValueList);
        return this.create(SQL_RESULT_SET_MAPPING, null, annotationValueList);
    }

    private AnnotationInstance parserEntityResult(JaxbEntityResult result) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("discriminatorColumn", result.getDiscriminatorColumn(), annotationValueList);
        this.nestedFieldResultList("fields", result.getFieldResult(), annotationValueList);
        MockHelper.classValue("entityClass", result.getEntityClass(), annotationValueList, this.indexBuilder.getServiceRegistry());
        return this.create(ENTITY_RESULT, null, annotationValueList);
    }

    private void nestedEntityResultList(String name, List<JaxbEntityResult> entityResults, List<AnnotationValue> annotationValueList) {
        if (MockHelper.isNotEmpty(entityResults)) {
            AnnotationValue[] values = new AnnotationValue[entityResults.size()];
            for (int i = 0; i < entityResults.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserEntityResult(entityResults.get(i));
                values[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(annotationValueList, AnnotationValue.createArrayValue((String)name, (AnnotationValue[])values));
        }
    }

    private AnnotationInstance parserColumnResult(JaxbColumnResult result) {
        return this.create(COLUMN_RESULT, null, MockHelper.stringValueArray("name", result.getName()));
    }

    private void nestedColumnResultList(String name, List<JaxbColumnResult> columnResults, List<AnnotationValue> annotationValueList) {
        if (MockHelper.isNotEmpty(columnResults)) {
            AnnotationValue[] values = new AnnotationValue[columnResults.size()];
            for (int i = 0; i < columnResults.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserColumnResult(columnResults.get(i));
                values[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(annotationValueList, AnnotationValue.createArrayValue((String)name, (AnnotationValue[])values));
        }
    }

    private AnnotationInstance parserFieldResult(JaxbFieldResult result) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", result.getName(), annotationValueList);
        MockHelper.stringValue("column", result.getColumn(), annotationValueList);
        return this.create(FIELD_RESULT, null, annotationValueList);
    }

    private void nestedFieldResultList(String name, List<JaxbFieldResult> fieldResultList, List<AnnotationValue> annotationValueList) {
        if (MockHelper.isNotEmpty(fieldResultList)) {
            AnnotationValue[] values = new AnnotationValue[fieldResultList.size()];
            for (int i = 0; i < fieldResultList.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserFieldResult(fieldResultList.get(i));
                values[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(annotationValueList, AnnotationValue.createArrayValue((String)name, (AnnotationValue[])values));
        }
    }

    private AnnotationInstance parserNamedNativeQueries(Collection<JaxbNamedNativeQuery> namedQueries) {
        AnnotationValue[] values = new AnnotationValue[namedQueries.size()];
        int i = 0;
        Iterator<JaxbNamedNativeQuery> iterator = namedQueries.iterator();
        while (iterator.hasNext()) {
            AnnotationInstance annotationInstance = this.parserNamedNativeQuery(iterator.next());
            values[i++] = MockHelper.nestedAnnotationValue("", annotationInstance);
        }
        return this.create(NAMED_NATIVE_QUERIES, null, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"values", (AnnotationValue[])values)});
    }

    private AnnotationInstance parserNamedNativeQuery(JaxbNamedNativeQuery namedNativeQuery) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", namedNativeQuery.getName(), annotationValueList);
        MockHelper.stringValue("query", namedNativeQuery.getQuery(), annotationValueList);
        MockHelper.stringValue("resultSetMapping", namedNativeQuery.getResultSetMapping(), annotationValueList);
        MockHelper.classValue("resultClass", namedNativeQuery.getResultClass(), annotationValueList, this.indexBuilder.getServiceRegistry());
        this.nestedQueryHintList("hints", namedNativeQuery.getHint(), annotationValueList);
        return this.create(NAMED_NATIVE_QUERY, null, annotationValueList);
    }

    private AnnotationInstance parserNamedQueries(Collection<JaxbNamedQuery> namedQueries) {
        AnnotationValue[] values = new AnnotationValue[namedQueries.size()];
        int i = 0;
        Iterator<JaxbNamedQuery> iterator = namedQueries.iterator();
        while (iterator.hasNext()) {
            AnnotationInstance annotationInstance = this.parserNamedQuery(iterator.next());
            values[i++] = MockHelper.nestedAnnotationValue("", annotationInstance);
        }
        return this.create(NAMED_QUERIES, null, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"values", (AnnotationValue[])values)});
    }

    private AnnotationInstance parserNamedQuery(JaxbNamedQuery namedQuery) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", namedQuery.getName(), annotationValueList);
        MockHelper.stringValue("query", namedQuery.getQuery(), annotationValueList);
        MockHelper.enumValue("lockMode", LOCK_MODE_TYPE, namedQuery.getLockMode(), annotationValueList);
        this.nestedQueryHintList("hints", namedQuery.getHint(), annotationValueList);
        return this.create(NAMED_QUERY, null, annotationValueList);
    }

    private AnnotationInstance parserQueryHint(JaxbQueryHint queryHint) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", queryHint.getName(), annotationValueList);
        MockHelper.stringValue("value", queryHint.getValue(), annotationValueList);
        return this.create(QUERY_HINT, null, annotationValueList);
    }

    private void nestedQueryHintList(String name, List<JaxbQueryHint> constraints, List<AnnotationValue> annotationValueList) {
        if (MockHelper.isNotEmpty(constraints)) {
            AnnotationValue[] values = new AnnotationValue[constraints.size()];
            for (int i = 0; i < constraints.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserQueryHint(constraints.get(i));
                values[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(annotationValueList, AnnotationValue.createArrayValue((String)name, (AnnotationValue[])values));
        }
    }

    private AnnotationInstance parserSequenceGenerator(JaxbSequenceGenerator generator) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", generator.getName(), annotationValueList);
        MockHelper.stringValue("catalog", generator.getCatalog(), annotationValueList);
        MockHelper.stringValue("schema", generator.getSchema(), annotationValueList);
        MockHelper.stringValue("sequenceName", generator.getSequenceName(), annotationValueList);
        MockHelper.integerValue("initialValue", generator.getInitialValue(), annotationValueList);
        MockHelper.integerValue("allocationSize", generator.getAllocationSize(), annotationValueList);
        return this.create(SEQUENCE_GENERATOR, null, annotationValueList);
    }

    private AnnotationInstance parserTableGenerator(JaxbTableGenerator generator) {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", generator.getName(), annotationValueList);
        MockHelper.stringValue("catalog", generator.getCatalog(), annotationValueList);
        MockHelper.stringValue("schema", generator.getSchema(), annotationValueList);
        MockHelper.stringValue("table", generator.getTable(), annotationValueList);
        MockHelper.stringValue("pkColumnName", generator.getPkColumnName(), annotationValueList);
        MockHelper.stringValue("valueColumnName", generator.getValueColumnName(), annotationValueList);
        MockHelper.stringValue("pkColumnValue", generator.getPkColumnValue(), annotationValueList);
        MockHelper.integerValue("initialValue", generator.getInitialValue(), annotationValueList);
        MockHelper.integerValue("allocationSize", generator.getAllocationSize(), annotationValueList);
        this.nestedUniqueConstraintList("uniqueConstraints", generator.getUniqueConstraint(), annotationValueList);
        return this.create(TABLE_GENERATOR, null, annotationValueList);
    }

    @Override
    protected AnnotationInstance push(AnnotationInstance annotationInstance) {
        if (annotationInstance != null) {
            return this.globalAnnotations.push(annotationInstance.name(), annotationInstance);
        }
        return null;
    }
}

