/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;

public class ConfigFileParser {
    private static final String PARAMETER = "parameter";
    private static final String TIMESTAMP_FORMAT = "timestamp-format";
    private static final String TIMESTAMP_COLUMN = "timestamp-column";
    private static final String MODE = "mode";
    private static final String QUERY_TEXT = "query-text";
    private static final String ID = "id";
    private Node node;
    private static Logger logger = Logger.getLogger(ConfigFileParser.class.getName());

    public ConfigFileParser(InputStream stream) {
        this.node = this.parseXML2DOM(stream);
    }

    public boolean containDataSet(String id) {
        ArrayList children = this.node.getChildren();
        int i = 0;
        while (i < children.size()) {
            Node temp = (Node)children.get(i);
            HashMap attributes = temp.getAttributes();
            if (attributes.containsKey(ID) && attributes.get(ID).equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getQueryTextByID(String id) throws DataException {
        ArrayList children = this.node.getChildren();
        int i = 0;
        while (i < children.size()) {
            Node temp = (Node)children.get(i);
            HashMap attributes = temp.getAttributes();
            if (attributes.containsKey(ID) && attributes.get(ID).equals(id)) {
                children = temp.getChildren();
                int j = 0;
                while (j < children.size()) {
                    temp = (Node)children.get(j);
                    if (temp.getName().equalsIgnoreCase(QUERY_TEXT)) {
                        return temp.getValue();
                    }
                    ++j;
                }
            }
            ++i;
        }
        throw new DataException("data.executor.configFileParser.getQueryTextByID");
    }

    public String getModeByID(String id) throws DataException {
        ArrayList children = this.node.getChildren();
        int i = 0;
        while (i < children.size()) {
            Node temp = (Node)children.get(i);
            HashMap attributes = temp.getAttributes();
            if (attributes.containsKey(ID) && attributes.get(ID).equals(id)) {
                children = temp.getChildren();
                int j = 0;
                while (j < children.size()) {
                    temp = (Node)children.get(j);
                    if (temp.getName().equalsIgnoreCase(MODE)) {
                        return temp.getValue();
                    }
                    ++j;
                }
            }
            ++i;
        }
        throw new DataException("data.executor.configFileParser.getModeByID");
    }

    public String getTimeStampColumnByID(String id) throws DataException {
        ArrayList children = this.node.getChildren();
        int i = 0;
        while (i < children.size()) {
            Node temp = (Node)children.get(i);
            HashMap attributes = temp.getAttributes();
            if (attributes.containsKey(ID) && attributes.get(ID).equals(id)) {
                children = temp.getChildren();
                int j = 0;
                while (j < children.size()) {
                    temp = (Node)children.get(j);
                    if (temp.getName().equals(TIMESTAMP_COLUMN)) {
                        return temp.getValue();
                    }
                    ++j;
                }
            }
            ++i;
        }
        throw new DataException("data.executor.configFileParser.getTimeStampColumnByID");
    }

    public String getTSFormatByID(String id) throws DataException {
        ArrayList children = this.node.getChildren();
        int i = 0;
        while (i < children.size()) {
            Node temp = (Node)children.get(i);
            HashMap attributes = temp.getAttributes();
            if (attributes.containsKey(ID) && attributes.get(ID).equals(id)) {
                children = temp.getChildren();
                int j = 0;
                while (j < children.size()) {
                    temp = (Node)children.get(j);
                    if (temp.getName().equals(TIMESTAMP_FORMAT)) {
                        return temp.getValue();
                    }
                    ++j;
                }
            }
            ++i;
        }
        throw new DataException("data.executor.configFileParser.getTSFormatByID");
    }

    public HashMap getParametersByID(String id) {
        Node temp;
        HashMap<String, String> params = new HashMap<String, String>();
        ArrayList children = this.node.getChildren();
        int i = 0;
        while (i < children.size()) {
            temp = (Node)children.get(i);
            HashMap attributes = temp.getAttributes();
            if (attributes.containsKey(ID) && attributes.get(ID).equals(id)) {
                children = temp.getChildren();
                int j = 0;
                while (j < children.size()) {
                    temp = (Node)children.get(j);
                    if (temp.getName().equals(PARAMETER)) {
                        children = temp.getChildren();
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < children.size()) {
            temp = (Node)children.get(i);
            params.put(temp.getName(), temp.getValue());
            ++i;
        }
        return params;
    }

    private Node parseXML2DOM(InputStream stream) {
        StringBuffer buffer = new StringBuffer();
        try {
            int c;
            while ((c = stream.read()) != -1) {
                buffer.append((char)c);
            }
            return this.parseXML2DOM(buffer.toString());
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return null;
        }
    }

    public Node getNode() {
        return this.node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node parseXML2DOM(String xml) {
        Object obj;
        Node node = new Node();
        StringBuffer buffer = new StringBuffer();
        Stack<Object> stack = new Stack<Object>();
        ArrayList<Node> children = new ArrayList<Node>();
        boolean flag = false;
        boolean reserved = false;
        int i = 0;
        while (i < xml.length()) {
            String temp;
            char ch = xml.charAt(i);
            if (reserved) {
                if (ch == ']') {
                    temp = xml.substring(i, i + 3);
                    if (temp.equals("]]>")) {
                        reserved = false;
                        stack.push(buffer.toString().trim());
                        buffer = new StringBuffer();
                        flag = false;
                        i += 2;
                    }
                } else {
                    buffer.append(ch);
                }
            } else if (ch != '\n' && ch != '\t') {
                if (ch == '<') {
                    if (flag) {
                        return null;
                    }
                    temp = xml.substring(i, i + 9);
                    if (temp.equals("<![CDATA[")) {
                        reserved = true;
                        i += 8;
                    } else {
                        if (buffer.toString().trim().length() > 0) {
                            stack.push(buffer.toString().trim());
                            buffer = new StringBuffer();
                        }
                        buffer.append(ch);
                        flag = true;
                    }
                } else if (ch == '>') {
                    if (!flag) {
                        return null;
                    }
                    flag = false;
                    temp = buffer.toString().trim();
                    buffer = new StringBuffer();
                    if (temp.startsWith("</")) {
                        temp = temp.substring(2).trim();
                        if (stack.isEmpty()) {
                            return null;
                        }
                        obj = stack.pop();
                        if (obj instanceof Node) {
                            children.add((Node)obj);
                            while (!stack.isEmpty()) {
                                obj = stack.pop();
                                if (!(obj instanceof Node)) break;
                                children.add((Node)obj);
                            }
                        }
                        if (obj instanceof String) {
                            boolean time = false;
                            String next = (String)obj;
                            if (next.startsWith("</")) {
                                return null;
                            }
                            if (!next.startsWith("<") && !next.endsWith(">")) {
                                if (time) {
                                    return null;
                                }
                                node.setValue(next);
                                time = true;
                                if (stack.isEmpty()) {
                                    return null;
                                }
                                obj = stack.pop();
                                if (!(obj instanceof String)) return null;
                                next = (String)obj;
                            }
                            if (next.startsWith("<") && next.endsWith(">")) {
                                if (!next.startsWith("<" + temp)) return null;
                                node.setName(temp);
                                next = next.substring(temp.length() + 1, next.length() - 1).trim();
                                if (!next.equals("")) {
                                    String[] arrays = next.split("=");
                                    HashMap<String, String> attributes = new HashMap<String, String>();
                                    String name = arrays[0].trim();
                                    int k = 1;
                                    while (k < arrays.length) {
                                        String[] pair = arrays[k].split("\"");
                                        if (pair.length < 2) {
                                            return null;
                                        }
                                        String value = pair[1];
                                        attributes.put(name, value);
                                        if (pair.length == 3) {
                                            name = pair[2];
                                        }
                                        ++k;
                                    }
                                    node.setAttributes(attributes);
                                    attributes = new HashMap();
                                }
                                if (children.size() > 0) {
                                    ArrayList nodeArray = new ArrayList();
                                    int j = children.size() - 1;
                                    while (j >= 0) {
                                        nodeArray.add(children.get(j));
                                        --j;
                                    }
                                    node.setChildren(nodeArray);
                                    children = new ArrayList();
                                }
                                stack.push(node);
                                node = new Node();
                                flag = false;
                            }
                        }
                    } else {
                        if (!temp.startsWith("<")) return null;
                        stack.push(String.valueOf(temp) + ch);
                    }
                } else {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        if (stack.size() != 1) {
            return null;
        }
        obj = stack.pop();
        if (!(obj instanceof Node)) return null;
        return (Node)obj;
    }

    public static class Node {
        private String name;
        private String value;
        private ArrayList children;
        private HashMap attributes;

        public Node() {
            this.name = "";
            this.value = "";
            this.children = new ArrayList();
            this.attributes = new HashMap();
        }

        public Node(String name, String value) {
            this.name = name;
            this.value = value;
            this.children = new ArrayList();
            this.attributes = new HashMap();
        }

        public void addChild(Node child) {
            this.children.add(child);
        }

        public void setChildren(ArrayList children) {
            this.children = children;
        }

        public ArrayList getChildren() {
            return this.children;
        }

        public void setAttributes(HashMap attributes) {
            this.attributes = attributes;
        }

        public HashMap getAttributes() {
            return this.attributes;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getAttrValue(String key) {
            if (this.attributes.containsKey(key)) {
                return (String)this.attributes.get(key);
            }
            return null;
        }

        public Node getChildByName(String name) {
            int i = 0;
            while (i < this.children.size()) {
                Node temp = (Node)this.children.get(i);
                if (temp.getName().equals(name)) {
                    return temp;
                }
                ++i;
            }
            return null;
        }
    }
}

