/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.generic;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.generic.IndividualObservationExportRow;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.nuiton.csv.ValueFormatter;

public class IndividualObservationExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<IndividualObservationExportRow> {
    protected final Caracteristic caracteristicWeight;
    protected final Caracteristic caracteristicPmfmId;

    public IndividualObservationExportModel(char separator, Caracteristic caracteristicWeight, Caracteristic caracteristicPmfmId) {
        super(separator);
        this.caracteristicWeight = caracteristicWeight;
        this.caracteristicPmfmId = caracteristicPmfmId;
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", "name");
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newNullableColumnForExport("Engin", "gear.name");
        this.newColumnForExport("Code_station", "stationNumber");
        this.newColumnForExport("Id_Operation", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("BatchId", "batchId", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_INTEGER);
        this.newColumnForExport("ReferenceTaxonId", "species.referenceTaxonId", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_INTEGER);
        this.newColumnForExport("ReferenceTaxonName", "species.name");
        this.newColumnForExport("Commentaire", "comment", TuttiCsvUtil.COMMENT_FORMATTER);
        this.newColumnForExport("CaracteristicId", "caracteristic", "id");
        this.newColumnForExport("CaracteristicValue", "caracteristicValue", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
    }

    public void prepareRows(PersistenceService persistenceService, List<IndividualObservationExportRow> rows, Cruise cruise, FishingOperation operation) {
        List<IndividualObservationBatch> observations = persistenceService.getAllIndividualObservationBatch(operation.getId());
        if (CollectionUtils.isNotEmpty(observations)) {
            for (IndividualObservationBatch child : observations) {
                CaracteristicMap caracteristics;
                this.addCaracteristicRow(rows, cruise, operation, child, this.caracteristicWeight, child.getWeight());
                if (child.getLengthStepCaracteristic() != null) {
                    this.addCaracteristicRow(rows, cruise, operation, child, this.caracteristicPmfmId, child.getLengthStepCaracteristic().getIdAsInt());
                    this.addCaracteristicRow(rows, cruise, operation, child, child.getLengthStepCaracteristic(), child.getSize());
                }
                if (!MapUtils.isNotEmpty((Map)(caracteristics = child.getCaracteristics()))) continue;
                for (Map.Entry entry : caracteristics.entrySet()) {
                    this.addCaracteristicRow(rows, cruise, operation, child, (Caracteristic)entry.getKey(), (Serializable)entry.getValue());
                }
            }
        }
    }

    private void addCaracteristicRow(List<IndividualObservationExportRow> rows, Cruise cruise, FishingOperation operation, IndividualObservationBatch child, Caracteristic caracteristic, Serializable caracteristicValue) {
        if (caracteristicValue != null) {
            IndividualObservationExportRow row = new IndividualObservationExportRow();
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            row.setBatch(child);
            row.setCaracteristic(caracteristic);
            row.setCaracteristicValue(caracteristicValue);
            rows.add(row);
        }
    }
}

