/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.filter;

import java.io.IOException;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;

public abstract class AbstractTypeHierarchyTraversingFilter
implements TypeFilter {
    private final boolean considerInherited;
    private final boolean considerInterfaces;

    protected AbstractTypeHierarchyTraversingFilter(boolean considerInherited, boolean considerInterfaces) {
        this.considerInherited = considerInherited;
        this.considerInterfaces = considerInterfaces;
    }

    @Override
    public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        Boolean superClassMatch;
        if (this.matchSelf(metadataReader)) {
            return true;
        }
        ClassMetadata metadata = metadataReader.getClassMetadata();
        if (this.matchClassName(metadata.getClassName())) {
            return true;
        }
        if (!this.considerInherited) {
            return false;
        }
        if (metadata.hasSuperClass() && ((superClassMatch = this.matchSuperClass(metadata.getSuperClassName())) != null ? superClassMatch != false : this.match(metadata.getSuperClassName(), metadataReaderFactory))) {
            return true;
        }
        if (!this.considerInterfaces) {
            return false;
        }
        for (String ifc : metadata.getInterfaceNames()) {
            Boolean interfaceMatch = this.matchInterface(ifc);
            if (!(interfaceMatch != null ? interfaceMatch != false : this.match(ifc, metadataReaderFactory))) continue;
            return true;
        }
        return false;
    }

    private boolean match(String className, MetadataReaderFactory metadataReaderFactory) throws IOException {
        return this.match(metadataReaderFactory.getMetadataReader(className), metadataReaderFactory);
    }

    protected boolean matchSelf(MetadataReader metadataReader) {
        return false;
    }

    protected boolean matchClassName(String className) {
        return false;
    }

    protected Boolean matchSuperClass(String superClassName) {
        return null;
    }

    protected Boolean matchInterface(String interfaceNames) {
        return null;
    }
}

