/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.config;

import com.google.common.base.Charsets;
import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfigurationOption;
import fr.ifremer.adagio.core.config.AdagioEnumerationHelper;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.service.technical.SpringUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigHelper;
import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Version;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class AdagioConfiguration
extends PropertyPlaceholderConfigurer
implements ApplicationContextAware,
InitializingBean {
    private static final Log log = LogFactory.getLog(AdagioConfiguration.class);
    protected final ApplicationConfig applicationConfig;
    private static AdagioConfiguration instance;
    protected final String[] optionKeyToNotSave;
    protected File configFile;
    private ApplicationContext appContext = null;
    private boolean isInitialize = false;

    public static AdagioConfiguration getInstance() {
        return instance;
    }

    public static void setInstance(AdagioConfiguration instance) {
        AdagioConfiguration.instance = instance;
    }

    public AdagioConfiguration(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
        this.optionKeyToNotSave = null;
    }

    public AdagioConfiguration(String file, String ... args) {
        this.applicationConfig = new ApplicationConfig();
        this.applicationConfig.setEncoding(Charsets.UTF_8.name());
        this.applicationConfig.setConfigFileName(file);
        Set<ApplicationConfigProvider> providers = ApplicationConfigHelper.getProviders(null, null, null, true);
        ApplicationConfigHelper.loadAllDefaultOption(this.applicationConfig, providers);
        for (ApplicationConfigProvider provider : providers) {
            this.applicationConfig.loadActions(provider.getActions());
        }
        this.applicationConfig.addAlias("-u", "--option", AdagioConfigurationOption.JDBC_USERNAME.getKey());
        this.applicationConfig.addAlias("--user", "--option", AdagioConfigurationOption.JDBC_USERNAME.getKey());
        this.applicationConfig.addAlias("-p", "--option", AdagioConfigurationOption.JDBC_PASSWORD.getKey());
        this.applicationConfig.addAlias("--password", "--option", AdagioConfigurationOption.JDBC_PASSWORD.getKey());
        this.applicationConfig.addAlias("-db", "--option", AdagioConfigurationOption.JDBC_URL.getKey());
        this.applicationConfig.addAlias("--database", "--option", AdagioConfigurationOption.JDBC_URL.getKey());
        this.applicationConfig.addAlias("--output", "--option", AdagioConfigurationOption.LIQUIBASE_OUTPUT_FILE.getKey());
        this.applicationConfig.addAlias("--port", "--option", AdagioConfigurationOption.SERVER_PORT.getKey());
        Set<String> optionToSkip = ApplicationConfigHelper.getTransientOptionKeys(providers);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Option that won't be saved: " + optionToSkip));
        }
        this.optionKeyToNotSave = optionToSkip.toArray(new String[optionToSkip.size()]);
        try {
            this.applicationConfig.parse(args);
        }
        catch (ArgumentsParserException e) {
            throw new AdagioTechnicalException(I18n.t((String)"adagio.config.parse.error", (Object[])new Object[0]), e);
        }
        File allegroBasedir = this.applicationConfig.getOptionAsFile(AdagioConfigurationOption.BASEDIR.getKey());
        if (allegroBasedir == null) {
            allegroBasedir = new File("");
        }
        if (!allegroBasedir.isAbsolute()) {
            allegroBasedir = new File(allegroBasedir.getAbsolutePath());
        }
        if (allegroBasedir.getName().equals("..")) {
            allegroBasedir = allegroBasedir.getParentFile().getParentFile();
        }
        if (allegroBasedir.getName().equals(".")) {
            allegroBasedir = allegroBasedir.getParentFile();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Application basedir: " + allegroBasedir));
        }
        this.applicationConfig.setOption(AdagioConfigurationOption.BASEDIR.getKey(), allegroBasedir.getAbsolutePath());
    }

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.appContext = appContext;
    }

    public void afterPropertiesSet() throws Exception {
        List<Resource> resources;
        if (this.isInitialize) {
            return;
        }
        this.isInitialize = true;
        Object[] enumerationFilePaths = this.getEnumerationFilesPath();
        if (ArrayUtils.isEmpty((Object[])enumerationFilePaths)) {
            throw new BeanInitializationException(String.format("No enumeration files path has been set in the configuration. This is need to initialize enumeration values. Please set the option [%s] in configuration file.", AdagioConfigurationOption.DB_ENUMERATION_RESOURCE));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Getting enumeration files from path: %s", Arrays.toString(enumerationFilePaths)));
        }
        if (CollectionUtils.isEmpty(resources = SpringUtils.getResourcesFromPaths((String[])enumerationFilePaths, this.appContext, true))) {
            throw new BeanInitializationException(String.format("No enumeration files could be found from path %s", Arrays.toString(enumerationFilePaths)));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s enumeration files found from path: %s", resources.size(), Arrays.toString(enumerationFilePaths)));
        }
        AdagioEnumerationHelper.reload(this.applicationConfig, resources);
    }

    public File getConfigFile() {
        if (this.configFile == null) {
            File dir = this.getBasedir();
            if (dir == null || !dir.exists()) {
                dir = new File(this.applicationConfig.getUserConfigDirectory());
            }
            this.configFile = new File(dir, this.applicationConfig.getConfigFileName());
        }
        return this.configFile;
    }

    public File getBasedir() {
        File result = this.applicationConfig.getOptionAsFile(AdagioConfigurationOption.BASEDIR.getKey());
        return result;
    }

    public File getDataDirectory() {
        File result = this.applicationConfig.getOptionAsFile(AdagioConfigurationOption.DATA_DIRECTORY.getKey());
        return result;
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        if (this.applicationConfig == null) {
            throw new AdagioTechnicalException("AdagioConfiguration.applicationConfig must not be null. Please initialize AdagioConfiguration instance with a not null applicationConfig BEFORE starting Spring.");
        }
        String optionValue = this.applicationConfig.getOption(placeholder);
        if (optionValue != null) {
            return optionValue;
        }
        return super.resolvePlaceholder(placeholder, props);
    }

    public File getDbDirectory() {
        return this.applicationConfig.getOptionAsFile(AdagioConfigurationOption.DB_DIRECTORY.getKey());
    }

    public void setDbDirectory(File dbDirectory) {
        this.applicationConfig.setOption(AdagioConfigurationOption.DB_DIRECTORY.getKey(), dbDirectory.getPath());
    }

    public File getDbAttachmentDirectory() {
        return this.applicationConfig.getOptionAsFile(AdagioConfigurationOption.DB_ATTACHMENT_DIRECTORY.getKey());
    }

    public File getCacheDirectory() {
        return this.applicationConfig.getOptionAsFile(AdagioConfigurationOption.DB_CACHE_DIRECTORY.getKey());
    }

    public File getDbBackupDirectory() {
        return this.applicationConfig.getOptionAsFile(AdagioConfigurationOption.DB_BACKUP_DIRECTORY.getKey());
    }

    public boolean useBacthTreeCache() {
        return this.applicationConfig.getOptionAsBoolean(AdagioConfigurationOption.CACHE_BACTH_TREE.getKey());
    }

    public boolean useLiquibaseAutoRun() {
        return this.applicationConfig.getOptionAsBoolean(AdagioConfigurationOption.LIQUIBASE_RUN_AUTO.getKey());
    }

    public String getLiquibaseChangeLogPath() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.LIQUIBASE_CHANGE_LOG_PATH.getKey());
    }

    public String getHibernateDialect() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.HIBERNATE_DIALECT.getKey());
    }

    public String getHibernateClientQueriesFile() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.HIBERNATE_CLIENT_QUERIES_FILE.getKey());
    }

    public String getJdbcDriver() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.JDBC_DRIVER.getKey());
    }

    public String getJdbcURL() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.JDBC_URL.getKey());
    }

    public String getJdbcCatalog() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.JDBC_SCHEMA.getKey());
    }

    public String getJdbcSchema() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.JDBC_SCHEMA.getKey());
    }

    public boolean debugEntityLoad() {
        return this.applicationConfig.getOptionAsBoolean(AdagioConfigurationOption.DEBUG_ENTITY_LOAD.getKey());
    }

    public String[] getEnumerationFilesPath() {
        String enumerationFilesPath = this.applicationConfig.getOption(AdagioConfigurationOption.DB_ENUMERATION_RESOURCE.getKey());
        String[] enumerationFilesPathArray = enumerationFilesPath.split(",");
        return enumerationFilesPathArray;
    }

    public String getDbName() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.DB_NAME.getKey());
    }

    public String getDbValidationQuery() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.DB_VALIDATION_QUERY.getKey());
    }

    public String getJdbcUsername() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.JDBC_USERNAME.getKey());
    }

    public String getJdbcPassword() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.JDBC_PASSWORD.getKey());
    }

    public int getJdbcBatchSize() {
        return this.applicationConfig.getOptionAsInt(AdagioConfigurationOption.JDBC_BATCH_SIZE.getKey());
    }

    public String getStatusCodeTemporary() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.STATUS_CODE_TEMPORARY.getKey());
    }

    public String getStatusCodeValid() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.STATUS_CODE_ENABLE.getKey());
    }

    public Version getVersion() {
        return this.applicationConfig.getOptionAsVersion(AdagioConfigurationOption.VERSION.getKey());
    }

    public String getVesselRegistryProgramCode() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.PROGRAM_CODE_VESSEL_REGISTRY.getKey());
    }

    public File getI18nDirectory() {
        return this.applicationConfig.getOptionAsFile(AdagioConfigurationOption.I18N_DIRECTORY.getKey());
    }

    public Locale getI18nLocale() {
        return this.applicationConfig.getOptionAsLocale(AdagioConfigurationOption.I18N_LOCALE.getKey());
    }

    public void setI18nLocale(Locale locale) {
        this.applicationConfig.setOption(AdagioConfigurationOption.I18N_LOCALE.getKey(), locale.toString());
    }

    public Properties getConnectionProperties() {
        return DaoUtils.getConnectionProperties(this.getJdbcURL(), this.getJdbcUsername(), this.getJdbcPassword(), null, this.getHibernateDialect(), this.getJdbcDriver());
    }

    public String getLiquibaseDiffTypes() {
        return this.applicationConfig.getOption(AdagioConfigurationOption.LIQUIBASE_DIFF_TYPES.getKey());
    }

    public File getLiquibaseOutputFile() {
        return this.applicationConfig.getOptionAsFile(AdagioConfigurationOption.LIQUIBASE_OUTPUT_FILE.getKey());
    }

    public Integer getServerPort() {
        return this.applicationConfig.getOptionAsInt(AdagioConfigurationOption.SERVER_PORT.getKey());
    }
}

