/*
 * Decompiled with CFR 0.152.
 */
package liquibase.precondition.core;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.precondition.Precondition;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.core.Column;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.StringUtils;

public class IndexExistsPrecondition
implements Precondition {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String columnNames;
    private String indexName;

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public Warnings warn(Database database) {
        return new Warnings();
    }

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        if (this.getIndexName() == null && this.getTableName() == null && this.getColumnNames() == null) {
            validationErrors.addError("indexName OR tableName and columnNames is required");
        }
        return validationErrors;
    }

    @Override
    public void check(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet) throws PreconditionFailedException, PreconditionErrorException {
        try {
            Schema schema = new Schema(this.getCatalogName(), this.getSchemaName());
            Index example = new Index();
            String tableName = StringUtils.trimToNull(this.getTableName());
            if (tableName != null) {
                example.setTable((Table)new Table().setName(database.correctObjectName(this.getTableName(), Table.class)).setSchema(schema));
            }
            example.setName(database.correctObjectName(this.getIndexName(), Index.class));
            if (StringUtils.trimToNull(this.getColumnNames()) != null) {
                String[] stringArray = this.getColumnNames().split("\\s*,\\s*");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String column = stringArray[n2];
                    example.getColumns().add(database.correctObjectName(column, Column.class));
                    ++n2;
                }
            }
            if (!SnapshotGeneratorFactory.getInstance().has(example, database)) {
                String name = "";
                if (this.getIndexName() != null) {
                    name = String.valueOf(name) + database.escapeObjectName(this.getIndexName(), Index.class);
                }
                if (tableName != null) {
                    name = String.valueOf(name) + " on " + database.escapeObjectName(this.getTableName(), Table.class);
                    if (StringUtils.trimToNull(this.getColumnNames()) != null) {
                        name = String.valueOf(name) + " columns " + this.getColumnNames();
                    }
                }
                throw new PreconditionFailedException("Index " + name + " does not exist", changeLog, this);
            }
        }
        catch (Exception e) {
            if (e instanceof PreconditionFailedException) {
                throw (PreconditionFailedException)e;
            }
            throw new PreconditionErrorException(e, changeLog, this);
        }
    }

    @Override
    public String getName() {
        return "indexExists";
    }

    public String toString() {
        String string = "Index Exists Precondition: ";
        if (this.getIndexName() != null) {
            string = String.valueOf(string) + this.getIndexName();
        }
        if (this.tableName != null) {
            string = String.valueOf(string) + " on " + this.getTableName();
            if (StringUtils.trimToNull(this.getColumnNames()) != null) {
                string = String.valueOf(string) + " columns " + this.getColumnNames();
            }
        }
        return string;
    }
}

