/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;

public class EventHandlerManager {
    private Map<DesignElementHandle, Object> eventHandlers = new HashMap<DesignElementHandle, Object>();

    public Object getInstance(DesignElementHandle element, ExecutionContext context) throws EngineException {
        if (element == null) {
            return null;
        }
        if (element.newHandlerOnEachEvent()) {
            return EventHandlerManager.getInstance(element.getEventHandlerClass(), context);
        }
        if (this.eventHandlers.containsKey(element)) {
            return this.eventHandlers.get(element);
        }
        Object eventHandler = EventHandlerManager.getInstance(element.getEventHandlerClass(), context);
        this.eventHandlers.put(element, eventHandler);
        return eventHandler;
    }

    public Object getInstance(ReportItemDesign element, ExecutionContext context) throws EngineException {
        if (element == null) {
            return null;
        }
        return this.getInstance(element.getHandle(), context);
    }

    public static Object getInstance(String className, ExecutionContext context) throws EngineException {
        if (className == null) {
            return null;
        }
        Object o = null;
        Class c = null;
        try {
            c = EventHandlerManager.loadClass(className, context);
            o = c.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new EngineException("Error.ScriptClassIllegalAccessError", new Object[]{className}, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new EngineException("Error.ScriptClassInstantiationError", new Object[]{className}, (Throwable)e);
        }
        return o;
    }

    public static Class loadClass(String className, ExecutionContext context) throws EngineException {
        try {
            ClassLoader classLoader = context.getApplicationClassLoader();
            Class<?> c = classLoader.loadClass(className);
            return c;
        }
        catch (ClassNotFoundException e) {
            throw new EngineException("Error.ScriptClassNotFoundError", new Object[]{className}, (Throwable)e);
        }
    }
}

