/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.SourceExtractor;
import org.springframework.beans.factory.support.AbstractBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.BeanAnnotationHelper;
import org.springframework.context.annotation.BeanMethod;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationClassUtils;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.MetadataUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Role;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyCreator;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationClassBeanDefinitionReader {
    private static final Log logger = LogFactory.getLog(ConfigurationClassBeanDefinitionReader.class);
    private final BeanDefinitionRegistry registry;
    private final SourceExtractor sourceExtractor;
    private final ProblemReporter problemReporter;
    private final MetadataReaderFactory metadataReaderFactory;
    private final ResourceLoader resourceLoader;
    private final Environment environment;
    private final BeanNameGenerator importBeanNameGenerator;

    public ConfigurationClassBeanDefinitionReader(BeanDefinitionRegistry registry, SourceExtractor sourceExtractor, ProblemReporter problemReporter, MetadataReaderFactory metadataReaderFactory, ResourceLoader resourceLoader, Environment environment, BeanNameGenerator importBeanNameGenerator) {
        this.registry = registry;
        this.sourceExtractor = sourceExtractor;
        this.problemReporter = problemReporter;
        this.metadataReaderFactory = metadataReaderFactory;
        this.resourceLoader = resourceLoader;
        this.environment = environment;
        this.importBeanNameGenerator = importBeanNameGenerator;
    }

    public void loadBeanDefinitions(Set<ConfigurationClass> configurationModel) {
        for (ConfigurationClass configClass : configurationModel) {
            this.loadBeanDefinitionsForConfigurationClass(configClass);
        }
    }

    private void loadBeanDefinitionsForConfigurationClass(ConfigurationClass configClass) {
        if (configClass.isImported()) {
            this.registerBeanDefinitionForImportedConfigurationClass(configClass);
        }
        for (BeanMethod beanMethod : configClass.getBeanMethods()) {
            this.loadBeanDefinitionsForBeanMethod(beanMethod);
        }
        this.loadBeanDefinitionsFromImportedResources(configClass.getImportedResources());
    }

    private void registerBeanDefinitionForImportedConfigurationClass(ConfigurationClass configClass) {
        AnnotationMetadata metadata = configClass.getMetadata();
        AnnotatedGenericBeanDefinition configBeanDef = new AnnotatedGenericBeanDefinition(metadata);
        if (ConfigurationClassUtils.checkConfigurationClassCandidate((BeanDefinition)configBeanDef, this.metadataReaderFactory)) {
            String configBeanName = this.importBeanNameGenerator.generateBeanName((BeanDefinition)configBeanDef, this.registry);
            this.registry.registerBeanDefinition(configBeanName, (BeanDefinition)configBeanDef);
            configClass.setBeanName(configBeanName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Registered bean definition for imported @Configuration class %s", configBeanName));
            }
        } else {
            this.problemReporter.error((Problem)new InvalidConfigurationImportProblem(metadata.getClassName(), configClass.getResource(), metadata));
        }
    }

    private void loadBeanDefinitionsForBeanMethod(BeanMethod beanMethod) {
        String destroyMethodName;
        String initMethodName;
        Autowire autowire;
        AnnotationAttributes dependsOn;
        String[] otherBeans;
        AnnotationAttributes lazy;
        BeanDefinition existingBeanDef;
        AnnotationAttributes bean;
        ArrayList<String> names;
        ConfigurationClass configClass = beanMethod.getConfigurationClass();
        MethodMetadata metadata = beanMethod.getMetadata();
        ConfigurationClassBeanDefinition beanDef = new ConfigurationClassBeanDefinition(configClass);
        beanDef.setResource(configClass.getResource());
        beanDef.setSource(this.sourceExtractor.extractSource((Object)metadata, configClass.getResource()));
        if (metadata.isStatic()) {
            beanDef.setBeanClassName(configClass.getMetadata().getClassName());
            beanDef.setFactoryMethodName(metadata.getMethodName());
        } else {
            beanDef.setFactoryBeanName(configClass.getBeanName());
            beanDef.setUniqueFactoryMethodName(metadata.getMethodName());
        }
        beanDef.setAutowireMode(3);
        beanDef.setAttribute(RequiredAnnotationBeanPostProcessor.SKIP_REQUIRED_CHECK_ATTRIBUTE, Boolean.TRUE);
        AnnotationAttributes role = MetadataUtils.attributesFor(metadata, Role.class);
        if (role != null) {
            beanDef.setRole((Integer)role.getNumber("value"));
        }
        String beanName = (names = new ArrayList<String>(Arrays.asList((bean = MetadataUtils.attributesFor(metadata, Bean.class)).getStringArray("name")))).size() > 0 ? (String)names.remove(0) : beanMethod.getMetadata().getMethodName();
        for (String alias : names) {
            this.registry.registerAlias(beanName, alias);
        }
        if (this.registry.containsBeanDefinition(beanName) && !((existingBeanDef = this.registry.getBeanDefinition(beanName)) instanceof ConfigurationClassBeanDefinition)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Skipping loading bean definition for %s: a definition for bean '%s' already exists. This is likely due to an override in XML.", beanMethod, beanName));
            }
            return;
        }
        if (metadata.isAnnotated(Primary.class.getName())) {
            beanDef.setPrimary(true);
        }
        if (metadata.isAnnotated(Lazy.class.getName())) {
            lazy = MetadataUtils.attributesFor(metadata, Lazy.class);
            beanDef.setLazyInit(lazy.getBoolean("value"));
        } else if (configClass.getMetadata().isAnnotated(Lazy.class.getName())) {
            lazy = MetadataUtils.attributesFor(configClass.getMetadata(), Lazy.class);
            beanDef.setLazyInit(lazy.getBoolean("value"));
        }
        if (metadata.isAnnotated(DependsOn.class.getName()) && (otherBeans = (dependsOn = MetadataUtils.attributesFor(metadata, DependsOn.class)).getStringArray("value")).length > 0) {
            beanDef.setDependsOn(otherBeans);
        }
        if ((autowire = (Autowire)bean.getEnum("autowire")).isAutowire()) {
            beanDef.setAutowireMode(autowire.value());
        }
        if (StringUtils.hasText((String)(initMethodName = bean.getString("initMethod")))) {
            beanDef.setInitMethodName(initMethodName);
        }
        if (StringUtils.hasText((String)(destroyMethodName = bean.getString("destroyMethod")))) {
            beanDef.setDestroyMethodName(destroyMethodName);
        }
        ScopedProxyMode proxyMode = ScopedProxyMode.NO;
        AnnotationAttributes scope = MetadataUtils.attributesFor(metadata, Scope.class);
        if (scope != null) {
            beanDef.setScope(scope.getString("value"));
            proxyMode = (ScopedProxyMode)scope.getEnum("proxyMode");
            if (proxyMode == ScopedProxyMode.DEFAULT) {
                proxyMode = ScopedProxyMode.NO;
            }
        }
        ConfigurationClassBeanDefinition beanDefToRegister = beanDef;
        if (proxyMode != ScopedProxyMode.NO) {
            BeanDefinitionHolder proxyDef = ScopedProxyCreator.createScopedProxy(new BeanDefinitionHolder((BeanDefinition)beanDef, beanName), this.registry, proxyMode == ScopedProxyMode.TARGET_CLASS);
            beanDefToRegister = new ConfigurationClassBeanDefinition((RootBeanDefinition)proxyDef.getBeanDefinition(), configClass);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Registering bean definition for @Bean method %s.%s()", configClass.getMetadata().getClassName(), beanName));
        }
        this.registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefToRegister);
    }

    private void loadBeanDefinitionsFromImportedResources(Map<String, Class<? extends BeanDefinitionReader>> importedResources) {
        HashMap<Class<? extends BeanDefinitionReader>, BeanDefinitionReader> readerInstanceCache = new HashMap<Class<? extends BeanDefinitionReader>, BeanDefinitionReader>();
        for (Map.Entry<String, Class<? extends BeanDefinitionReader>> entry : importedResources.entrySet()) {
            String resource = entry.getKey();
            Class<? extends BeanDefinitionReader> readerClass = entry.getValue();
            if (!readerInstanceCache.containsKey(readerClass)) {
                try {
                    BeanDefinitionReader readerInstance = readerClass.getConstructor(BeanDefinitionRegistry.class).newInstance(this.registry);
                    if (readerInstance instanceof AbstractBeanDefinitionReader) {
                        AbstractBeanDefinitionReader abdr = (AbstractBeanDefinitionReader)readerInstance;
                        abdr.setResourceLoader(this.resourceLoader);
                        abdr.setEnvironment(this.environment);
                    }
                    readerInstanceCache.put(readerClass, readerInstance);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Could not instantiate BeanDefinitionReader class [" + readerClass.getName() + "]");
                }
            }
            BeanDefinitionReader reader = (BeanDefinitionReader)readerInstanceCache.get(readerClass);
            reader.loadBeanDefinitions(resource);
        }
    }

    private static class InvalidConfigurationImportProblem
    extends Problem {
        public InvalidConfigurationImportProblem(String className, Resource resource, AnnotationMetadata metadata) {
            super(String.format("%s was @Import'ed but is not annotated with @Configuration nor does it declare any @Bean methods; it does not implement ImportSelector or extend ImportBeanDefinitionRegistrar. Update the class to meet one of these requirements or do not attempt to @Import it.", className), new Location(resource, (Object)metadata));
        }
    }

    private static class ConfigurationClassBeanDefinition
    extends RootBeanDefinition
    implements AnnotatedBeanDefinition {
        private final AnnotationMetadata annotationMetadata;

        public ConfigurationClassBeanDefinition(ConfigurationClass configClass) {
            this.annotationMetadata = configClass.getMetadata();
        }

        public ConfigurationClassBeanDefinition(RootBeanDefinition original, ConfigurationClass configClass) {
            super(original);
            this.annotationMetadata = configClass.getMetadata();
        }

        private ConfigurationClassBeanDefinition(ConfigurationClassBeanDefinition original) {
            super((RootBeanDefinition)original);
            this.annotationMetadata = original.annotationMetadata;
        }

        public AnnotationMetadata getMetadata() {
            return this.annotationMetadata;
        }

        public boolean isFactoryMethod(Method candidate) {
            return super.isFactoryMethod(candidate) && BeanAnnotationHelper.isBeanAnnotated(candidate);
        }

        public ConfigurationClassBeanDefinition cloneBeanDefinition() {
            return new ConfigurationClassBeanDefinition(this);
        }
    }
}

