/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure.type;

import java.sql.Timestamp;
import liquibase.database.Database;
import liquibase.database.structure.type.DataType;
import liquibase.statement.DatabaseFunction;

public class DateTimeType
extends DataType {
    public DateTimeType() {
        super("DATETIME", 0, 1);
    }

    public DateTimeType(String dataTypeName) {
        super(dataTypeName, 0, 1);
    }

    public boolean getSupportsPrecision() {
        return true;
    }

    public String convertObjectToString(Object value, Database database) {
        if (value == null) {
            return null;
        }
        if (value.toString().equalsIgnoreCase("null")) {
            return "null";
        }
        if (value.toString().equals("CURRENT_TIMESTAMP()")) {
            return database.getCurrentDateTimeFunction();
        }
        if (value instanceof DatabaseFunction) {
            return ((DatabaseFunction)value).getValue();
        }
        if (database.getDatabaseFunctions().contains(new DatabaseFunction(value.toString()))) {
            return value.toString();
        }
        if (value instanceof String) {
            return "'" + ((String)value).replaceAll("'", "''") + "'";
        }
        return database.getDateTimeLiteral((Timestamp)value);
    }
}

