/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public abstract class TextualPropertyType
extends PropertyType {
    static final int NO_VALUE = 0;
    static final int NO_TRIM_VALUE = 1;
    static final int TRIM_SPACE_VALUE = 2;
    static final int TRIM_EMPTY_TO_NULL_VALUE = 4;

    TextualPropertyType(String displayNameID) {
        super(displayNameID);
    }

    @Override
    public Object validateValue(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.trimString((String)value, defn.getTrimOption());
        }
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", this.getTypeCode());
    }

    @Override
    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value instanceof Expression) {
            return ((Expression)value).toString();
        }
        return (String)value;
    }

    protected String trimString(String value, int trimOption) {
        if (value == null) {
            return null;
        }
        if ((trimOption & 2) != 0) {
            value = value.trim();
        }
        if ((trimOption & 4) != 0 && value.length() == 0) {
            value = null;
        }
        return value;
    }
}

