/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.GetViewDefinitionStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetViewDefinitionGenerator
extends AbstractSqlGenerator<GetViewDefinitionStatement> {
    @Override
    public ValidationErrors validate(GetViewDefinitionStatement getViewDefinitionStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("viewName", getViewDefinitionStatement.getViewName());
        return validationErrors;
    }

    @Override
    public Sql[] generateSql(GetViewDefinitionStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        try {
            String sql = "select view_definition from information_schema.views where upper(table_name)='" + statement.getViewName().toUpperCase() + "'";
            if (database.convertRequestedSchemaToCatalog(statement.getSchemaName()) != null) {
                sql = sql + " and table_schema='" + database.convertRequestedSchemaToSchema(statement.getSchemaName()) + "'";
            } else if (database.convertRequestedSchemaToCatalog(statement.getSchemaName()) != null) {
                sql = sql + " and table_catalog='" + database.convertRequestedSchemaToCatalog(statement.getSchemaName()) + "'";
            }
            return new Sql[]{new UnparsedSql(sql, new DatabaseObject[0])};
        }
        catch (DatabaseException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }
}

