/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiConfigurationOption;
import fr.ifremer.tutti.persistence.RessourceClassLoader;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.type.CoordinateEditorType;
import fr.ifremer.tutti.type.WeightUnit;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.swing.KeyStroke;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigHelper;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationConfiguration;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.util.Version;

public class TuttiConfiguration
extends ApplicationConfiguration {
    private static final Log log = LogFactory.getLog(TuttiConfiguration.class);
    private static TuttiConfiguration instance;
    protected final String[] optionKeyToNotSave;
    protected File configFile;

    public static TuttiConfiguration getInstance() {
        return instance;
    }

    public static void setInstance(TuttiConfiguration instance) {
        TuttiConfiguration.instance = instance;
    }

    public TuttiConfiguration(ApplicationConfig applicationConfig) {
        super(applicationConfig);
        this.optionKeyToNotSave = null;
    }

    public TuttiConfiguration(String file, String ... args) {
        super(new ApplicationConfig());
        this.applicationConfig.setEncoding(Charsets.UTF_8.name());
        Set providers = ApplicationConfigHelper.getProviders(null, null, null, (boolean)true);
        ApplicationConfigHelper.loadAllDefaultOption((ApplicationConfig)this.applicationConfig, (Set)providers);
        Set optionToSkip = ApplicationConfigHelper.getTransientOptionKeys((Set)providers);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Option that won't be saved: " + optionToSkip));
        }
        this.optionKeyToNotSave = optionToSkip.toArray(new String[optionToSkip.size()]);
        this.applicationConfig.setConfigFileName(file);
        try {
            this.applicationConfig.parse(args);
        }
        catch (ArgumentsParserException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.config.parse.error", (Object[])new Object[0]), (Throwable)e);
        }
        File tuttiBasedir = this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.BASEDIR.getKey());
        if (tuttiBasedir == null) {
            tuttiBasedir = new File("");
        }
        if (!tuttiBasedir.isAbsolute()) {
            tuttiBasedir = new File(tuttiBasedir.getAbsolutePath());
        }
        if (tuttiBasedir.getName().equals("..")) {
            tuttiBasedir = tuttiBasedir.getParentFile().getParentFile();
        }
        if (tuttiBasedir.getName().equals(".")) {
            tuttiBasedir = tuttiBasedir.getParentFile();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Application basedir: " + tuttiBasedir));
        }
        this.applicationConfig.setOption(TuttiConfigurationOption.BASEDIR.getKey(), tuttiBasedir.getAbsolutePath());
    }

    public void initConfig(RessourceClassLoader resourceLoader) {
        File directory = this.getDbDirectory();
        ApplicationIOUtil.forceMkdir((File)directory, (String)I18n.t((String)"tutti.io.mkDir.error", (Object[])new Object[]{directory}));
        directory = this.getDbAttachmentDirectory();
        ApplicationIOUtil.forceMkdir((File)directory, (String)I18n.t((String)"tutti.io.mkDir.error", (Object[])new Object[]{directory}));
        directory = this.getProtocolDirectory();
        ApplicationIOUtil.forceMkdir((File)directory, (String)I18n.t((String)"tutti.io.mkDir.error", (Object[])new Object[]{directory}));
        directory = this.getDbBackupDirectory();
        ApplicationIOUtil.forceMkdir((File)directory, (String)I18n.t((String)"tutti.io.mkDir.error", (Object[])new Object[]{directory}));
        File dataDirectory = this.getDataDirectory();
        ApplicationIOUtil.forceMkdir((File)dataDirectory, (String)I18n.t((String)"tutti.io.mkDir.error", (Object[])new Object[]{dataDirectory}));
        File tmpDirectory = this.getTmpDirectory();
        if (tmpDirectory.exists()) {
            if (tmpDirectory.isFile()) {
                ApplicationIOUtil.deleteFile((File)tmpDirectory, (String)I18n.t((String)"tutti.io.deleteTempDirectory.error", (Object[])new Object[]{tmpDirectory}));
            } else {
                ApplicationIOUtil.deleteDirectory((File)tmpDirectory, (String)I18n.t((String)"tutti.io.deleteTempDirectory.error", (Object[])new Object[]{tmpDirectory}));
            }
        }
        ApplicationIOUtil.forceMkdir((File)tmpDirectory, (String)I18n.t((String)"tutti.io.mkDir.error", (Object[])new Object[]{tmpDirectory}));
        ApplicationIOUtil.forceMkdir((File)this.getReportBackupDirectory(), (String)I18n.t((String)"tutti.io.mkDir.error", (Object[])new Object[]{this.getReportBackupDirectory()}));
        resourceLoader.addSearchInDirectoriesPredicate(new Predicate<String>(){
            Set<String> matchingNames;
            {
                this.matchingNames = Sets.newHashSet((Object[])new String[]{TuttiConfiguration.this.getDbConfigurationPath().getName(), TuttiConfiguration.this.getDbEnumerationPath().getName()});
            }

            public boolean apply(String input) {
                return this.matchingNames.contains(input);
            }
        });
        File configurationPath = this.getDbConfigurationPath();
        resourceLoader.addDirectory(configurationPath.getParentFile());
        File enumerationPath = this.getDbEnumerationPath();
        resourceLoader.addDirectory(enumerationPath.getParentFile());
        this.generateExternalDbFiles(false);
    }

    public void prepareDirectories() {
        File dataDirectory = this.getDataDirectory();
        ApplicationIOUtil.forceMkdir((File)dataDirectory, (String)I18n.t((String)"tutti.io.mkDir.error", (Object[])new Object[]{dataDirectory}));
        File tmpDirectory = this.getTmpDirectory();
        if (tmpDirectory.exists()) {
            ApplicationIOUtil.deleteDirectory((File)tmpDirectory, (String)I18n.t((String)"tutti.io.deleteTempDirectory.error", (Object[])new Object[]{tmpDirectory}));
        }
        ApplicationIOUtil.forceMkdir((File)tmpDirectory, (String)I18n.t((String)"tutti.io.mkDir.error", (Object[])new Object[]{tmpDirectory}));
        ApplicationIOUtil.forceMkdir((File)this.getReportBackupDirectory(), (String)I18n.t((String)"tutti.io.mkDir.error", (Object[])new Object[]{this.getReportBackupDirectory()}));
    }

    public void generateExternalDbFiles(boolean force) {
        try {
            this.generateDbConfiguration(true);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.persistence.config.generateFile.error", (Object[])new Object[0]));
        }
        try {
            this.generateDbEnumerationConfiguration(force);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.persistence.config.generateEnumFile.error", (Object[])new Object[0]));
        }
    }

    public File newTempFile(String basename) {
        return new File(this.getTmpDirectory(), basename + "_" + System.nanoTime());
    }

    public boolean isDbExists() {
        File f = new File(this.getDbDirectory(), this.getDbName() + ".data");
        return f.exists();
    }

    public File getConfigFile() {
        if (this.configFile == null) {
            File dir = this.getBasedir();
            if (dir == null || !dir.exists() || !this.isFullLaunchMode()) {
                dir = new File(this.applicationConfig.getUserConfigDirectory());
            }
            this.configFile = new File(dir, this.applicationConfig.getConfigFileName());
        }
        return this.configFile;
    }

    public String getHelpResourceWithLocale(String value) {
        File directory = new File(this.getHelpDirectory(), this.getI18nLocale().getLanguage());
        File result = new File(directory, value);
        return result.toString();
    }

    public void save() {
        File file = this.getConfigFile();
        if (log.isInfoEnabled()) {
            log.info((Object)("Save configuration at: " + file));
        }
        try {
            this.applicationConfig.save(file, false, this.optionKeyToNotSave);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.config.save.error", (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)((Object)this));
    }

    public void setSampleCategoryModel(SampleCategoryModel model) {
        this.applicationConfig.setOption(TuttiConfigurationOption.SAMPLE_CATEGORY_MODEL.getKey(), String.valueOf(model));
    }

    public void setCsvSeparator(char c) {
        this.applicationConfig.setOption(TuttiConfigurationOption.CSV_SEPARATOR.getKey(), c + "");
    }

    public void setExportCountry(String exportCountryId) {
        this.applicationConfig.setOption(TuttiConfigurationOption.EXPORT_COUNTRY_ID.getKey(), exportCountryId);
    }

    public void setI18nLocale(Locale locale) {
        this.applicationConfig.setOption(TuttiConfigurationOption.I18N_LOCALE.getKey(), locale.toString());
    }

    public void setProgramId(String programId) {
        if (programId == null) {
            programId = "";
        }
        this.applicationConfig.setOption(TuttiConfigurationOption.PROGRAM_ID.getKey(), programId);
    }

    public void setCruiseId(String cruiseId) {
        if (cruiseId == null) {
            cruiseId = "";
        }
        this.applicationConfig.setOption(TuttiConfigurationOption.CRUISE_ID.getKey(), cruiseId);
    }

    public void setProtocolId(String protocolId) {
        if (protocolId == null) {
            protocolId = "";
        }
        this.applicationConfig.setOption(TuttiConfigurationOption.PROTOCOL_ID.getKey(), protocolId);
    }

    public File getDbConfigurationPath() {
        return this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.DB_CONFIGURATION_PATH.getKey());
    }

    public File getDbDirectory() {
        return this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.DB_DIRECTORY.getKey());
    }

    public File getDbAttachmentDirectory() {
        return this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.DB_ATTACHMENT_DIRECTORY.getKey());
    }

    public File getCacheDirectory() {
        return this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.DB_CACHE_DIRECTORY.getKey());
    }

    public File getDbBackupDirectory() {
        return this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.DB_BACKUP_DIRECTORY.getKey());
    }

    public File getProtocolDirectory() {
        return this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.DB_PROTOCOL_DIRECTORY.getKey());
    }

    public String getDbName() {
        return this.applicationConfig.getOption(TuttiConfigurationOption.DB_NAME.getKey());
    }

    public SampleCategoryModel getSampleCategoryModel() {
        SampleCategoryModel result = (SampleCategoryModel)this.applicationConfig.getOption(SampleCategoryModel.class, TuttiConfigurationOption.SAMPLE_CATEGORY_MODEL.getKey());
        return result;
    }

    public File getDbEnumerationPath() {
        return this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.DB_ENUMERATION_PATH.getKey());
    }

    public String getJdbcUrl() {
        return this.applicationConfig.getOption(TuttiConfigurationOption.JDBC_URL.getKey());
    }

    public Class getJdbcDriver() {
        return this.applicationConfig.getOptionAsClass(TuttiConfigurationOption.JDBC_DRIVER.getKey());
    }

    public String getJdbcUsername() {
        return this.applicationConfig.getOption(TuttiConfigurationOption.JDBC_USERNAME.getKey());
    }

    public String getJdbcPassword() {
        return this.applicationConfig.getOption(TuttiConfigurationOption.JDBC_PASSWORD.getKey());
    }

    public Class getHibernateDialect() {
        return this.applicationConfig.getOptionAsClass(TuttiConfigurationOption.HIBERNATE_DIALECT.getKey());
    }

    public boolean isSanityDb() {
        boolean result = this.applicationConfig.getOptionAsBoolean(TuttiConfigurationOption.DB_SANITY.getKey());
        return result;
    }

    public boolean isHibernateShowSql() {
        boolean result = this.applicationConfig.getOptionAsBoolean(TuttiConfigurationOption.HIBERNATE_SHOW_SQL.getKey());
        return result;
    }

    public boolean isHibernateUseSqlComment() {
        boolean result = this.applicationConfig.getOptionAsBoolean(TuttiConfigurationOption.HIBERNATE_USE_SQL_COMMENT.getKey());
        return result;
    }

    public boolean isHibernateFormatSql() {
        boolean result = this.applicationConfig.getOptionAsBoolean(TuttiConfigurationOption.HIBERNATE_FORMAT_SQL.getKey());
        return result;
    }

    public String getApplicationName() {
        return "Allegro Campagne";
    }

    public Version getVersion() {
        return this.applicationConfig.getOptionAsVersion(TuttiConfigurationOption.VERSION.getKey());
    }

    public URL getSiteUrl() {
        return this.applicationConfig.getOptionAsURL(TuttiConfigurationOption.SITE_URL.getKey());
    }

    public String getOrganizationName() {
        return this.applicationConfig.getOption(TuttiConfigurationOption.ORGANIZATION_NAME.getKey());
    }

    public int getInceptionYear() {
        return this.applicationConfig.getOptionAsInt(TuttiConfigurationOption.INCEPTION_YEAR.getKey());
    }

    public File getBasedir() {
        File result = this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.BASEDIR.getKey());
        return result;
    }

    public File getDataDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.DATA_DIRECTORY.getKey());
        return result;
    }

    public File getReportHomeDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.REPORT_HOME_DIRECTORY.getKey());
        return result;
    }

    public File getReportDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.REPORT_DIRECTORY.getKey());
        return result;
    }

    public File getReportLogDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.REPORT_LOG_DIRECTORY.getKey());
        return result;
    }

    public File getReportBackupDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.REPORT_BACKUP_DIRECTORY.getKey());
        return result;
    }

    public File getTmpDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.TMP_DIRECTORY.getKey());
        return result;
    }

    public char getCsvSeparator() {
        return this.applicationConfig.getOption(TuttiConfigurationOption.CSV_SEPARATOR.getKey()).charAt(0);
    }

    public String getExportCountryId() {
        return this.applicationConfig.getOption(TuttiConfigurationOption.EXPORT_COUNTRY_ID.getKey());
    }

    public List<Integer> getSamplingOrderIds() {
        ApplicationConfig.OptionList result = this.applicationConfig.getOptionAsList(TuttiConfigurationOption.SAMPLING_CATEGORY_ORDER_IDS.getKey());
        return result.getOptionAsInt();
    }

    public WeightUnit getSpeciesWeightUnit() {
        return (WeightUnit)((Object)this.applicationConfig.getOption(WeightUnit.class, TuttiConfigurationOption.WEIGHT_UNIT_SPECIES.getKey()));
    }

    public WeightUnit getBenthosWeightUnit() {
        return (WeightUnit)((Object)this.applicationConfig.getOption(WeightUnit.class, TuttiConfigurationOption.WEIGHT_UNIT_BENTHOS.getKey()));
    }

    public WeightUnit getMarineLitterWeightUnit() {
        return (WeightUnit)((Object)this.applicationConfig.getOption(WeightUnit.class, TuttiConfigurationOption.WEIGHT_UNIT_MARINE_LITTER.getKey()));
    }

    public WeightUnit getIndividualObservationWeightUnit() {
        return (WeightUnit)((Object)this.applicationConfig.getOption(WeightUnit.class, TuttiConfigurationOption.WEIGHT_UNIT_INDIVIDUAL_OBSERVATION.getKey()));
    }

    public WeightUnit getAccidentalCatchWeightUnit() {
        return (WeightUnit)((Object)this.applicationConfig.getOption(WeightUnit.class, TuttiConfigurationOption.WEIGHT_UNIT_ACCIDENTAL_CATCH.getKey()));
    }

    public boolean isFullLaunchMode() {
        return "full".equals(this.getTuttiLaunchMode());
    }

    public String getTuttiLaunchMode() {
        return this.applicationConfig.getOption(TuttiConfigurationOption.LAUNCH_MODE.getKey());
    }

    public File getUIConfigFile() {
        return this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.UI_CONFIG_FILE.getKey());
    }

    public File getStartActionFile() {
        return this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.START_ACTION_FILE.getKey());
    }

    public Float getDifferenceRateBetweenSortedAndTotalWeights() {
        return Float.valueOf(this.applicationConfig.getOptionAsFloat(TuttiConfigurationOption.TOTAL_SORTED_WEIGHTS_DIFFERENCE_RATE.getKey()));
    }

    public String getTremieCarousselVesselId() {
        return this.applicationConfig.getOption(TuttiConfigurationOption.TREMIE_CAROUSSEL_VESSEL_ID.getKey());
    }

    public boolean isAutoPopupNumberEditor() {
        return this.applicationConfig.getOptionAsBoolean(TuttiConfigurationOption.AUTO_POPUP_NUMBER_EDITOR.getKey());
    }

    public boolean isShowNumberEditorButton() {
        return this.applicationConfig.getOptionAsBoolean(TuttiConfigurationOption.SHOW_NUMBER_EDITOR_BUTTON.getKey());
    }

    public CoordinateEditorType getCoordinateEditorType() {
        String value = this.applicationConfig.getOption(TuttiConfigurationOption.COORDINATE_EDITOR_TYPE.getKey());
        return CoordinateEditorType.valueOf(value);
    }

    public String getProgramId() {
        String result = this.applicationConfig.getOption(TuttiConfigurationOption.PROGRAM_ID.getKey());
        return StringUtils.isBlank((CharSequence)result) ? null : result;
    }

    public String getCruiseId() {
        String result = this.applicationConfig.getOption(TuttiConfigurationOption.CRUISE_ID.getKey());
        return StringUtils.isBlank((CharSequence)result) ? null : result;
    }

    public String getProtocolId() {
        String result = this.applicationConfig.getOption(TuttiConfigurationOption.PROTOCOL_ID.getKey());
        return StringUtils.isBlank((CharSequence)result) ? null : result;
    }

    public Color getColorRowInvalid() {
        return this.applicationConfig.getOptionAsColor(TuttiConfigurationOption.COLOR_ROW_INVALID.getKey());
    }

    public Color getColorRowReadOnly() {
        return this.applicationConfig.getOptionAsColor(TuttiConfigurationOption.COLOR_ROW_READ_ONLY.getKey());
    }

    public Color getColorCellWithValue() {
        return this.applicationConfig.getOptionAsColor(TuttiConfigurationOption.COLOR_CELL_WITH_VALUE.getKey());
    }

    public Color getColorRowToConfirm() {
        return this.applicationConfig.getOptionAsColor(TuttiConfigurationOption.COLOR_ROW_TO_CONFIRM.getKey());
    }

    public Color getColorComputedWeights() {
        return this.applicationConfig.getOptionAsColor(TuttiConfigurationOption.COLOR_COMPUTED_WEIGHTS.getKey());
    }

    public Color getColorBlockingLayer() {
        return this.applicationConfig.getOptionAsColor(TuttiConfigurationOption.COLOR_BLOCKING_LAYER.getKey());
    }

    public Color getColorAlternateRow() {
        return this.applicationConfig.getOptionAsColor(TuttiConfigurationOption.COLOR_ALTERNATE_ROW.getKey());
    }

    public Color getColorSelectedRow() {
        return this.applicationConfig.getOptionAsColor(TuttiConfigurationOption.COLOR_SELECTED_ROW.getKey());
    }

    public KeyStroke getShortcutClosePopup() {
        return this.applicationConfig.getOptionAsKeyStroke(TuttiConfigurationOption.SHORTCUT_CLOSE_POPUP.getKey());
    }

    public int getMaxIndividualObservationRowsToCreate() {
        return this.applicationConfig.getOptionAsInt(TuttiConfigurationOption.MAX_INDIVIDUAL_OBSERVATION_ROW_TO_CREATE.getKey());
    }

    public KeyStroke getShortCut(String actionName) {
        KeyStroke result = this.applicationConfig.getOptionAsKeyStroke("tutti.ui." + actionName);
        return result;
    }

    public String getDateFormat() {
        return this.applicationConfig.getOption(TuttiConfigurationOption.DATE_FORMAT.getKey());
    }

    public File getNewTmpDirectory(String name) {
        return new File(this.getTmpDirectory(), name + "_" + System.nanoTime());
    }

    public File getI18nDirectory() {
        return this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.I18N_DIRECTORY.getKey());
    }

    public Locale getI18nLocale() {
        return this.applicationConfig.getOptionAsLocale(TuttiConfigurationOption.I18N_LOCALE.getKey());
    }

    public File getHelpDirectory() {
        return this.applicationConfig.getOptionAsFile(TuttiConfigurationOption.HELP_DIRECTORY.getKey());
    }

    public String getUpdateApplicationUrl() {
        return this.applicationConfig.getOption(TuttiConfigurationOption.UPDATE_APPLICATION_URL.getKey());
    }

    public String getUpdateDataUrl() {
        return this.applicationConfig.getOption(TuttiConfigurationOption.UPDATE_DATA_URL.getKey());
    }

    public String getAdminPassword() {
        return this.applicationConfig.getOption(TuttiConfigurationOption.ADMIN_PASSWORD.getKey());
    }

    public boolean isFullBluetoothScan() {
        return this.applicationConfig.getOptionAsBoolean(TuttiConfigurationOption.FULL_BLUETOOTH_SCAN.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateDbConfiguration(boolean force) throws IOException {
        File destination = this.getDbConfigurationPath();
        if (force || !destination.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Generate " + destination + " from classpath."));
            }
            Properties result = new Properties();
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/tutti-db-conf.properties");
            try {
                result.load(in);
                in.close();
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            result.put("dataSource.jdbc.driver", this.getJdbcDriver().getName());
            result.put("dataSource.jdbc.username", this.getJdbcUsername());
            result.put("dataSource.jdbc.password", this.getJdbcPassword());
            result.put("dataSource.jdbc.url", this.getJdbcUrl());
            result.put("hibernate.dialect", this.getHibernateDialect().getName());
            result.put("hibernate.show_sql", this.isHibernateShowSql() + "");
            result.put("hibernate.format_sql", this.isHibernateFormatSql() + "");
            result.put("hibernate.use_sql_comments", this.isHibernateUseSqlComment() + "");
            result.put("ehcache.disk.store.dir", this.getCacheDirectory().getAbsolutePath());
            BufferedWriter writer = Files.newWriter((File)destination, (Charset)Charsets.UTF_8);
            try {
                result.store(writer, "Generated by " + ((Object)((Object)this)).getClass().getName());
                writer.close();
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateDbEnumerationConfiguration(boolean force) throws IOException {
        File destination = this.getDbEnumerationPath();
        if (force || !destination.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Generate " + destination + " from classpath."));
            }
            Properties result = new Properties();
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/tutti-db-enumerations.properties");
            try {
                result.load(in);
                in.close();
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            BufferedWriter writer = Files.newWriter((File)destination, (Charset)Charsets.UTF_8);
            try {
                result.store(writer, "Generated by " + ((Object)((Object)this)).getClass().getName());
                writer.close();
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getDbEnumerations() throws IOException {
        Properties result = new Properties();
        BufferedReader in = Files.newReader((File)this.getDbEnumerationPath(), (Charset)Charsets.UTF_8);
        try {
            result.load(in);
            in.close();
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
        return result;
    }
}

