/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ooxml;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.report.engine.ooxml.ContentType;
import org.eclipse.birt.report.engine.ooxml.IPart;
import org.eclipse.birt.report.engine.ooxml.Package;
import org.eclipse.birt.report.engine.ooxml.PartContainer;
import org.eclipse.birt.report.engine.ooxml.util.OOXmlUtil;

public class Part
extends PartContainer
implements IPart {
    private Package pkg;
    private ContentType contentType;
    private int relationshipId;
    private PartContainer parent;
    private String relationshipType;

    Part(PartContainer partContainer, String uri, ContentType contentType, String relationshipType, int relationshipId) {
        super(uri);
        this.parent = partContainer;
        this.pkg = partContainer.getPackage();
        this.relationshipId = relationshipId;
        this.relationshipType = relationshipType;
        this.contentType = contentType;
        this.pkg.addContentType(contentType);
    }

    @Override
    public String getRelativeUri() {
        return this.uri.toString();
    }

    @Override
    public Package getPackage() {
        return this.pkg;
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public OutputStream getCacheOutputStream() throws IOException {
        return this.pkg.getOutputStream(this.getAbsoluteUri());
    }

    @Override
    public String getAbsoluteUri() {
        return this.parent.getAbsolutUriOfChild(this.uri);
    }

    @Override
    public String getRelationshipId() {
        return OOXmlUtil.getRelationShipId(this.relationshipId);
    }

    @Override
    public String getRelationshipUri() {
        String partUri = this.getAbsoluteUri();
        int lastIndex = partUri.lastIndexOf(47);
        String uri = String.valueOf(partUri.substring(0, lastIndex + 1)) + "_rels/" + partUri.substring(lastIndex + 1) + ".rels";
        return uri;
    }

    @Override
    public String getRelationshipType() {
        return this.relationshipType;
    }

    @Override
    public boolean isCached() {
        return this.cacheWriterUsed;
    }

    @Override
    public boolean isReference() {
        return false;
    }
}

