/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device;

import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.eclipse.birt.chart.device.IImageWriterFactory;

public class ImageWriterFactory
implements IImageWriterFactory {
    private static IImageWriterFactory factory = new ImageWriterFactory();

    public static void initInstance(IImageWriterFactory tFactory) {
        factory = tFactory;
    }

    public static IImageWriterFactory instance() {
        return factory;
    }

    @Override
    public ImageWriter createByFormatName(String formatName) {
        Iterator<ImageWriter> it;
        if (formatName != null && (it = ImageIO.getImageWritersByFormatName(formatName)).hasNext()) {
            return it.next();
        }
        return null;
    }

    @Override
    public ImageWriter createImageWriter(String formatName, String outputFormat) {
        return this.createByFormatName(formatName);
    }
}

