package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportIndividualObservationMultiPostAction.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.3.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/ImportIndividualObservationMultiPostAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIModel;

import static org.nuiton.i18n.I18n.t;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.2
 */
public class ImportIndividualObservationMultiPostAction
        extends AbstractImportMultiPostAction<IndividualObservationBatchUIModel, IndividualObservationBatchUI, IndividualObservationBatchUIHandler> {

    public ImportIndividualObservationMultiPostAction(IndividualObservationBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiIndividualObservation";
    }

    @Override
    protected String getFileExtensionDescription() {
        return t("tutti.common.file.tuttiIndividualObservation");
    }

    @Override
    protected String getFileChooserTitle() {
        return t("tutti.editIndividualObservationBatch.action.importMultiPost.sourceFile.title");
    }

    @Override
    protected String getFileChooserButton() {
        return t("tutti.editIndividualObservationBatch.action.importMultiPost.sourceFile.button");
    }

    @Override
    protected void importBatches(FishingOperation operation) {
        multiPostImportExportService.importIndividualObservation(file, operation);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        sendMessage(t("tutti.editIndividualObservationBatch.action.importMultiPost.success", file));
    }
}
