package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportPupitriAction.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.3.4/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/ExportPupitriAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.pupitri.PupitriImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;
import java.util.List;

import static org.nuiton.i18n.I18n.t;

/**
 * To export protocol species.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ExportPupitriAction extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ExportPupitriAction.class);

    private File file;

    public ExportPupitriAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            // choose file to export
            file = saveFile(
                    "tuttiProtocol-" + getModel().getName() + "-pupitri",
                    "csv",
                    t("tutti.editProtocol.title.choose.speciesExportFile"),
                    t("tutti.editProtocol.action.chooseProtocolSpeciesFile")
            );
            doAction = file != null;
        }
        return doAction;
    }

    @Override
    public void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull(file);
        if (log.isInfoEnabled()) {
            log.info("Will export protocol species to file: " + file);
        }

        EditProtocolUIModel model = getModel();

        // build species protocol to export

        List<Species> speciesList = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : model.getSpeciesRow()) {
            if (row.isValid()) {
                Species species = row.getSpecies();
                species.setSurveyCode(row.getSpeciesSurveyCode());
                speciesList.add(species);
            }
        }

        // import
        PupitriImportExportService service =
                getContext().getTuttiPupitriImportExportService();

        service.exportSpecies(speciesList, file);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        sendMessage(t("tutti.flash.info.species.exported.from.protocol",
                      file));
    }
}