/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.impl.MultipleFillImpl;
import org.eclipse.emf.common.util.EList;

public class FillUtil {
    private static final IGObjectFactory goFactory = GObjectFactory.instance();

    public static ColorDefinition getDarkerColor(Fill fill) {
        if (fill instanceof ColorDefinition) {
            return goFactory.darker((ColorDefinition)fill);
        }
        if (fill instanceof Gradient) {
            ColorDefinition cdStart = ((Gradient)fill).getStartColor();
            ColorDefinition cdEnd = ((Gradient)fill).getEndColor();
            return goFactory.darker(FillUtil.getSortedColors(false, cdStart, cdEnd));
        }
        if (fill instanceof Image) {
            return goFactory.createColorDefinition(128, 128, 128);
        }
        if (fill instanceof MultipleFill) {
            EList<Fill> fills = ((MultipleFill)fill).getFills();
            ColorDefinition cd0 = FillUtil.getColor((Fill)fills.get(0));
            ColorDefinition cd1 = FillUtil.getColor((Fill)fills.get(1));
            return goFactory.darker(FillUtil.getSortedColors(false, cd0, cd1));
        }
        return null;
    }

    public static Fill getDarkerFill(Fill fill) {
        if (fill instanceof ColorDefinition) {
            return goFactory.darker((ColorDefinition)fill);
        }
        if (fill instanceof Gradient) {
            ColorDefinition cdStart = ((Gradient)fill).getStartColor();
            ColorDefinition cdEnd = ((Gradient)fill).getEndColor();
            return goFactory.createGradient(goFactory.darker(cdStart), goFactory.darker(cdEnd));
        }
        if (fill instanceof MultipleFill) {
            EList<Fill> fills = ((MultipleFill)fill).getFills();
            MultipleFill newFill = MultipleFillImpl.create();
            for (Fill fill_i : fills) {
                newFill.getFills().add((Object)FillUtil.getDarkerFill(fill_i));
            }
            return newFill;
        }
        if (fill instanceof Image) {
            return fill.copyInstance();
        }
        return fill;
    }

    public static ColorDefinition getBrighterColor(Fill fill) {
        if (fill instanceof ColorDefinition) {
            return goFactory.brighter((ColorDefinition)fill);
        }
        if (fill instanceof Gradient) {
            ColorDefinition cdStart = ((Gradient)fill).getStartColor();
            ColorDefinition cdEnd = ((Gradient)fill).getEndColor();
            return goFactory.brighter(FillUtil.getSortedColors(true, cdStart, cdEnd));
        }
        if (fill instanceof Image) {
            return goFactory.createColorDefinition(192, 192, 192);
        }
        if (fill instanceof MultipleFill) {
            EList<Fill> fills = ((MultipleFill)fill).getFills();
            ColorDefinition cd0 = FillUtil.getColor((Fill)fills.get(0));
            ColorDefinition cd1 = FillUtil.getColor((Fill)fills.get(1));
            return goFactory.brighter(FillUtil.getSortedColors(true, cd0, cd1));
        }
        return null;
    }

    public static Fill changeBrightness(Fill fill, double brightness) {
        if (fill instanceof ColorDefinition) {
            ColorDefinition new_fill = goFactory.copyOf((ColorDefinition)fill);
            FillUtil.applyBrightness(new_fill, brightness);
            return new_fill;
        }
        return fill;
    }

    public static Fill getBrighterFill(Fill fill) {
        if (fill instanceof ColorDefinition) {
            return goFactory.brighter((ColorDefinition)fill);
        }
        if (fill instanceof Gradient) {
            ColorDefinition cdStart = ((Gradient)fill).getStartColor();
            ColorDefinition cdEnd = ((Gradient)fill).getEndColor();
            return goFactory.createGradient(goFactory.brighter(cdStart), goFactory.brighter(cdEnd));
        }
        if (fill instanceof MultipleFill) {
            EList<Fill> fills = ((MultipleFill)fill).getFills();
            MultipleFill newFill = MultipleFillImpl.create();
            for (Fill fill_i : fills) {
                newFill.getFills().add((Object)FillUtil.getBrighterFill(fill_i));
            }
            return newFill;
        }
        if (fill instanceof Image) {
            return fill.copyInstance();
        }
        return fill;
    }

    static ColorDefinition getSortedColors(boolean bBrighter, ColorDefinition cd1, ColorDefinition cd2) {
        int result = cd1.getRed() + cd1.getGreen() + cd1.getBlue() - (cd2.getRed() + cd2.getGreen() + cd2.getBlue());
        if (bBrighter) {
            return result > 0 ? cd1 : cd2;
        }
        return result > 0 ? cd2 : cd1;
    }

    public static Fill convertFillToGradient(Fill fill, boolean bTransposed) {
        Gradient grad = null;
        if (fill instanceof ColorDefinition) {
            grad = FillUtil.createDefaultGradient((ColorDefinition)fill);
        } else if (fill instanceof MultipleFill) {
            EList<Fill> fills = ((MultipleFill)fill).getFills();
            if (fills.get(0) instanceof ColorDefinition) {
                grad = FillUtil.createDefaultGradient((ColorDefinition)fills.get(0));
            }
        } else if (fill instanceof Gradient) {
            grad = (Gradient)fill;
        }
        if (grad != null) {
            if (bTransposed && !grad.isSetDirection()) {
                grad.setDirection(90.0);
            }
            return grad;
        }
        return fill;
    }

    private static void applyBrightness(ColorDefinition cdf, double brightness) {
        cdf.set((int)((double)cdf.getRed() * brightness), (int)((double)cdf.getGreen() * brightness), (int)((double)cdf.getBlue() * brightness), cdf.getTransparency());
    }

    public static Fill convertFillToGradient3D(Fill fill, boolean bTransposed) {
        if (fill instanceof ColorDefinition) {
            Gradient gradient = AttributeFactory.eINSTANCE.createGradient();
            ColorDefinition newStartColor = (ColorDefinition)FillUtil.changeBrightness(fill, 0.95);
            gradient.setStartColor(newStartColor);
            ColorDefinition newColor = (ColorDefinition)FillUtil.changeBrightness(fill, 0.65);
            gradient.setEndColor(newColor);
            return gradient;
        }
        return FillUtil.convertFillToGradient(fill, bTransposed);
    }

    public static Gradient createDefaultGradient(ColorDefinition color) {
        if (color == null) {
            return null;
        }
        int currentLuminance = FillUtil.convertRGBToLuminance(color.getRed(), color.getGreen(), color.getBlue());
        ColorDefinition newStartColor = goFactory.copyOf(color);
        ColorDefinition newEndColor = goFactory.copyOf(color);
        if (currentLuminance < 200) {
            int lumDiff = 240 - currentLuminance;
            newEndColor.setRed(FillUtil.getNewColor(lumDiff, newEndColor.getRed(), 0.3));
            newEndColor.setGreen(FillUtil.getNewColor(lumDiff, newEndColor.getGreen(), 0.59));
            newEndColor.setBlue(FillUtil.getNewColor(lumDiff, newEndColor.getBlue(), 0.11));
        } else {
            int lumDiff = -100;
            newStartColor.setRed(FillUtil.getNewColor(lumDiff, newStartColor.getRed(), 0.3));
            newStartColor.setGreen(FillUtil.getNewColor(lumDiff, newStartColor.getGreen(), 0.59));
            newStartColor.setBlue(FillUtil.getNewColor(lumDiff, newStartColor.getBlue(), 0.11));
        }
        return goFactory.createGradient(newStartColor, newEndColor);
    }

    private static int convertRGBToLuminance(int red, int green, int blue) {
        return (int)(0.3 * (double)red + 0.59 * (double)green + 0.11 * (double)blue);
    }

    private static int getNewColor(int lumDiff, int oldColor, double coefficient) {
        int newColor = (int)((double)lumDiff * coefficient) + oldColor;
        if (newColor < 0) {
            return 0;
        }
        return newColor < 255 ? newColor : 255;
    }

    public static Fill copyOf(Fill src) {
        return src.copyInstance();
    }

    private static ColorDefinition tunePaletteColor(ColorDefinition paletteColor, int paletteSize, int index) {
        ColorDefinition color = goFactory.copyOf(paletteColor);
        int cycle = index / paletteSize;
        int offset = (cycle / 3 + 1) * 71;
        int phrase = cycle % 3;
        switch (phrase) {
            case 0: {
                color.setRed((color.getRed() + offset) % 256);
                color.setGreen((color.getGreen() + offset) % 256);
                break;
            }
            case 1: {
                color.setRed((color.getRed() + offset) % 256);
                color.setBlue((color.getBlue() + offset) % 256);
                break;
            }
            case 2: {
                color.setGreen((color.getGreen() + offset) % 256);
                color.setBlue((color.getBlue() + offset) % 256);
            }
        }
        return color;
    }

    public static Fill getPaletteFill(EList<Fill> elPalette, int index) {
        int iPaletteSize = elPalette.size();
        if (iPaletteSize == 0) {
            return null;
        }
        Fill fill = (Fill)elPalette.get(index % iPaletteSize);
        if (index < iPaletteSize) {
            return goFactory.copyOf(fill);
        }
        if (fill instanceof ColorDefinition) {
            return FillUtil.tunePaletteColor((ColorDefinition)fill, iPaletteSize, index);
        }
        int d = index / iPaletteSize;
        if (d % 2 != 0) {
            Fill brighterFill = FillUtil.getBrighterFill(fill);
            while (d / 2 > 0) {
                d -= 2;
                brighterFill = FillUtil.getBrighterFill(brighterFill);
            }
            return brighterFill;
        }
        Fill darkerFill = FillUtil.getDarkerFill(fill);
        while ((d - 1) / 2 > 0) {
            d -= 2;
            darkerFill = FillUtil.getDarkerFill(darkerFill);
        }
        return darkerFill;
    }

    public static Fill convertFill(Fill fill, double dValue, Fill fNegative) {
        if (dValue >= 0.0) {
            if (fill instanceof MultipleFill) {
                fill = goFactory.copyOf((Fill)((MultipleFill)fill).getFills().get(0));
            }
        } else if (fill instanceof MultipleFill) {
            fill = goFactory.copyOf((Fill)((MultipleFill)fill).getFills().get(1));
        } else if (fNegative != null) {
            fill = fNegative;
        }
        return fill;
    }

    public static ColorDefinition getColor(Fill fill) {
        return FillUtil.getColor(fill, true);
    }

    public static ColorDefinition getColor(Fill fill, boolean bSelBrighter) {
        if (fill instanceof ColorDefinition) {
            return goFactory.copyOf((ColorDefinition)fill);
        }
        if (fill instanceof Gradient) {
            ColorDefinition cdStart = ((Gradient)fill).getStartColor();
            ColorDefinition cdEnd = ((Gradient)fill).getEndColor();
            return goFactory.copyOf(FillUtil.getSortedColors(bSelBrighter, cdStart, cdEnd));
        }
        if (fill instanceof Image) {
            return goFactory.createColorDefinition(192, 192, 192);
        }
        if (fill instanceof MultipleFill) {
            EList<Fill> fills = ((MultipleFill)fill).getFills();
            ColorDefinition cdStart = FillUtil.getColor((Fill)fills.get(0));
            ColorDefinition cdEnd = FillUtil.getColor((Fill)fills.get(fills.size() - 1));
            return goFactory.copyOf(FillUtil.getSortedColors(bSelBrighter, cdStart, cdEnd));
        }
        return null;
    }
}

