/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.disk.IRowIterator;
import org.eclipse.birt.data.engine.executor.cache.disk.MergeSortRowFiles;
import org.eclipse.birt.data.engine.executor.cache.disk.MergeSortUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.MergeTempFileUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.RowFile;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odi.IResultObject;

class MergeSortImpl {
    private int dataCountOfUnit;
    private MergeSortUtil mergeSortUtil;
    private MergeTempFileUtil tempFileUtil;
    private List tempRowFiles;
    private static final int maxOpenFile = 500;
    private DataEngineSession session;

    MergeSortImpl(int dataCountOfUnit, MergeSortUtil mergeSortUtil, MergeTempFileUtil tempFileUtil, List tempRowFiles, DataEngineSession session) {
        this.dataCountOfUnit = dataCountOfUnit;
        this.mergeSortUtil = mergeSortUtil;
        this.tempFileUtil = tempFileUtil;
        this.tempRowFiles = tempRowFiles;
        this.session = session;
    }

    IRowIterator mergeSortOnUnits() throws IOException, DataException {
        MergeSortRowFiles goalFile = null;
        int granularity = 0;
        boolean finish = false;
        do {
            this.tempFileUtil.newMergeLevel();
            granularity = this.getMergeGranularity();
            if (granularity == this.tempRowFiles.size()) {
                goalFile = new MergeSortRowFiles(MergeSortImpl.getSubList(this.tempRowFiles, 0, this.tempRowFiles.size() - 1), this.mergeSortUtil);
                this.tempRowFiles.clear();
                finish = true;
                continue;
            }
            this.levelMergeSort(granularity);
        } while (!finish);
        return goalFile;
    }

    private int getMergeGranularity() {
        return Math.min(this.dataCountOfUnit, Math.min(500, this.tempRowFiles.size()));
    }

    private void levelMergeSort(int granularity) throws IOException, DataException {
        int mergeCount = 0;
        ArrayList<RowFile> newTempList = new ArrayList<RowFile>();
        RowFile targetFile = null;
        do {
            targetFile = this.tempFileUtil.newTempFile(0);
            this.mergeRowFiles(MergeSortImpl.getSubList(this.tempRowFiles, mergeCount * granularity, (mergeCount + 1) * granularity - 1), targetFile);
            newTempList.add(targetFile);
        } while (!this.session.getStopSign().isStopped() && ++mergeCount * granularity <= this.tempRowFiles.size() - 1);
        this.tempRowFiles.clear();
        this.tempRowFiles = newTempList;
    }

    private static RowFile[] getSubList(List list, int start, int end) {
        RowFile[] rowFiles = null;
        end = Math.min(end, list.size() - 1);
        rowFiles = new RowFile[end - start + 1];
        int i = 0;
        while (i < rowFiles.length) {
            rowFiles[i] = (RowFile)list.get(start + i);
            ++i;
        }
        return rowFiles;
    }

    private void mergeRowFiles(RowFile[] sourceFiles, RowFile targetFile) throws IOException, DataException {
        MergeSortRowFiles mergeSortRowSet = new MergeSortRowFiles(sourceFiles, this.mergeSortUtil);
        IResultObject resultObject = mergeSortRowSet.fetch();
        while (resultObject != null) {
            targetFile.write(resultObject);
            resultObject = mergeSortRowSet.fetch();
        }
        mergeSortRowSet.close();
        targetFile.endWrite();
    }
}

