/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class SVGGElementBridge
extends AbstractGraphicsNodeBridge {
    public String getLocalName() {
        return "g";
    }

    public Bridge getInstance() {
        return new SVGGElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Rectangle2D rectangle2D;
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)super.createGraphicsNode(bridgeContext, element);
        if (compositeGraphicsNode == null) {
            return null;
        }
        RenderingHints renderingHints = null;
        if ((renderingHints = CSSUtilities.convertColorRendering(element, renderingHints)) != null) {
            compositeGraphicsNode.setRenderingHints(renderingHints);
        }
        if ((rectangle2D = CSSUtilities.convertEnableBackground(element)) != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        return compositeGraphicsNode;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new CompositeGraphicsNode();
    }

    public boolean isComposite() {
        return true;
    }

    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
        if (mutationEvent.getTarget() instanceof Element) {
            this.handleElementAdded((CompositeGraphicsNode)this.node, this.e, (Element)((Object)mutationEvent.getTarget()));
        }
    }

    public void handleElementAdded(CompositeGraphicsNode compositeGraphicsNode, Node node, Element element) {
        GVTBuilder gVTBuilder = this.ctx.getGVTBuilder();
        GraphicsNode graphicsNode = gVTBuilder.build(this.ctx, element);
        if (graphicsNode == null) {
            return;
        }
        int n = -1;
        Node node2 = element.getPreviousSibling();
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                Element element2 = (Element)node2;
                GraphicsNode graphicsNode2 = this.ctx.getGraphicsNode(element2);
                while (graphicsNode2 != null && graphicsNode2.getParent() != compositeGraphicsNode) {
                    graphicsNode2 = graphicsNode2.getParent();
                }
                if (graphicsNode2 != null && (n = compositeGraphicsNode.indexOf((Object)graphicsNode2)) != -1) break;
            }
            node2 = node2.getPreviousSibling();
        }
        compositeGraphicsNode.add(++n, (Object)graphicsNode);
    }
}

