/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.generic;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.generic.ParameterExportRow;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.nuiton.csv.ValueFormatter;

public class ParameterExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<ParameterExportRow> {
    public ParameterExportModel(char separator, DecoratorService decoratorService) {
        super(separator);
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", "name");
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newColumnForExport("Code_station", "stationNumber");
        this.newColumnForExport("Id_Operation", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("Code_PMFM", "caracteristic", "id");
        this.newColumnForExportByDecorator("Libelle_PMFm", "caracteristic", decoratorService.getDecoratorByType(Caracteristic.class));
        this.newColumnForExport("Valeur", "value", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
    }

    public void prepareRows(List<ParameterExportRow> rows, Cruise cruise, FishingOperation operation) {
        CaracteristicMap vesselUseFeatures;
        CaracteristicMap gearUseFeatures = operation.getGearUseFeatures();
        if (gearUseFeatures != null) {
            for (Map.Entry entry : gearUseFeatures.entrySet()) {
                Caracteristic caracteristic = (Caracteristic)entry.getKey();
                ParameterExportRow row = new ParameterExportRow();
                row.setCruise(cruise);
                row.setFishingOperation(operation);
                row.setCaracteristic(caracteristic);
                row.setValue((Serializable)entry.getValue());
                rows.add(row);
            }
        }
        if ((vesselUseFeatures = operation.getVesselUseFeatures()) != null) {
            for (Map.Entry entry : vesselUseFeatures.entrySet()) {
                Caracteristic caracteristic = (Caracteristic)entry.getKey();
                ParameterExportRow row = new ParameterExportRow();
                row.setCruise(cruise);
                row.setFishingOperation(operation);
                row.setCaracteristic(caracteristic);
                row.setValue((Serializable)entry.getValue());
                rows.add(row);
            }
        }
    }
}

