/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.update;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.update.ApplicationUpdateException;
import fr.ifremer.tutti.ui.swing.update.TuttiReportUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.update.module.ModuleUpdaterSupport;
import fr.ifremer.tutti.ui.swing.updater.UpdateModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.action.ApplicationActionException;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.updater.ApplicationUpdaterCallback;

public abstract class TuttiUpdaterCallBackSupport
implements ApplicationUpdaterCallback {
    private static final Log log = LogFactory.getLog(TuttiReportUpdaterCallBack.class);
    protected final TuttiUIContext context;
    protected ProgressionModel progressionModel;
    protected final AbstractTuttiAction action;
    protected final String url;
    protected final Map<UpdateModule, ModuleUpdaterSupport> allUpdaters;
    protected Set<UpdateModule> modulesToUpdate;
    protected boolean applicationUpdated;

    public TuttiUpdaterCallBackSupport(String url, Map<UpdateModule, ModuleUpdaterSupport> allUpdaters, AbstractTuttiAction action, ProgressionModel progressionModel) {
        this.url = url;
        this.action = action;
        this.allUpdaters = allUpdaters;
        this.context = action.getContext();
        this.progressionModel = progressionModel;
    }

    public void setModulesToUpdate(UpdateModule ... modulesToUpdate) {
        this.modulesToUpdate = Sets.newHashSet((Object[])modulesToUpdate);
    }

    public boolean isApplicationUpdated() {
        return this.applicationUpdated;
    }

    public String getUrl() {
        return this.url;
    }

    public ProgressionModel getProgressionModel() {
        return this.progressionModel;
    }

    public Map<String, ApplicationInfo> updateToDo(Map<String, ApplicationInfo> appToUpdate) {
        HashMap result = Maps.newHashMap();
        for (UpdateModule updateModule : this.modulesToUpdate) {
            ModuleUpdaterSupport moduleUpdaterSupport = this.getModuleUpdater(updateModule);
            ApplicationInfo info = moduleUpdaterSupport.updateToDo(this.context, appToUpdate);
            if (info == null) continue;
            result.put(info.name, info);
        }
        return result;
    }

    public void startUpdate(ApplicationInfo info) {
        for (UpdateModule updateModule : this.modulesToUpdate) {
            ModuleUpdaterSupport moduleUpdaterSupport = this.getModuleUpdater(updateModule);
            if (!moduleUpdaterSupport.matchUpdate(info)) continue;
            String moduleLabel = moduleUpdaterSupport.getLabel();
            String message = I18n.t((String)"tutti.applicationUpdater.startUpdate", (Object[])new Object[]{moduleLabel, info.newVersion});
            if (log.isInfoEnabled()) {
                log.info((Object)message);
            }
            this.progressionModel.setMessage(message);
        }
    }

    public void updateDone(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        boolean doRestart = false;
        for (UpdateModule updateModule : this.modulesToUpdate) {
            ModuleUpdaterSupport moduleUpdaterSupport = this.getModuleUpdater(updateModule);
            try {
                boolean updateDone = moduleUpdaterSupport.updateDone(this.context, appToUpdate, appUpdateError);
                if (!updateDone) continue;
                doRestart = true;
            }
            catch (ApplicationUpdateException e) {
                throw ApplicationActionException.propagateError((AbstractApplicationAction)this.action, (Throwable)((Object)e));
            }
        }
        if (doRestart) {
            this.applicationUpdated = true;
        }
    }

    public void aborted(String propertiesURL, Exception eee) {
        if (log.isErrorEnabled()) {
            log.error((Object)("Could not update from " + propertiesURL), (Throwable)eee);
        }
        throw ApplicationActionException.propagateError((AbstractApplicationAction)this.action, (Throwable)eee);
    }

    protected ModuleUpdaterSupport getModuleUpdater(UpdateModule updateModule) {
        return this.allUpdaters.get(updateModule);
    }
}

