/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersitenceHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForSurvey;
import fr.ifremer.tutti.service.genericformat.csv.SurveyRow;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportSurveyAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportSurveyAction.class);
    private final GenericformatImportPersitenceHelper persitenceHelper;

    public ImportSurveyAction(GenericFormatImportContext importContext, GenericformatImportPersitenceHelper persitenceHelper) {
        super(importContext);
        this.persitenceHelper = persitenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid();
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Import survey.csv file.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.cruises", (Object[])new Object[0]));
        if (this.importContext.isCanImportSurvey()) {
            GenericFormatCsvFileResult importFileResult = this.importContext.getSurveyFileResult();
            try (CsvConsumerForSurvey consumer = this.importContext.loadSurveys(true);){
                for (ImportRow row : consumer) {
                    consumer.validateRow(row, this.importContext);
                    consumer.prepareRowForPersist(row);
                    this.persitenceHelper.persistCruise(((SurveyRow)row.getBean()).getCruise());
                }
            }
            catch (IOException e) {
                throw new ApplicationTechnicalException("Could not close survey.csv file", (Throwable)e);
            }
            catch (ImportRuntimeException e) {
                importFileResult.addGlobalError(e.getMessage());
            }
        }
    }
}

