/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatReferentialImportResult;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryVesselService;
import fr.ifremer.tutti.service.referential.consumer.CsvConsumerForTemporaryVessel;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportReferentialVesselAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportReferentialVesselAction.class);
    private final ReferentialTemporaryVesselService referentialTemporaryVesselService;

    public ImportReferentialVesselAction(GenericFormatImportContext importContext, ReferentialTemporaryVesselService referentialTemporaryVesselService) {
        super(importContext);
        this.referentialTemporaryVesselService = referentialTemporaryVesselService;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.getReferentialTemporaryVesselFileResult().isFound();
    }

    @Override
    protected void doExecute() {
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.temporaryVessels", (Object[])new Object[0]));
        ReferentialImportRequest<Vessel, String> referentialImportRequest = this.referentialTemporaryVesselService.createReferentialImportRequest();
        GenericFormatReferentialImportResult<Vessel, String> importFileResult = this.importContext.getReferentialTemporaryVesselFileResult();
        try (CsvConsumerForTemporaryVessel consumer = this.importContext.loadTemporaryVessels(false);){
            for (ImportRow row : consumer) {
                consumer.checkRowForGenericFormatImport(row, referentialImportRequest);
            }
            importFileResult.flushErrors(consumer);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close vessel.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        if (importFileResult.isValid()) {
            ReferentialImportResult<Vessel> referentialImportResult = this.referentialTemporaryVesselService.executeImportRequest(referentialImportRequest);
            importFileResult.flushResult(referentialImportRequest, referentialImportResult);
            if (log.isInfoEnabled()) {
                log.info((Object)("Temporary vessels import result: " + importFileResult.getReport()));
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Do not import temporary vessels (the incoming file is not valid)");
        }
    }

    @Override
    protected void skipExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Skip import temporary vessels (no file found).");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.import.temporaryVessels", (Object[])new Object[0]));
    }
}

