/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersitenceHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForOperation;
import fr.ifremer.tutti.service.genericformat.csv.OperationRow;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportOperationAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportOperationAction.class);
    private final GenericformatImportPersitenceHelper persitenceHelper;

    public ImportOperationAction(GenericFormatImportContext importContext, GenericformatImportPersitenceHelper persitenceHelper) {
        super(importContext);
        this.persitenceHelper = persitenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid() && this.importContext.getSurveyFileResult().isValid();
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Import operation.csv file.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.operations", (Object[])new Object[0]));
        GenericFormatCsvFileResult importFileResult = this.importContext.getOperationFileResult();
        try (CsvConsumerForOperation consumer = this.importContext.loadOperations(true);){
            for (ImportRow row : consumer) {
                GenericFormatImportCruiseContext cruiseContext = consumer.validateRow(row, this.importContext);
                consumer.prepareRowForPersist(cruiseContext, row);
                OperationRow bean = (OperationRow)row.getBean();
                FishingOperation fishingOperation = bean.getFishingOperation();
                CatchBatch catchBatch = bean.getCatchBatch();
                this.persitenceHelper.persistFishingOperation(cruiseContext, fishingOperation, catchBatch);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close operation.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
    }
}

