/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersitenceHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForGearCaracteristic;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportGearCaracteristicAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportGearCaracteristicAction.class);
    private final GenericformatImportPersitenceHelper persitenceHelper;

    public ImportGearCaracteristicAction(GenericFormatImportContext importContext, GenericformatImportPersitenceHelper persitenceHelper) {
        super(importContext);
        this.persitenceHelper = persitenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid() && this.importContext.getSurveyFileResult().isValid();
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Import gearCaracteristics.csv file.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.gearCaracteristics", (Object[])new Object[0]));
        GenericFormatCsvFileResult importFileResult = this.importContext.getGearCaracteristicFileResult();
        try (CsvConsumerForGearCaracteristic consumer = this.importContext.loadGearCaracteristics(true);){
            for (ImportRow row : consumer) {
                GenericFormatImportCruiseContext cruiseContext = consumer.validateRow(row, this.importContext);
                consumer.prepareRowForPersist(cruiseContext, row);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close gearCaracteristic.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        this.persitenceHelper.persistGearCaracteristics();
    }
}

