/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.test;

import fr.ifremer.adagio.core.service.ServiceLocator;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.junit.Assume;
import org.junit.Ignore;

@Ignore
public final class TestUtil {
    private static final Log log = LogFactory.getLog(TestUtil.class);

    protected TestUtil() {
    }

    public static void checkDbExists(Class<?> testClass, String dbDirectory) {
        File db = new File(dbDirectory);
        if (!db.exists()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not find db at " + db + ", test [" + testClass + "] is skipped."));
            }
            Assume.assumeTrue((boolean)false);
        }
    }

    public static <S> S getBean(String name, Class<S> serviceType) {
        S result = ServiceLocator.instance().getService(name, serviceType);
        Assume.assumeNotNull((Object[])new Object[]{result});
        return result;
    }

    public static Query createStatelessQuery(String hqlQuery) {
        SessionFactory sessionFactory = TestUtil.getBean("sessionFactory", SessionFactory.class);
        StatelessSession session = sessionFactory.openStatelessSession();
        Query query = session.createQuery(hqlQuery);
        return query;
    }

    public static long countEntities(Class<?> entityClass) {
        return TestUtil.countEntities(entityClass, null, "");
    }

    public static long countEntities(Class<?> entityClass, String alias, String whereClause) {
        if (StringUtils.isNotBlank((CharSequence)whereClause)) {
            whereClause = " " + alias + " where " + whereClause;
        }
        Query query = TestUtil.createStatelessQuery("select count(*) from " + entityClass.getName() + whereClause);
        return (Long)query.uniqueResult();
    }
}

