/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.conversion.impl.XWorkConverter;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.TextParser;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextParseUtil {
    private static final int MAX_RECURSION = 1;

    public static String translateVariables(String expression, ValueStack stack) {
        return TextParseUtil.translateVariables(new char[]{'$', '%'}, expression, stack, String.class, null).toString();
    }

    public static String translateVariables(String expression, ValueStack stack, ParsedValueEvaluator evaluator) {
        return TextParseUtil.translateVariables(new char[]{'$', '%'}, expression, stack, String.class, evaluator).toString();
    }

    public static String translateVariables(char open, String expression, ValueStack stack) {
        return TextParseUtil.translateVariables(open, expression, stack, String.class, null).toString();
    }

    public static Object translateVariables(char open, String expression, ValueStack stack, Class asType) {
        return TextParseUtil.translateVariables(open, expression, stack, asType, null);
    }

    public static Object translateVariables(char open, String expression, ValueStack stack, Class asType, ParsedValueEvaluator evaluator) {
        return TextParseUtil.translateVariables(new char[]{open}, expression, stack, asType, evaluator, 1);
    }

    public static Object translateVariables(char[] openChars, String expression, ValueStack stack, Class asType, ParsedValueEvaluator evaluator) {
        return TextParseUtil.translateVariables(openChars, expression, stack, asType, evaluator, 1);
    }

    public static Object translateVariables(char open, String expression, ValueStack stack, Class asType, ParsedValueEvaluator evaluator, int maxLoopCount) {
        return TextParseUtil.translateVariables(new char[]{open}, expression, stack, asType, evaluator, maxLoopCount);
    }

    public static Object translateVariables(char[] openChars, String expression, final ValueStack stack, final Class asType, final ParsedValueEvaluator evaluator, int maxLoopCount) {
        ParsedValueEvaluator ognlEval = new ParsedValueEvaluator(){

            public Object evaluate(String parsedValue) {
                Object o = stack.findValue(parsedValue, asType);
                if (evaluator != null && o != null) {
                    o = evaluator.evaluate(o.toString());
                }
                return o;
            }
        };
        TextParser parser = ((Container)stack.getContext().get("com.opensymphony.xwork2.ActionContext.container")).getInstance(TextParser.class);
        return parser.evaluate(openChars, expression, ognlEval, maxLoopCount);
    }

    public static Collection<String> translateVariablesCollection(String expression, ValueStack stack, boolean excludeEmptyElements, ParsedValueEvaluator evaluator) {
        return TextParseUtil.translateVariablesCollection(new char[]{'$', '%'}, expression, stack, excludeEmptyElements, evaluator, 1);
    }

    public static Collection<String> translateVariablesCollection(char[] openChars, String expression, final ValueStack stack, boolean excludeEmptyElements, ParsedValueEvaluator evaluator, int maxLoopCount) {
        ArrayList<String> resultCol;
        ParsedValueEvaluator ognlEval = new ParsedValueEvaluator(){

            public Object evaluate(String parsedValue) {
                return stack.findValue(parsedValue);
            }
        };
        Map<String, Object> context = stack.getContext();
        TextParser parser = ((Container)context.get("com.opensymphony.xwork2.ActionContext.container")).getInstance(TextParser.class);
        Object result = parser.evaluate(openChars, expression, ognlEval, maxLoopCount);
        XWorkConverter conv = ((Container)context.get("com.opensymphony.xwork2.ActionContext.container")).getInstance(XWorkConverter.class);
        if (result instanceof Collection) {
            Collection casted = (Collection)result;
            resultCol = new ArrayList(casted.size());
            for (Object element : casted) {
                String stringElement = (String)conv.convertValue(context, element, String.class);
                if (!TextParseUtil.shallBeIncluded(stringElement, excludeEmptyElements)) continue;
                if (evaluator != null) {
                    stringElement = evaluator.evaluate(stringElement).toString();
                }
                resultCol.add(stringElement);
            }
        } else {
            resultCol = new ArrayList<String>(1);
            String stringResult = (String)conv.convertValue(context, result, String.class);
            if (TextParseUtil.shallBeIncluded(stringResult, excludeEmptyElements)) {
                if (evaluator != null) {
                    stringResult = evaluator.evaluate(stringResult).toString();
                }
                resultCol.add(stringResult);
            }
        }
        return resultCol;
    }

    private static boolean shallBeIncluded(String str, boolean excludeEmptyElements) {
        return !excludeEmptyElements || str != null && str.length() > 0;
    }

    public static Set<String> commaDelimitedStringToSet(String s) {
        String[] split;
        HashSet<String> set = new HashSet<String>();
        for (String aSplit : split = s.split(",")) {
            String trimmed = aSplit.trim();
            if (trimmed.length() <= 0) continue;
            set.add(trimmed);
        }
        return set;
    }

    public static interface ParsedValueEvaluator {
        public Object evaluate(String var1);
    }
}

