/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForSurvey;
import fr.ifremer.tutti.service.genericformat.csv.SurveyRow;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ValidateSurveyAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ValidateSurveyAction.class);

    public ValidateSurveyAction(GenericFormatContextSupport importContext) {
        super(importContext);
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid();
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Validate survey.csv file.");
        }
        GenericFormatCsvFileResult importFileResult = this.importContext.getSurveyFileResult();
        try (CsvConsumerForSurvey consumer = this.importContext.loadSurveys(false);){
            for (ImportRow row : consumer) {
                this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.validate.cruises", (Object[])new Object[]{row.getLineNumber()}));
                consumer.validateRow(row, this.importContext);
                consumer.prepareRowForPersist(row);
                Cruise cruise = ((SurveyRow)row.getBean()).getCruise();
                boolean createCruise = TuttiEntities.isNew((TuttiEntity)cruise);
                this.importContext.addImportedCruise(cruise, !createCruise);
            }
            importFileResult.flushErrors(consumer);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close survey.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
    }
}

