/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForIndividualObservation;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ValidateIndividualObservationAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ValidateIndividualObservationAction.class);

    public ValidateIndividualObservationAction(GenericFormatImportContext importContext) {
        super(importContext);
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid() && this.importContext.getOperationFileResult().isValid();
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Validate individualObservation.csv file.");
        }
        GenericFormatCsvFileResult importFileResult = this.importContext.getIndividualObservationFileResult();
        try (CsvConsumerForIndividualObservation consumer = this.importContext.loadIndividualObservations(false);){
            for (ImportRow row : consumer) {
                this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.validate.individualObservations", (Object[])new Object[]{row.getLineNumber()}));
                GenericFormatImportOperationContext operationContext = consumer.validateRow(row, this.importContext);
                if (!row.isValid()) continue;
                consumer.prepareRowForPersist(operationContext, row);
            }
            importFileResult.flushErrors(consumer);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close individualObservation.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
    }
}

