/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.service.genericformat.GenericFormatArchiveInvalidLayoutException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class GenericFormatArchive
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GenericFormatArchive.class);
    private final File archiveFile;
    private final File workingDirectory;
    private final ArchiveMode archiveMode;
    private final String prefixPath;
    private final EnumMap<ArchiveFilePath, Integer> countLines;
    private final EnumSet<ArchiveFilePath> missingPaths;

    public static GenericFormatArchive forImport(File archiveFile, File tempDirectory) {
        try {
            File workingDirectory = Files.createTempDirectory(tempDirectory.toPath(), "genericImport", new FileAttribute[0]).toFile();
            GenericFormatArchive archive = new GenericFormatArchive(ArchiveMode.IMPORT, archiveFile, workingDirectory);
            return archive;
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not create generic format import archive", (Throwable)e);
        }
    }

    public static GenericFormatArchive forExport(File archiveFile, File tempDirectory) {
        try {
            File workingDirectory = Files.createTempDirectory(tempDirectory.toPath(), "genericExport", new FileAttribute[0]).toFile();
            GenericFormatArchive archive = new GenericFormatArchive(ArchiveMode.EXPORT, archiveFile, workingDirectory);
            return archive;
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not create generic format export archive", (Throwable)e);
        }
    }

    public static GenericFormatArchive forExportFromWorkingDirectory(File archiveFile, File workingDirectory) {
        GenericFormatArchive archive = new GenericFormatArchive(ArchiveMode.EXPORT, archiveFile, workingDirectory);
        return archive;
    }

    public File getWorkingDirectoryPath() {
        return this.workingDirectory;
    }

    public Path getSampleCategoryModelPath() {
        return this.getPath(ArchiveFilePath.SAMPLE_CATEGORY);
    }

    public boolean isProtocolExists() {
        return Files.exists(this.getProtocolPath(), new LinkOption[0]);
    }

    public boolean isTemporaryReferentialGearsPathExists() {
        return Files.exists(this.getTemporaryReferentialGearsPath(), new LinkOption[0]);
    }

    public boolean isTemporaryReferentialPersonsPathExists() {
        return Files.exists(this.getTemporaryReferentialPersonsPath(), new LinkOption[0]);
    }

    public boolean isTemporaryReferentialSpeciesPathExists() {
        return Files.exists(this.getTemporaryReferentialSpeciesPath(), new LinkOption[0]);
    }

    public boolean isTemporaryReferentialVesselsPathExists() {
        return Files.exists(this.getTemporaryReferentialVesselsPath(), new LinkOption[0]);
    }

    public Path getProtocolPath() {
        return this.getPath(ArchiveFilePath.PROTOCOL);
    }

    public Path getTemporaryReferentialGearsPath() {
        return this.getPath(ArchiveFilePath.REFERENTIAL_GEAR);
    }

    public Path getTemporaryReferentialPersonsPath() {
        return this.getPath(ArchiveFilePath.REFERENTIAL_PERSON);
    }

    public Path getTemporaryReferentialSpeciesPath() {
        return this.getPath(ArchiveFilePath.REFERENTIAL_SPECIES);
    }

    public Path getTemporaryReferentialVesselsPath() {
        return this.getPath(ArchiveFilePath.REFERENTIAL_VESSEL);
    }

    public Path getSurveyPath() {
        return this.getPath(ArchiveFilePath.DATA_SURVEY);
    }

    public Path getGearCaracteristicsPath() {
        return this.getPath(ArchiveFilePath.DATA_GEAR_CARACTERISTIC);
    }

    public Path getOperationPath() {
        return this.getPath(ArchiveFilePath.DATA_OPERATION);
    }

    public Path getIndividualObservationPath() {
        return this.getPath(ArchiveFilePath.DATA_INDIVIDUAL_OBSERVATION);
    }

    public Path getSpeciesPath() {
        return this.getPath(ArchiveFilePath.DATA_SPECIES);
    }

    public Path getCatchPath() {
        return this.getPath(ArchiveFilePath.DATA_CATCH);
    }

    public Path getAccidentalCatchPath() {
        return this.getPath(ArchiveFilePath.DATA_ACCIDENTAL_CATCH);
    }

    public Path getParameterPath() {
        return this.getPath(ArchiveFilePath.DATA_PARAMETER);
    }

    public Path getMarineLitterPath() {
        return this.getPath(ArchiveFilePath.DATA_MARINE_LITTER);
    }

    public int getSampleCategoryLineCount() {
        return this.countImportLines(ArchiveFilePath.SAMPLE_CATEGORY);
    }

    public int getSurveyLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_SURVEY);
    }

    public int getGearCaracteristicsPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_GEAR_CARACTERISTIC);
    }

    public int getOperationPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_OPERATION);
    }

    public int getIndividualObservationPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_INDIVIDUAL_OBSERVATION);
    }

    public int getSpeciesPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_SPECIES);
    }

    public int getCatchPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_CATCH);
    }

    public int getAccidentalCatchPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_ACCIDENTAL_CATCH);
    }

    public int getParameterPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_PARAMETER);
    }

    public int getMarineLitterPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_MARINE_LITTER);
    }

    public int getTemporaryReferentialGearLineCount() {
        return this.countImportLines(ArchiveFilePath.REFERENTIAL_GEAR);
    }

    public int getTemporaryReferentialPersonLineCount() {
        return this.countImportLines(ArchiveFilePath.REFERENTIAL_PERSON);
    }

    public int getTemporaryReferentialSpeciesLineCount() {
        return this.countImportLines(ArchiveFilePath.REFERENTIAL_SPECIES);
    }

    public int getTemporaryReferentialVesselLineCount() {
        return this.countImportLines(ArchiveFilePath.REFERENTIAL_VESSEL);
    }

    public void validateArchiveLayout() throws GenericFormatArchiveInvalidLayoutException {
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        for (ArchiveFilePath archiveFilePath : ArchiveFilePath.values()) {
            if (!archiveFilePath.isMandatory() || !this.missingPaths.contains((Object)archiveFilePath)) continue;
            if (log.isErrorEnabled()) {
                log.error((Object)("Mandatory entry " + archiveFilePath.getFilename() + " not found."));
            }
            errors.add(I18n.t((String)"tutti.service.genericFormat.importError.missArchiveFile", (Object[])new Object[]{archiveFilePath.getFilename()}));
        }
        if (!errors.isEmpty()) {
            throw new GenericFormatArchiveInvalidLayoutException(this, errors);
        }
    }

    public void createZip(ProgressionModel progressionModel) {
        if (progressionModel != null) {
            progressionModel.increments(I18n.t((String)"tutti.service.genericFormat.export.buildZip", (Object[])new Object[]{this.archiveFile}));
        }
        ApplicationIOUtil.zip((File)this.workingDirectory, (File)this.archiveFile, (String)I18n.t((String)"tutti.service.genericFormat.export.zip.error", (Object[])new Object[]{this.archiveFile}));
    }

    protected GenericFormatArchive(ArchiveMode archiveMode, File archiveFile, File workingDirectory) {
        this.archiveFile = archiveFile;
        this.workingDirectory = workingDirectory;
        this.archiveMode = archiveMode;
        this.countLines = new EnumMap(ArchiveFilePath.class);
        if (log.isInfoEnabled()) {
            log.info((Object)("Archive zip file: " + archiveFile));
            log.info((Object)("Archive working directory: " + workingDirectory));
            log.info((Object)("Archive mode: " + (Object)((Object)archiveMode)));
        }
        if (this.isImport()) {
            this.prefixPath = this.extractPrefixPath();
            if (log.isInfoEnabled()) {
                log.info((Object)("Zip entries prefix path: " + this.prefixPath));
            }
            this.missingPaths = this.computeMissingPaths();
        } else {
            this.prefixPath = null;
            this.missingPaths = null;
        }
    }

    protected boolean isImport() {
        return ArchiveMode.IMPORT == this.archiveMode;
    }

    protected boolean isExport() {
        return ArchiveMode.EXPORT == this.archiveMode;
    }

    protected String extractPrefixPath() {
        FileObject fileObject = ApplicationIOUtil.resolveFile((String)("zip:" + this.archiveFile.getAbsolutePath()), (String)I18n.t((String)"tutti.service.persistence.getArchive.error", (Object[])new Object[]{this.archiveFile}));
        FileObject[] children = ApplicationIOUtil.getChildren((FileObject)fileObject, (String)I18n.t((String)"tutti.service.persistence.openArchive.error", (Object[])new Object[]{fileObject}));
        fileObject = children[0];
        String prefix = fileObject.getName().getBaseName() + "/";
        return prefix;
    }

    protected Path getPath(ArchiveFilePath archiveFilePath) {
        Path file;
        block28: {
            String filename = archiveFilePath.getFilename();
            file = this.workingDirectory.toPath().resolve(filename);
            if (this.isImport() && Files.notExists(file, new LinkOption[0]) && !this.missingPaths.contains((Object)archiveFilePath)) {
                try (ZipFile zipFile = new ZipFile(this.archiveFile);){
                    String zipEntryPath = this.getZipEntryPath(archiveFilePath);
                    ZipEntry entry = zipFile.getEntry(zipEntryPath);
                    Preconditions.checkState((!archiveFilePath.isMandatory() || entry != null ? 1 : 0) != 0, (Object)("Must have entry " + filename));
                    if (entry == null) break block28;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Explode zip entry to " + file.toFile().getName()));
                    }
                    try (InputStream inputStream = zipFile.getInputStream(entry);){
                        Files.copy(inputStream, file, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new ApplicationTechnicalException("Could not open zip file: " + this.archiveFile, (Throwable)e);
                }
            }
        }
        return file;
    }

    protected String getZipEntryPath(ArchiveFilePath archiveFilePath) {
        String path = this.prefixPath + archiveFilePath.getFilename();
        return path;
    }

    protected EnumSet<ArchiveFilePath> computeMissingPaths() {
        EnumSet<ArchiveFilePath> result = EnumSet.noneOf(ArchiveFilePath.class);
        try (ZipFile zipFile = new ZipFile(this.archiveFile);){
            for (ArchiveFilePath archiveFilePath : ArchiveFilePath.values()) {
                ZipEntry zipEntry;
                String zipEntryPath = this.getZipEntryPath(archiveFilePath);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Check if entry " + zipEntryPath + " exists."));
                }
                if ((zipEntry = zipFile.getEntry(zipEntryPath)) == null) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Entry " + zipEntryPath + " not found."));
                    }
                    result.add(archiveFilePath);
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Entry " + zipEntryPath + " found."));
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not open or close zip file: " + this.archiveFile, (Throwable)e);
        }
        return result;
    }

    protected int countImportLines(ArchiveFilePath archiveFilePath) {
        Integer result = this.countLines.get((Object)archiveFilePath);
        if (result == null) {
            Path path = this.getPath(archiveFilePath);
            try (BufferedReader bufferedReader = Files.newBufferedReader(path, Charset.forName("UTF-8"));
                 LineNumberReader lineNumberReader = new LineNumberReader(bufferedReader);){
                lineNumberReader.skip(Long.MAX_VALUE);
                result = lineNumberReader.getLineNumber() - 1;
                if (result == -1) {
                    result = 0;
                }
                this.countLines.put(archiveFilePath, result);
            }
            catch (IOException e) {
                throw new ApplicationTechnicalException("Could not read " + path.toFile().getName() + " file from archive " + this.archiveFile, (Throwable)e);
            }
        }
        return result;
    }

    private static enum ArchiveFilePath {
        PROTOCOL(false, "protocol.tuttiProtocol"),
        REFERENTIAL_GEAR(false, "temporaryGears.csv"),
        REFERENTIAL_PERSON(false, "temporaryPersons.csv"),
        REFERENTIAL_SPECIES(false, "temporarySpecies.csv"),
        REFERENTIAL_VESSEL(false, "temporaryVessels.csv"),
        SAMPLE_CATEGORY(true, "sampleCategory.csv"),
        DATA_SURVEY(true, "survey.csv"),
        DATA_GEAR_CARACTERISTIC(true, "gearCaracteristics.csv"),
        DATA_OPERATION(true, "operation.csv"),
        DATA_PARAMETER(true, "parameter.csv"),
        DATA_CATCH(true, "catch.csv"),
        DATA_SPECIES(false, "species.csv"),
        DATA_MARINE_LITTER(true, "marineLitter.csv"),
        DATA_ACCIDENTAL_CATCH(true, "accidentalCatch.csv"),
        DATA_INDIVIDUAL_OBSERVATION(true, "individualObservation.csv");

        private final boolean mandatory;
        private final String filename;

        private ArchiveFilePath(boolean mandatory, String filename) {
            this.mandatory = mandatory;
            this.filename = filename;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public String getFilename() {
            return this.filename;
        }
    }

    private static enum ArchiveMode {
        IMPORT,
        EXPORT;

    }
}

