/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import org.eclipse.birt.report.model.adapter.oda.impl.AdapterUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.ResultSetsAdapter;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;

class ResultSetColumnUpdater {
    ColumnDefinition columnDefn = null;
    OdaResultSetColumn newColumn;
    String dataSourceId = null;
    String dataSetId = null;
    OdaDataSetHandle setHandle;

    ResultSetColumnUpdater(OdaResultSetColumn newColumn, ColumnDefinition columnDefn, OdaDataSetHandle setHandle, String dataSourceId, String dataSetId) {
        if (newColumn == null || columnDefn == null || setHandle == null) {
            throw new IllegalArgumentException("The column definition and oda result set column can not be null!");
        }
        this.columnDefn = columnDefn;
        this.newColumn = newColumn;
        this.dataSourceId = dataSourceId;
        this.dataSetId = dataSetId;
        this.setHandle = setHandle;
    }

    ColumnHint process() {
        DataElementAttributes dataAttrs = this.columnDefn.getAttributes();
        this.processDataElementAttributes(dataAttrs);
        ColumnHint oldHint = null;
        ColumnHintHandle oldHintHandle = AdapterUtil.findColumnHint(this.newColumn, this.setHandle.columnHintsIterator());
        if (oldHintHandle != null) {
            oldHint = (ColumnHint)oldHintHandle.getStructure();
        }
        ColumnHint newHint = ResultSetsAdapter.newROMColumnHintFromColumnDefinition(this.columnDefn, null, oldHint, this.newColumn);
        return newHint;
    }

    private void processDataElementAttributes(DataElementAttributes dataAttrs) {
        if (dataAttrs == null) {
            return;
        }
        String newValue = dataAttrs.getName();
        this.newColumn.setNativeName(newValue);
        int position = dataAttrs.getPosition();
        this.newColumn.setPosition(position);
        int newNativeDataType = dataAttrs.getNativeDataTypeCode();
        this.newColumn.setNativeDataType(newNativeDataType);
        this.newColumn.setDataType(AdapterUtil.convertNativeTypeToROMDataType(this.dataSourceId, this.dataSetId, newNativeDataType, null));
    }
}

