/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.ReferentialTemporarySpeciesService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIModel;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportTemporarySpeciesAction
extends AbstractTuttiAction<ManageTemporaryReferentialUIModel, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final Log log = LogFactory.getLog(ImportTemporarySpeciesAction.class);
    private File file;
    private ReferentialImportResult<Species> result;

    public ImportTemporarySpeciesAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.chooseFile(I18n.t((String)"tutti.manageTemporaryReferential.title.choose.importTemporarySpeciesFile", (Object[])new Object[0]), I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialSpeciesFile.import", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import species temporary referential from file: " + this.file));
        }
        ReferentialTemporarySpeciesService service = this.getContext().getReferentialTemporarySpeciesService();
        this.result = service.importTemporarySpecies(this.file);
        int nbRef = ((ManageTemporaryReferentialUIModel)this.getModel()).getNbTemporarySpecies();
        ((ManageTemporaryReferentialUIModel)this.getModel()).setNbTemporarySpecies(nbRef + this.result.getNbRefAdded() - this.result.getNbRefDeleted());
        this.getDataContext().resetSpecies();
        ((ManageTemporaryReferentialUIHandler)this.getHandler()).resetExportSpeciesAction();
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        String title = I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialSpeciesFile.import.dialog.title", (Object[])new Object[0]);
        String message = I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialSpeciesFile.import.dialog.message", (Object[])new Object[]{this.result.getNbRefAdded(), this.result.getNbRefUpdated(), this.result.getNbRefDeleted()});
        this.displayInfoMessage(title, message);
        this.sendMessage(I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialSpeciesFile.import.success", (Object[])new Object[]{this.file}));
    }
}

