/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.dao;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.synchro.SynchroBusinessException;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.dao.DaoFactory;
import fr.ifremer.adagio.synchro.dao.Daos;
import fr.ifremer.adagio.synchro.dao.DataIntegrityViolationOnDeleteException;
import fr.ifremer.adagio.synchro.dao.SynchroBaseDao;
import fr.ifremer.adagio.synchro.dao.SynchroBaseDaoImpl;
import fr.ifremer.adagio.synchro.dao.SynchroTableDao;
import fr.ifremer.adagio.synchro.dao.SynchroTableDaoUtils;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptorUtils;
import fr.ifremer.adagio.synchro.intercept.SynchroOperationRepository;
import fr.ifremer.adagio.synchro.meta.SynchroColumnMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroJoinMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.query.SynchroQueryBuilder;
import fr.ifremer.adagio.synchro.query.SynchroQueryOperator;
import fr.ifremer.adagio.synchro.query.internal.SynchroInsertQuery;
import fr.ifremer.adagio.synchro.query.internal.SynchroSelectQuery;
import fr.ifremer.adagio.synchro.service.SynchroDatabaseConfiguration;
import fr.ifremer.adagio.synchro.service.SynchroTableOperation;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.sql.TIMESTAMP;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.nuiton.i18n.I18n;

public class SynchroTableDaoImpl
implements SynchroTableDao {
    private static final Log log = LogFactory.getLog(SynchroTableDaoImpl.class);
    protected static final String TEMP_QUERY_PARAMETER_PARAM_NAME = "SYNC#dao";
    protected Connection connection;
    protected SynchroTableMetadata table;
    protected Dialect dialect;
    protected final PreparedStatement insertStatement;
    protected final PreparedStatement updateStatement;
    protected final PreparedStatement deleteStatement;
    protected final List<PreparedStatement> selectStatements;
    protected final Map<String, PreparedStatement> updateColumnStatements;
    protected final PreparedStatement lockStatement;
    protected final Map<PreparedStatement, int[]> selectPkByIndexStatements;
    protected final int[] incominDataIndexedNeedForIndex;
    protected final int incomingDataColumnCount;
    protected final int batchSize;
    protected final int fetchSize;
    protected final String tableName;
    protected final boolean debug;
    protected boolean isJdbcBatchEnable;
    protected int insertCount = 0;
    protected int updateCount = 0;
    protected Map<String, Integer> updateColumnCounts = Maps.newHashMap();
    protected int deleteCount = 0;
    protected SynchroInterceptor readInterceptor;
    protected SynchroInterceptor writeInterceptor;
    protected SynchroTableOperation pendingOperationBuffer;
    protected final String sequenceNextValString;
    protected final boolean isMirrorDatabase;
    protected final boolean keepWhereClauseOnQueriesByFks;
    protected final boolean hasSequence;
    protected final boolean enableInsertWithPkBind;
    protected final int[] insertPkIndexes;
    protected int[] selectPkIndexs;
    protected final boolean enableWrite;
    protected List<Object> lastGeneratedPk;
    protected SynchroTableDao sourceDao;
    protected final String countAllApproxQuery;
    protected final SynchroBaseDao delegate;

    public SynchroTableDaoImpl(SynchroDatabaseMetadata dbMeta, SynchroTableMetadata table) throws SQLException {
        this(dbMeta.getConnection(), dbMeta.getConfiguration(), table, new SynchroBaseDaoImpl(dbMeta));
    }

    public SynchroTableDaoImpl(Connection connection, SynchroDatabaseConfiguration configuration, SynchroTableMetadata table, SynchroBaseDao delegate) throws SQLException {
        this.dialect = configuration.getDialect();
        this.connection = connection;
        this.table = table;
        this.delegate = delegate;
        this.selectStatements = Lists.newArrayList();
        this.updateColumnStatements = Maps.newHashMap();
        this.tableName = table.getName();
        this.enableWrite = !configuration.isReadOnly() && configuration.isTarget();
        this.isMirrorDatabase = configuration.isMirrorDatabase();
        this.keepWhereClauseOnQueriesByFks = configuration.isKeepWhereClauseOnQueriesByFks();
        this.selectPkIndexs = table.getSelectPkIndexs();
        this.countAllApproxQuery = this.initCountAllApproxQuery(this.dialect, configuration, table);
        this.batchSize = SynchroConfiguration.getInstance().getImportJdbcBatchSize();
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0);
        this.fetchSize = SynchroConfiguration.getInstance().getImportJdbcFetchSize();
        Preconditions.checkArgument((this.fetchSize > 0 ? 1 : 0) != 0);
        this.isJdbcBatchEnable = this.batchSize > 1;
        this.debug = log.isDebugEnabled();
        this.readInterceptor = this.createReadInterceptor(table);
        if (this.enableWrite) {
            this.sequenceNextValString = this.createSequenceNextValString(this.dialect, table);
            this.hasSequence = StringUtils.isNotBlank((CharSequence)this.sequenceNextValString);
            this.incomingDataColumnCount = this.createIncomingDataColumnCount(table);
            this.writeInterceptor = this.createWriteInterceptor(table);
            boolean bl = this.enableInsertWithPkBind = !this.isMirrorDatabase && this.hasSequence && (this.writeInterceptor != null || !this.isJdbcBatchEnable);
            if (this.enableInsertWithPkBind) {
                String insertWithPkBindQuery = this.createInsertWithPkBindQuery(table);
                this.insertStatement = connection.prepareStatement(insertWithPkBindQuery);
                this.insertPkIndexes = this.initInsertPkIndexes(insertWithPkBindQuery);
            } else {
                this.insertStatement = this.createInsertStatement(connection, this.dialect, table);
                this.insertPkIndexes = null;
            }
            this.selectPkByIndexStatements = this.createSelectPkByIndexStatement(connection, table);
            this.incominDataIndexedNeedForIndex = this.createIncomingDataIndexedNeedForIndex(this.selectPkByIndexStatements, this.incomingDataColumnCount);
            this.updateStatement = this.createUpdateStatement(connection, table);
            this.lockStatement = this.createLockStatement(connection, table);
            this.deleteStatement = this.createDeleteStatement(connection, table);
            this.isJdbcBatchEnable = this.batchSize > 1 && !table.hasUniqueConstraints();
        } else {
            this.insertStatement = null;
            this.updateStatement = null;
            this.lockStatement = null;
            this.writeInterceptor = null;
            this.sequenceNextValString = null;
            this.hasSequence = false;
            this.incomingDataColumnCount = -1;
            this.selectPkByIndexStatements = null;
            this.incominDataIndexedNeedForIndex = null;
            this.enableInsertWithPkBind = false;
            this.insertPkIndexes = null;
            this.deleteStatement = null;
            this.isJdbcBatchEnable = this.batchSize > 1;
        }
        this.lastGeneratedPk = null;
    }

    @Override
    public void cleanTempQueryParameter() throws SQLException {
        this.delegate.cleanTempQueryParameter();
    }

    @Override
    public void executeDeleteTempQueryParameter(String queryParameterName, boolean likeOperatorForParameterName, int queryPersonId) throws SQLException {
        this.delegate.executeDeleteTempQueryParameter(queryParameterName, likeOperatorForParameterName, queryPersonId);
    }

    @Override
    public void executeInsertIntoTempQueryParameter(List<Object> parameterValues, String queryParameterName, int queryPersonId) throws SQLException {
        this.delegate.executeInsertIntoTempQueryParameter(parameterValues, queryParameterName, queryPersonId);
    }

    @Override
    public Connection getConnection() {
        return this.delegate.getConnection();
    }

    @Override
    public String getInsertIntoTempQueryParameterQuery() {
        return this.delegate.getInsertIntoTempQueryParameterQuery();
    }

    @Override
    public <T> T getUniqueTyped(String sql, Object[] bindingValues) throws SQLException {
        return this.delegate.getUniqueTyped(sql, bindingValues);
    }

    @Override
    public DaoFactory getDaoFactory() {
        return this.delegate.getDaoFactory();
    }

    @Override
    public void setSourceDao(SynchroTableDao sourceDao) {
        this.sourceDao = sourceDao;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public SynchroTableMetadata getTable() {
        return this.table;
    }

    @Override
    public void setCurrentOperation(SynchroTableOperation pendingChangesBuffer) {
        this.pendingOperationBuffer = pendingChangesBuffer;
    }

    @Override
    public SynchroTableOperation getCurrentOperation() {
        return this.pendingOperationBuffer;
    }

    @Override
    public int getInsertCount() {
        return this.insertCount;
    }

    @Override
    public int getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public int getUpdateColumnCount(String columnName) {
        return MapUtils.getIntValue(this.updateColumnCounts, (Object)columnName);
    }

    public int getTotalUpdateColumnCount() {
        int result = 0;
        for (String columnName : this.updateColumnStatements.keySet()) {
            result += MapUtils.getIntValue(this.updateColumnCounts, (Object)columnName);
        }
        return result;
    }

    @Override
    public int getDeleteCount() {
        return this.deleteCount;
    }

    @Override
    public void flush() throws SQLException {
        if (!this.isJdbcBatchEnable) {
            return;
        }
        this.checkWriteEnable();
        if (this.insertCount > 0 && this.insertCount % this.batchSize != 0) {
            this.insertStatement.executeBatch();
            this.insertStatement.clearBatch();
        }
        if (this.updateCount > 0 && this.updateCount % this.batchSize != 0) {
            this.updateStatement.executeBatch();
            this.updateStatement.clearBatch();
        }
        if (this.deleteCount > 0 && this.deleteCount % this.batchSize != 0) {
            this.deleteStatement.executeBatch();
            this.deleteStatement.clearBatch();
        }
        for (String columnName : this.updateColumnStatements.keySet()) {
            int updateColumnCount = this.getUpdateColumnCount(columnName);
            PreparedStatement updateColumnStatement = this.updateColumnStatements.get(columnName);
            if (updateColumnCount <= 0 || updateColumnCount % this.batchSize == 0) continue;
            updateColumnStatement.executeBatch();
            updateColumnStatement.clearBatch();
        }
    }

    @Override
    public void close() throws IOException {
        Daos.closeSilently(this.insertStatement);
        Daos.closeSilently(this.updateStatement);
        Daos.closeSilently(this.deleteStatement);
        Daos.closeSilently(this.lockStatement);
        this.closeSelectStatements();
        this.closeUpdateColumnStatements();
        this.closeSelectPkByIndexStatements();
        IOUtils.closeQuietly((Closeable)this.writeInterceptor);
        this.writeInterceptor = null;
        IOUtils.closeQuietly((Closeable)this.readInterceptor);
        this.readInterceptor = null;
        this.pendingOperationBuffer = null;
        this.connection = null;
        this.dialect = null;
        this.table = null;
    }

    @Override
    public Timestamp getLastUpdateDate() throws SQLException {
        return SynchroTableDaoUtils.getLastUpdateDate(this.table, this.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countAll(boolean approximate) throws SQLException {
        String sql = approximate && this.countAllApproxQuery != null ? this.countAllApproxQuery : this.table.getCountAllQuery();
        PreparedStatement statement = this.getConnection().prepareStatement(sql);
        ResultSet resultSet = null;
        long result = 0L;
        boolean errorOnCount = false;
        try {
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                errorOnCount = true;
            } else {
                result = resultSet.getLong(1);
            }
        }
        finally {
            Daos.closeSilently(resultSet);
            Daos.closeSilently(statement);
        }
        if (approximate && this.countAllApproxQuery != null && (result == 0L || errorOnCount)) {
            return this.countAll(false);
        }
        if (errorOnCount) {
            throw new SynchroTechnicalException(String.format("[%s] Count query returned no row : %s", this.tableName, sql));
        }
        return result;
    }

    @Override
    public long countDataToUpdate(Date fromDate) throws SQLException {
        HashMap bindings = Maps.newHashMap();
        if (fromDate != null) {
            bindings.put("updateDate", fromDate);
        }
        return this.countData(bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countData(Map<String, Object> bindings) throws SQLException {
        long l;
        Map<String, Object> validBindings = this.prepareBindings(bindings);
        String sql = this.table.getCountQuery();
        if (validBindings.containsKey("updateDate")) {
            sql = this.table.getCountUpdatedDataQuery();
        }
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            long result;
            statement = this.prepareAndBindStatement(sql, bindings, "count");
            resultSet = statement.executeQuery();
            resultSet.next();
            l = result = resultSet.getLong(1);
        }
        catch (Throwable throwable) {
            Daos.closeSilently(resultSet);
            Daos.closeSilently(statement);
            throw throwable;
        }
        Daos.closeSilently(resultSet);
        Daos.closeSilently(statement);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countDataByFks(Set<String> fkColumnNames, List<List<Object>> fkColumnsValues, Map<String, Object> bindings) throws SQLException {
        long l;
        Integer userId;
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(fkColumnNames));
        String queryParameterName = "values";
        Map<String, Object> validBindings = this.prepareBindings(bindings);
        String baseSql = this.table.getCountQuery();
        if (validBindings.containsKey("updateDate")) {
            baseSql = this.table.getCountUpdatedDataQuery();
        }
        String sql = this.createSelectByManyFksUsingTempParameterTable(baseSql, fkColumnNames, queryParameterName);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] Prepare select query: %s", this.table.getName(), sql));
        }
        if ((userId = (Integer)bindings.get("userId")) == null) {
            userId = new Integer(-1);
        }
        this.executeInsertIntoTempQueryParameter(fkColumnNames, fkColumnsValues, queryParameterName, userId, false);
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareAndBindStatement(sql, bindings, "countByFks");
            this.registerSelectStatementAndClosePrevious(statement);
            resultSet = statement.executeQuery();
            resultSet.next();
            l = resultSet.getLong(1);
        }
        catch (Throwable throwable) {
            Daos.closeSilently(resultSet);
            Daos.closeSilently(statement);
            throw throwable;
        }
        Daos.closeSilently(resultSet);
        Daos.closeSilently(statement);
        return l;
    }

    @Override
    public ResultSet getDataToUpdate(Date fromDate) throws SQLException {
        HashMap bindings = Maps.newHashMap();
        if (fromDate != null) {
            bindings.put("updateDate", fromDate);
        }
        return this.getData(bindings);
    }

    @Override
    public ResultSet getData(Map<String, Object> bindings) throws SQLException {
        Map<String, Object> validBindings = this.prepareBindings(bindings);
        String sql = this.table.getSelectAllQuery();
        if (this.table.isWithUpdateDateColumn() && MapUtils.getObject(validBindings, (Object)"updateDate") != null) {
            sql = this.table.getSelectUpdatedDataQuery();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] Prepare select query: %s", this.table.getName(), sql));
        }
        PreparedStatement statement = this.prepareAndBindSelectStatement(sql, bindings, "select");
        this.registerSelectStatementAndClosePrevious(statement);
        statement.setFetchSize(this.batchSize);
        ResultSet result = statement.executeQuery();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getUpdateDateByPk(List<Object> pk) throws SQLException {
        Timestamp result;
        ResultSet resultSet;
        PreparedStatement statement;
        block7: {
            Iterator<Object> i$;
            if (!this.table.isWithUpdateDateColumn()) {
                return null;
            }
            String sql = this.table.getSelectUpdateDateByPkQuery();
            if (sql == null) {
                return null;
            }
            if (this.debug) {
                log.debug((Object)String.format("[%s] Execute getUpdateDateByPk query: %s", this.table.getName(), sql));
            }
            statement = this.getConnection().prepareStatement(sql);
            resultSet = null;
            try {
                int pkIndex = 1;
                for (Object value : pk) {
                    statement.setObject(pkIndex, value);
                    ++pkIndex;
                }
                resultSet = statement.executeQuery();
                if (resultSet.next()) break block7;
                i$ = null;
            }
            catch (Throwable throwable) {
                Daos.closeSilently(resultSet);
                Daos.closeSilently(statement);
                throw throwable;
            }
            Daos.closeSilently(resultSet);
            Daos.closeSilently(statement);
            return i$;
        }
        Timestamp timestamp = result = resultSet.getTimestamp(1);
        Daos.closeSilently(resultSet);
        Daos.closeSilently(statement);
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll() throws SQLException {
        PreparedStatement deleteStatement = this.getConnection().prepareStatement("DELETE FROM " + this.table.getName());
        try {
            deleteStatement.execute();
        }
        finally {
            Daos.closeSilently(deleteStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeDeleteByFk(String fkColumnName, String fkColumnValue, String additionalWhereClause, Map<String, Object> bindings) throws SQLException {
        String sql = String.format("DELETE FROM %s WHERE %s=?%s", this.table.getName(), fkColumnName, StringUtils.isNotBlank((CharSequence)additionalWhereClause) ? " AND " + additionalWhereClause : "");
        PreparedStatement deleteStatement = this.prepareAndBindStatement(sql, bindings, "delete");
        deleteStatement.setObject(1, fkColumnValue);
        try {
            int rowCount = deleteStatement.executeUpdate();
            this.deleteCount += rowCount;
            boolean bl = this.deleteCount > 0;
            return bl;
        }
        finally {
            Daos.closeSilently(deleteStatement);
        }
    }

    @Override
    public void executeDelete(List<Object> pk, boolean checkPkNotUsed) throws SQLException {
        if (checkPkNotUsed) {
            this.checkPkNotUsedBeforeDelete(pk);
        }
        if (this.writeInterceptor != null) {
            this.writeInterceptor.onDelete(pk, this.sourceDao, this, this.pendingOperationBuffer);
        }
        int i = 1;
        for (Object value : pk) {
            this.deleteStatement.setObject(i++, value);
        }
        ++this.deleteCount;
        if (!this.isJdbcBatchEnable) {
            this.checkWriteEnable();
            if (this.debug) {
                log.debug((Object)String.format("[%s] Execute delete query (pk:%s)", this.tableName, SynchroTableMetadata.toPkStr(pk)));
            }
            int nbRowDeleted = this.deleteStatement.executeUpdate();
            if (this.debug) {
                if (nbRowDeleted == 0) {
                    log.debug((Object)String.format("[%s] Row not deleted (pk:%s) - maybe already deleted ?", this.tableName, SynchroTableMetadata.toPkStr(pk)));
                } else if (nbRowDeleted > 1) {
                    throw new SynchroTechnicalException(String.format("[%s] Could not delete a row (pk:%s): more than one row affected.", this.tableName, SynchroTableMetadata.toPkStr(pk)));
                }
            }
        } else {
            this.deleteStatement.addBatch();
            if (this.deleteCount > 0 && this.deleteCount % this.batchSize == 0) {
                this.checkWriteEnable();
                this.deleteStatement.executeBatch();
                this.deleteStatement.clearBatch();
            }
        }
    }

    @Override
    public void executeDetach(List<Object> pk) throws SQLException {
        if (this.writeInterceptor != null) {
            this.writeInterceptor.onDetach(pk, this.sourceDao, this, this.pendingOperationBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] findByPk(List<Object> pk) throws SQLException {
        String sql = this.table.getSelectDataQueryFromPk();
        PreparedStatement selectStatement = this.getPreparedStatement(sql);
        int columnCountIndex = 1;
        for (Object pkColumn : pk) {
            selectStatement.setObject(columnCountIndex++, pkColumn);
        }
        int columnsCount = this.table.getSelectColumnsCount();
        ResultSet resultSet = null;
        try {
            resultSet = selectStatement.executeQuery();
            resultSet.next();
            Object[] result = new Object[columnsCount];
            for (int i = 1; i <= columnsCount; ++i) {
                result[i - 1] = resultSet.getObject(i);
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            Daos.closeSilently(resultSet);
            Daos.closeSilently(selectStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(List<Object> pk) throws SQLException {
        boolean bl;
        String sql = this.table.getSelectDataQueryFromPk();
        PreparedStatement selectStatement = this.getPreparedStatement(sql);
        ResultSet resultSet = null;
        try {
            int columnCountIndex = 1;
            for (Object pkColumn : pk) {
                selectStatement.setObject(columnCountIndex++, pkColumn);
            }
            resultSet = selectStatement.executeQuery();
            bl = resultSet.next();
        }
        catch (Throwable throwable) {
            Daos.closeSilently(resultSet);
            Daos.closeSilently(selectStatement);
            throw throwable;
        }
        Daos.closeSilently(resultSet);
        Daos.closeSilently(selectStatement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getPksStr() throws SQLException {
        HashSet result = Sets.newHashSet();
        if (this.table.isSelectPrimaryKeysAsStringQueryEnable()) {
            String sql = this.table.getSelectPksStrQuery();
            PreparedStatement statement = this.getConnection().prepareStatement(sql);
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    String pk = resultSet.getString(1);
                    result.add(pk);
                }
            }
            finally {
                Daos.closeSilently(resultSet);
                Daos.closeSilently(statement);
            }
        }
        String sql = this.table.getSelectPksQuery();
        PreparedStatement statement = this.getConnection().prepareStatement(sql);
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery();
            int columnCount = this.table.getPkNames().size();
            ArrayList pks = Lists.newArrayListWithCapacity((int)columnCount);
            while (resultSet.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    Object pk = resultSet.getObject(i);
                    pks.add(pk);
                }
                result.add(SynchroTableMetadata.toPkStr(pks));
                pks.clear();
            }
        }
        finally {
            Daos.closeSilently(resultSet);
            Daos.closeSilently(statement);
        }
        return result;
    }

    public List<Object> generateNewPk() throws SQLException {
        Preconditions.checkArgument((boolean)this.hasSequence);
        PreparedStatement statement = this.getPreparedStatement(this.sequenceNextValString);
        try {
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                List<Object> list = null;
                return list;
            }
            Integer sequenceValue = resultSet.getInt(1);
            ArrayList arrayList = Lists.newArrayList((Object[])new Object[]{sequenceValue});
            return arrayList;
        }
        catch (SQLException sqle) {
            log.error((Object)I18n.t((String)"adagio.synchro.dao.generateNewPk.error.log", (Object[])new Object[]{this.table.getName(), sqle.getMessage(), this.sequenceNextValString}));
            throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.dao.generateNewPk.error", (Object[])new Object[]{sqle.getMessage(), this.sequenceNextValString}));
        }
        finally {
            Daos.closeSilently(statement);
        }
    }

    @Override
    public void executeInsert(ResultSet incomingData) throws SQLException {
        ArrayList params = null;
        if (this.debug) {
            params = Lists.newArrayList();
        }
        List<Object> pk = null;
        if (this.enableInsertWithPkBind) {
            pk = this.generateNewPk();
        }
        if (this.writeInterceptor != null) {
            this.transformAndSetData(this.insertStatement, incomingData, pk, (SynchroOperationRepository)this.pendingOperationBuffer, this.writeInterceptor, (List<Object>)params);
        } else {
            this.setData(this.insertStatement, incomingData, (List<Object>)params);
        }
        if (this.enableInsertWithPkBind) {
            int i = 0;
            for (Object value : pk) {
                this.insertStatement.setObject(this.insertPkIndexes[i++], value);
            }
        }
        ++this.insertCount;
        if (!this.isJdbcBatchEnable) {
            this.checkWriteEnable();
            if (pk == null) {
                pk = this.getPk(incomingData);
            }
            if (this.debug) {
                log.debug((Object)String.format("[%s] Execute insert query (pk:%s), params: %s", this.tableName, SynchroTableMetadata.toPkStr(pk), params));
            }
            int nbRowInsert = this.insertStatement.executeUpdate();
            if (this.debug) {
                Preconditions.checkArgument((nbRowInsert == 1 ? 1 : 0) != 0, (Object)String.format("[%s] Could not insert a row into the table (pk:%s), params: %s", this.tableName, SynchroTableMetadata.toPkStr(pk), params));
            }
        } else {
            this.insertStatement.addBatch();
            if (this.insertCount > 0 && this.insertCount % this.batchSize == 0) {
                this.checkWriteEnable();
                this.insertStatement.executeBatch();
                this.insertStatement.clearBatch();
            }
        }
    }

    @Override
    public void executeInsert(Object[] incomingData) throws SQLException {
        ArrayList params = null;
        if (this.debug) {
            params = Lists.newArrayList();
        }
        List<Object> pk = null;
        if (this.enableInsertWithPkBind) {
            pk = this.generateNewPk();
            this.lastGeneratedPk = pk;
        }
        if (this.writeInterceptor != null) {
            this.transformAndSetData(this.insertStatement, incomingData, pk, (SynchroOperationRepository)this.pendingOperationBuffer, this.writeInterceptor, (List<Object>)params);
        } else {
            this.setData(this.insertStatement, incomingData, (List<Object>)params);
        }
        ++this.insertCount;
        if (!this.isJdbcBatchEnable) {
            this.checkWriteEnable();
            if (pk == null) {
                pk = this.getPk(incomingData);
            }
            if (this.debug) {
                log.debug((Object)String.format("%s Execute insert query (pk:%s), params: %s", this.tableName, SynchroTableMetadata.toPkStr(pk), params));
            }
            this.insertStatement.executeUpdate();
        } else {
            this.insertStatement.addBatch();
            if (this.insertCount > 0 && this.insertCount % this.batchSize == 0) {
                this.checkWriteEnable();
                this.insertStatement.executeBatch();
                this.insertStatement.clearBatch();
            }
        }
    }

    @Override
    public void executeUpdate(List<Object> pk, ResultSet incomingData) throws SQLException {
        ArrayList params = null;
        if (this.debug) {
            params = Lists.newArrayList();
        }
        if (this.writeInterceptor != null) {
            this.transformAndSetData(this.updateStatement, incomingData, pk, (SynchroOperationRepository)this.pendingOperationBuffer, this.writeInterceptor, (List<Object>)params);
        } else {
            this.setData(this.updateStatement, incomingData, (List<Object>)params);
        }
        int columnCountIndex = this.incomingDataColumnCount + 1;
        for (Object pkColumn : pk) {
            this.updateStatement.setObject(columnCountIndex++, pkColumn);
        }
        ++this.updateCount;
        if (!this.isJdbcBatchEnable) {
            this.checkWriteEnable();
            if (this.debug) {
                log.debug((Object)String.format("%s Execute update query (pk:%s), params: %s", this.tableName, pk, params));
            }
            int nbRowUpdated = this.updateStatement.executeUpdate();
            if (this.debug) {
                Preconditions.checkArgument((nbRowUpdated == 1 ? 1 : 0) != 0, (Object)String.format("%s rows has been updated, but expected 1 row.", nbRowUpdated));
            }
        } else {
            this.updateStatement.addBatch();
            if (this.updateCount > 0 && this.updateCount % this.batchSize == 0) {
                this.checkWriteEnable();
                this.updateStatement.executeBatch();
                this.updateStatement.clearBatch();
            }
        }
    }

    @Override
    public void executeUpdate(List<Object> pk, Object[] row) throws SQLException {
        ArrayList params = null;
        if (this.debug) {
            params = Lists.newArrayList();
        }
        if (this.writeInterceptor != null) {
            this.transformAndSetData(this.updateStatement, row, pk, (SynchroOperationRepository)this.pendingOperationBuffer, this.writeInterceptor, (List<Object>)params);
        } else {
            this.setData(this.updateStatement, row, (List<Object>)params);
        }
        int columnCountIndex = this.incomingDataColumnCount + 1;
        for (Object pkColumn : pk) {
            this.updateStatement.setObject(columnCountIndex++, pkColumn);
        }
        ++this.updateCount;
        if (this.debug) {
            if (this.debug) {
                log.debug((Object)String.format("%s Execute update query (pk:%s), params: %s", this.tableName, pk, params));
            }
            int nbRowUpdated = this.updateStatement.executeUpdate();
            if (this.debug) {
                Preconditions.checkArgument((nbRowUpdated == 1 ? 1 : 0) != 0, (Object)String.format("%s rows has been updated, but expected 1 row.", nbRowUpdated));
            }
        } else {
            this.updateStatement.addBatch();
            if (this.updateCount > 0 && this.updateCount % this.batchSize == 0) {
                this.updateStatement.executeBatch();
                this.updateStatement.clearBatch();
            }
        }
    }

    @Override
    public void executeUpdateColumn(String columnName, List<Object> pk, Object columnValue) throws SQLException {
        PreparedStatement updateColumnStatement = this.updateColumnStatements.get(columnName);
        if (updateColumnStatement == null) {
            updateColumnStatement = this.createUpdateColumnStatement(columnName);
            this.updateColumnStatements.put(columnName, updateColumnStatement);
        }
        this.executeUpdateColumn(updateColumnStatement, pk, columnName, columnValue);
    }

    @Override
    public ResultSet getDataByFks(Set<String> fkColumnNames, List<List<Object>> fkColumnsValues, Map<String, Object> bindings) throws SQLException {
        boolean insertUsingTempQueryParameter;
        int nbValues = fkColumnsValues.size();
        boolean bl = insertUsingTempQueryParameter = fkColumnNames.size() > 1 || this.dialect.getInExpressionCountLimit() > 0 && nbValues > this.dialect.getInExpressionCountLimit() || nbValues > 5000;
        if (insertUsingTempQueryParameter) {
            return this.getDataByFksUsingTempParameterTable(fkColumnNames, fkColumnsValues, bindings);
        }
        if (fkColumnNames.size() > 1) {
            throw new SynchroTechnicalException("getDataByFks() without using TempQueryParameter not implemented yet. Please enable tempQueryParameter use in the database configuration");
        }
        return this.getDataByFkUsingIn(fkColumnNames.iterator().next(), fkColumnsValues, bindings);
    }

    @Override
    public List<List<Object>> getPksByFks(Set<String> fkColumnNames, List<List<Object>> fkColumnsValues, Map<String, Object> bindings) throws SQLException {
        return this.getPksByFks(fkColumnNames, fkColumnsValues, bindings, true);
    }

    @Override
    public List<List<Object>> getPksByNotFoundFks(Set<String> fkColumnNames, List<List<Object>> fkColumnsValues, Map<String, Object> bindings) throws SQLException {
        return this.getPksByFks(fkColumnNames, fkColumnsValues, bindings, false);
    }

    @Override
    public Set<String> getPksStrByFks(Set<String> fkColumnNames, List<List<Object>> fkColumnsValues, Map<String, Object> bindings) throws SQLException {
        Map<String, Timestamp> result = this.getPksStrWithUpdateDateByFks(fkColumnNames, fkColumnsValues, bindings);
        if (MapUtils.isEmpty(result)) {
            return null;
        }
        return result.keySet();
    }

    @Override
    public Map<String, Timestamp> getPksStrWithUpdateDateByFks(Set<String> fkColumnNames, List<List<Object>> fkColumnsValues, Map<String, Object> bindings) throws SQLException {
        return this.getPksStrWithUpdateDateByFks(fkColumnNames, fkColumnsValues, bindings, true);
    }

    @Override
    public Set<String> getPksStrByNotFoundFks(Set<String> fkColumnNames, List<List<Object>> fkColumnsValues, Map<String, Object> bindings) throws SQLException {
        Map<String, Timestamp> result = this.getPksStrWithUpdateDateByFks(fkColumnNames, fkColumnsValues, bindings, false);
        if (MapUtils.isEmpty(result)) {
            return null;
        }
        return result.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Timestamp> getPksStrWithUpdateDate() throws SQLException {
        Preconditions.checkArgument((boolean)this.table.isWithUpdateDateColumn());
        HashMap result = Maps.newHashMap();
        if (this.table.isSelectPrimaryKeysAsStringQueryEnable()) {
            String sql = this.table.getSelectPksStrQuery();
            PreparedStatement statement = this.getConnection().prepareStatement(sql);
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    String pk = resultSet.getString(1);
                    Timestamp updateDate = resultSet.getTimestamp(2);
                    result.put(pk, updateDate);
                }
            }
            finally {
                Daos.closeSilently(resultSet);
                Daos.closeSilently(statement);
            }
        }
        String sql = this.table.getSelectPksQuery();
        PreparedStatement statement = this.getConnection().prepareStatement(sql);
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery();
            int pkCount = this.table.getPkNames().size();
            ArrayList pks = Lists.newArrayListWithCapacity((int)pkCount);
            while (resultSet.next()) {
                for (int i = 1; i <= pkCount; ++i) {
                    Object pk = resultSet.getObject(i);
                    pks.add(pk);
                }
                Timestamp updateDate = resultSet.getTimestamp(pkCount + 1);
                result.put(SynchroTableMetadata.toPkStr(pks), updateDate);
                pks.clear();
            }
        }
        finally {
            Daos.closeSilently(resultSet);
            Daos.closeSilently(statement);
        }
        return result;
    }

    @Override
    public Set<String> transformColumnNames(Set<String> fkColumnNames) throws SQLException {
        LinkedHashSet result = Sets.newLinkedHashSet();
        List<String> insertColumnNames = ((SynchroInsertQuery)SynchroQueryBuilder.newBuilder(this.table.getInsertQuery())).getBindingColumnNames();
        for (String columnName : fkColumnNames) {
            int fkSelectIndex = this.table.getSelectColumnIndex(columnName);
            String insertColumnName = null;
            if (fkSelectIndex == -1) {
                throw new SynchroTechnicalException(String.format("Could not found column %s in the select query. Unable to remap column names", columnName));
            }
            insertColumnName = insertColumnNames.get(fkSelectIndex);
            if (StringUtils.isBlank((CharSequence)insertColumnName)) {
                throw new SynchroTechnicalException(String.format("Could not found column %s in the insert query. Unable to remap column names", columnName));
            }
            result.add(insertColumnName);
        }
        return result;
    }

    @Override
    public List<List<Object>> transformOnRead(Set<String> fkColumnNames, List<List<Object>> fkSourceColumnValues) throws SQLException {
        if (this.readInterceptor == null) {
            return fkSourceColumnValues;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)fkSourceColumnValues.size());
        int[] fkSelectIndexes = new int[fkColumnNames.size()];
        int i = 0;
        for (String columnName : fkColumnNames) {
            int fkSelectIndex = this.table.getSelectColumnIndex(columnName);
            fkSelectIndexes[i++] = fkSelectIndex;
        }
        Object[] fakeIncominData = new Object[this.incomingDataColumnCount];
        for (List<Object> values : fkSourceColumnValues) {
            i = 0;
            for (Object value : values) {
                int fkSelectIndex = fkSelectIndexes[i++];
                fakeIncominData[fkSelectIndex] = value;
            }
            fakeIncominData = this.transformDataOnRead(fakeIncominData, this.readInterceptor);
            ArrayList transformedValues = Lists.newArrayListWithCapacity((int)fkSelectIndexes.length);
            for (int fkSelectIndex : fkSelectIndexes) {
                transformedValues.add(fakeIncominData[fkSelectIndex]);
            }
            result.add(transformedValues);
        }
        return result;
    }

    @Override
    public void prepare() {
        this.insertCount = 0;
        this.updateCount = 0;
        this.deleteCount = 0;
        this.updateColumnCounts.clear();
        this.lastGeneratedPk = null;
        this.closeUpdateColumnStatements();
    }

    @Override
    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        try {
            if (this.delegate != null) {
                return this.delegate.getPreparedStatement(sql);
            }
            return this.connection.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new SynchroTechnicalException(String.format("Error while getting pooled statement for query [%s]. Make sure this table exists in database.", sql), e);
        }
    }

    protected void executeInsertIntoTempQueryParameter(Set<String> columnNames, List<List<Object>> values, String queryParameterName, int queryPersonId, boolean transform) throws SQLException {
        this.delegate.executeDeleteTempQueryParameter(queryParameterName + "_%", true, queryPersonId);
        if (this.debug) {
            log.debug((Object)String.format("Setting query parameters into %s", "TEMP_QUERY_PARAMETER"));
        }
        Object[] fakeIncominData = null;
        int[] columnIndexesInSelect = null;
        if (transform && this.readInterceptor != null) {
            fakeIncominData = new Object[this.incomingDataColumnCount];
            columnIndexesInSelect = new int[columnNames.size()];
            int i = 0;
            for (String columnName : columnNames) {
                columnIndexesInSelect[i++] = this.table.getSelectColumnIndex(columnName);
            }
        }
        PreparedStatement statement = null;
        try {
            String sql = this.delegate.getInsertIntoTempQueryParameterQuery();
            statement = this.getPreparedStatement(sql);
            int rowCount = 1;
            int insertCount = 1;
            for (List<Object> rowValues : values) {
                int columnIndex = 0;
                for (Object columnValue : rowValues) {
                    if (fakeIncominData != null) {
                        int fakeColumnIndex = columnIndexesInSelect[columnIndex];
                        fakeIncominData[fakeColumnIndex] = columnValue;
                        columnValue = this.transformDataOnRead(fakeIncominData, this.readInterceptor)[fakeColumnIndex];
                    }
                    statement.setString(1, queryParameterName + "_" + columnIndex);
                    statement.setInt(2, rowCount);
                    statement.setObject(3, columnValue);
                    statement.setInt(4, queryPersonId);
                    statement.addBatch();
                    ++columnIndex;
                    if (++insertCount % this.batchSize != 0) continue;
                    statement.executeBatch();
                    statement.clearBatch();
                }
                ++rowCount;
            }
            if (insertCount % this.batchSize != 0) {
                statement.executeBatch();
                statement.clearBatch();
            }
        }
        catch (Exception e) {
            try {
                throw new SynchroTechnicalException(String.format("Could not insert into table %s", "TEMP_QUERY_PARAMETER"), e);
            }
            catch (Throwable throwable) {
                Daos.closeSilently(statement);
                throw throwable;
            }
        }
        Daos.closeSilently(statement);
    }

    protected void executeUpdateColumn(PreparedStatement updateColumnStatement, List<Object> pk, String columnName, Object columnValue) throws SQLException {
        ArrayList params = null;
        if (this.debug) {
            params = Lists.newArrayList();
        }
        if (this.readInterceptor != null && this.sourceDao != null) {
            columnValue = this.transformDataOnRead(columnName, columnValue, this.readInterceptor);
        }
        int columnCountIndex = 1;
        updateColumnStatement.setObject(columnCountIndex++, columnValue);
        if (this.debug) {
            params.add(columnValue);
        }
        for (Object pkColumn : pk) {
            updateColumnStatement.setObject(columnCountIndex++, pkColumn);
            if (!this.debug) continue;
            params.add(pkColumn);
        }
        int updateColumnCount = MapUtils.getIntValue(this.updateColumnCounts, (Object)columnName) + 1;
        this.updateColumnCounts.put(columnName, updateColumnCount);
        if (!this.isJdbcBatchEnable) {
            this.checkWriteEnable();
            if (this.debug) {
                log.debug((Object)String.format("[%s] Execute update query (pk:%s), params: %s", this.tableName, pk, params));
            }
            int nbRowUpdated = updateColumnStatement.executeUpdate();
            if (this.debug) {
                Preconditions.checkArgument((nbRowUpdated == 1 ? 1 : 0) != 0, (Object)String.format("[%s]   %s rows has been updated, but expected 1 row.", this.tableName, nbRowUpdated));
            }
        } else {
            updateColumnStatement.addBatch();
            if (updateColumnCount % this.batchSize == 0) {
                this.checkWriteEnable();
                updateColumnStatement.executeBatch();
                updateColumnStatement.clearBatch();
            }
        }
    }

    protected void closeSelectStatements() {
        if (CollectionUtils.isNotEmpty(this.selectStatements)) {
            for (PreparedStatement statement : this.selectStatements) {
                Daos.closeSilently(statement);
            }
            this.selectStatements.clear();
        }
    }

    protected void closeUpdateColumnStatements() {
        if (MapUtils.isNotEmpty(this.updateColumnStatements)) {
            for (PreparedStatement statement : this.updateColumnStatements.values()) {
                Daos.closeSilently(statement);
            }
            this.updateColumnStatements.clear();
        }
    }

    protected void closeSelectPkByIndexStatements() {
        if (MapUtils.isNotEmpty(this.selectPkByIndexStatements)) {
            for (PreparedStatement statement : this.selectPkByIndexStatements.keySet()) {
                Daos.closeSilently(statement);
            }
            this.selectPkByIndexStatements.clear();
        }
    }

    protected void registerSelectStatementAndClosePrevious(PreparedStatement newStatement) {
        this.closeSelectStatements();
        this.selectStatements.add(newStatement);
    }

    protected void transformAndSetData(PreparedStatement statement, ResultSet incomingData, List<Object> pk, SynchroOperationRepository transformBuffer, SynchroInterceptor interceptor, List<Object> debugParams) throws SQLException {
        Preconditions.checkNotNull((Object)transformBuffer);
        Object[] row = this.transformDataOnWrite(incomingData, pk, interceptor, transformBuffer);
        this.setData(statement, row, debugParams);
    }

    protected void transformAndSetData(PreparedStatement statement, Object[] incomingData, List<Object> pk, SynchroOperationRepository transformBuffer, SynchroInterceptor interceptor, List<Object> debugParams) throws SQLException {
        Preconditions.checkNotNull((Object)transformBuffer);
        Object[] row = this.transformDataOnWrite(incomingData, pk, interceptor, transformBuffer);
        this.setData(statement, row, debugParams);
    }

    protected Object[] transformDataOnWrite(ResultSet incomingData, List<Object> pk, SynchroInterceptor interceptor, SynchroOperationRepository buffer) throws SQLException {
        Preconditions.checkNotNull((Object)interceptor);
        Object[] result = this.getData(incomingData);
        try {
            interceptor.onWrite(result, pk, this.sourceDao, this, buffer);
        }
        catch (SynchroBusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.dao.write.tranformData.error", (Object[])new Object[]{this.table.getName(), e.getMessage()}), e);
        }
        return result;
    }

    protected Object[] transformDataOnWrite(Object[] incomingData, List<Object> pk, SynchroInterceptor interceptor, SynchroOperationRepository buffer) throws SQLException {
        Preconditions.checkNotNull((Object)interceptor);
        try {
            interceptor.onWrite(incomingData, pk, this.sourceDao, this, buffer);
        }
        catch (SynchroBusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.dao.write.tranformData.error", (Object[])new Object[]{this.table.getName(), e.getMessage()}), e);
        }
        return incomingData;
    }

    protected Object[] transformDataOnRead(ResultSet incomingData, SynchroInterceptor interceptor) throws SQLException {
        Object[] result = this.getData(incomingData);
        try {
            interceptor.onRead(result, this.sourceDao, this);
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.dao.read.tranformData.error", (Object[])new Object[]{this.table.getName(), e.getMessage()}), e);
        }
        return result;
    }

    protected Object[] transformDataOnRead(Object[] incomingData, SynchroInterceptor interceptor) throws SQLException {
        try {
            interceptor.onRead(incomingData, this.sourceDao, this);
        }
        catch (SynchroBusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.dao.read.tranformData.error", (Object[])new Object[]{this.table.getName(), e.getMessage()}), e);
        }
        return incomingData;
    }

    protected Object transformDataOnRead(String columnName, Object columnValue, SynchroInterceptor interceptor) throws SQLException {
        int columnIndexInInsertQuery = this.table.getInsertColumnIndex(columnName);
        Object[] fakeIncomingData = new Object[this.incomingDataColumnCount];
        fakeIncomingData[columnIndexInInsertQuery] = columnValue;
        fakeIncomingData = this.transformDataOnRead(fakeIncomingData, this.readInterceptor);
        return fakeIncomingData[columnIndexInInsertQuery];
    }

    protected void setData(PreparedStatement statement, Object[] values, List<Object> debugParams) throws SQLException {
        for (int c = 1; c <= this.incomingDataColumnCount; ++c) {
            Object object = values[c - 1];
            statement.setObject(c, object);
            if (!this.debug) continue;
            debugParams.add(object);
        }
    }

    protected void setData(PreparedStatement statement, ResultSet incomingData, List<Object> debugParams) throws SQLException {
        for (int c = 1; c <= this.incomingDataColumnCount; ++c) {
            Object object = this.getObject(incomingData, c);
            statement.setObject(c, object);
            if (!this.debug) continue;
            debugParams.add(object);
        }
    }

    protected Object[] getData(ResultSet incomingData) throws SQLException {
        Object[] result = new Object[this.incomingDataColumnCount];
        for (int c = 1; c <= this.incomingDataColumnCount; ++c) {
            Object object;
            result[c - 1] = object = this.getObject(incomingData, c);
        }
        return result;
    }

    public Object getObject(ResultSet incomingData, int index) throws SQLException {
        Object object = incomingData.getObject(index);
        if (object instanceof TIMESTAMP) {
            object = ((TIMESTAMP)object).timestampValue();
        } else if (object instanceof BigDecimal && ((BigDecimal)object).scale() == 0) {
            object = ((BigDecimal)object).intValue();
        }
        return object;
    }

    @Override
    public List<Object> getPk(ResultSet incomingData) throws SQLException {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.selectPkIndexs.length);
        for (int pkIndex : this.selectPkIndexs) {
            Object pk = this.getObject(incomingData, pkIndex);
            result.add(pk);
        }
        return result;
    }

    @Override
    public List<Object> getPk(ResultSet incomingData, boolean transform) throws SQLException {
        if (transform && this.readInterceptor != null) {
            Object[] fakeIncominData = new Object[this.incomingDataColumnCount];
            for (int pkIndex : this.selectPkIndexs) {
                fakeIncominData[pkIndex - 1] = incomingData.getObject(pkIndex);
            }
            fakeIncominData = this.transformDataOnRead(fakeIncominData, this.readInterceptor);
            return this.getPk(fakeIncominData);
        }
        return this.getPk(incomingData);
    }

    @Override
    public Timestamp getUpdateDate(ResultSet incomingData, boolean transform) throws SQLException {
        if (transform && this.readInterceptor != null) {
            Object[] data = this.transformDataOnRead(incomingData, this.readInterceptor);
            return this.table.getUpdateDate(data);
        }
        return this.table.getUpdateDate(incomingData);
    }

    public List<Object> getPk(Object[] incomingData) throws SQLException {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.selectPkIndexs.length);
        for (int pkIndex : this.selectPkIndexs) {
            Object pk = incomingData[pkIndex - 1];
            result.add(pk);
        }
        return result;
    }

    @Override
    public Map<String, List<Object>> getPkFromUniqueConstraints(ResultSet incomingData) throws SQLException {
        Object[] data = null;
        if (this.readInterceptor != null) {
            Object[] fakeIncomingData = new Object[this.incomingDataColumnCount];
            for (int index : this.incominDataIndexedNeedForIndex) {
                fakeIncomingData[index] = this.getObject(incomingData, index + 1);
            }
            data = this.transformDataOnRead(fakeIncomingData, this.readInterceptor);
        } else {
            data = this.getData(incomingData);
        }
        return this.getPkFromUniqueConstraints(data);
    }

    @Override
    public boolean lock(List<Object> pk) throws SQLException {
        if (this.lockStatement == null) {
            return true;
        }
        int i = 1;
        for (Object value : pk) {
            this.lockStatement.setObject(i++, value);
        }
        try {
            this.lockStatement.execute();
        }
        catch (SQLException e) {
            if (this.debug) {
                log.debug((Object)String.format("[%s] Could not acquire lock, for pk: %s. %s", this.table.getName(), pk, e.getMessage()));
            }
            return false;
        }
        return true;
    }

    @Override
    public List<Object> getLastGeneratedPk() {
        return this.lastGeneratedPk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<List<Object>> getPksByFks(Set<String> fkColumnNames, List<List<Object>> fkColumnsValues, Map<String, Object> bindings, boolean returnIfMatchValues) throws SQLException {
        ArrayList arrayList;
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(fkColumnNames));
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(fkColumnsValues));
        Integer userId = (Integer)bindings.get("userId");
        if (userId == null) {
            userId = new Integer(-1);
        }
        this.executeInsertIntoTempQueryParameter(fkColumnNames, fkColumnsValues, TEMP_QUERY_PARAMETER_PARAM_NAME, userId, false);
        ArrayList result = Lists.newArrayList();
        PreparedStatement statement = null;
        try {
            String sql = returnIfMatchValues ? this.createSelectByManyFksUsingTempParameterTable(this.table.getSelectPksQuery(), fkColumnNames, TEMP_QUERY_PARAMETER_PARAM_NAME) : this.createSelectNotMatchManyFksUsingTempParameterTable(this.table.getSelectPksQuery(), fkColumnNames, TEMP_QUERY_PARAMETER_PARAM_NAME);
            statement = this.prepareAndBindStatement(sql, bindings, "selectPksByFks");
            statement.setFetchSize(this.batchSize);
            ResultSet rows = statement.executeQuery();
            int pkCount = this.table.getPkNames().size();
            while (rows.next()) {
                ArrayList pk = Lists.newArrayListWithCapacity((int)pkCount);
                for (int i = 1; i <= pkCount; ++i) {
                    Object value = this.getObject(rows, i);
                    pk.add(value);
                }
                result.add(pk);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            Daos.closeSilently(statement);
            throw throwable;
        }
        Daos.closeSilently(statement);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Timestamp> getPksStrWithUpdateDateByFks(Set<String> fkColumnNames, List<List<Object>> fkColumnsValues, Map<String, Object> bindings, boolean returnIfMatchValues) throws SQLException {
        HashMap hashMap;
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(fkColumnNames));
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(fkColumnsValues));
        boolean enableUpdateDate = this.table.isWithUpdateDateColumn();
        Integer userId = (Integer)bindings.get("userId");
        if (userId == null) {
            userId = new Integer(-1);
        }
        this.executeInsertIntoTempQueryParameter(fkColumnNames, fkColumnsValues, TEMP_QUERY_PARAMETER_PARAM_NAME, userId, false);
        HashMap result = Maps.newHashMap();
        Timestamp fakeTimestamp = new Timestamp(0L);
        PreparedStatement statement = null;
        try {
            String sql;
            if (this.table.isSelectPrimaryKeysAsStringQueryEnable()) {
                sql = returnIfMatchValues ? this.createSelectByManyFksUsingTempParameterTable(this.table.getSelectPksStrQuery(), fkColumnNames, TEMP_QUERY_PARAMETER_PARAM_NAME) : this.createSelectNotMatchManyFksUsingTempParameterTable(this.table.getSelectPksStrQuery(), fkColumnNames, TEMP_QUERY_PARAMETER_PARAM_NAME);
                statement = this.prepareAndBindStatement(sql, bindings, "selectPksStrByFks");
                statement.setFetchSize(this.batchSize);
                ResultSet rows = statement.executeQuery();
                while (rows.next()) {
                    String pkStr = rows.getString(1);
                    if (enableUpdateDate) {
                        Timestamp updateDate = rows.getTimestamp(2);
                        result.put(pkStr, updateDate);
                        continue;
                    }
                    result.put(pkStr, fakeTimestamp);
                }
            } else {
                sql = returnIfMatchValues ? this.createSelectByManyFksUsingTempParameterTable(this.table.getSelectPksQuery(), fkColumnNames, TEMP_QUERY_PARAMETER_PARAM_NAME) : this.createSelectNotMatchManyFksUsingTempParameterTable(this.table.getSelectPksQuery(), fkColumnNames, TEMP_QUERY_PARAMETER_PARAM_NAME);
                statement = this.prepareAndBindStatement(sql, bindings, "selectPksByFks");
                statement.setFetchSize(this.batchSize);
                ResultSet rows = statement.executeQuery();
                int pkCount = this.table.getPkNames().size();
                ArrayList pk = Lists.newArrayListWithCapacity((int)pkCount);
                while (rows.next()) {
                    for (int i = 1; i <= pkCount; ++i) {
                        Object value = this.getObject(rows, i);
                        pk.add(value);
                    }
                    String pkStr = SynchroTableMetadata.toPkStr(pk);
                    pk.clear();
                    if (enableUpdateDate) {
                        Timestamp updateDate = rows.getTimestamp(pkCount + 1);
                        result.put(pkStr, updateDate);
                        continue;
                    }
                    result.put(pkStr, fakeTimestamp);
                }
            }
            hashMap = result;
        }
        catch (Throwable throwable) {
            Daos.closeSilently(statement);
            throw throwable;
        }
        Daos.closeSilently(statement);
        return hashMap;
    }

    protected Map<String, List<Object>> getPkFromUniqueConstraints(Object[] data) throws SQLException {
        HashMap result = Maps.newHashMap();
        Iterator constraintNames = Lists.newArrayList(this.table.getUniqueConstraints().keySet()).iterator();
        for (Map.Entry<PreparedStatement, int[]> entry : this.selectPkByIndexStatements.entrySet()) {
            PreparedStatement statement = entry.getKey();
            int[] columnIndexes = entry.getValue();
            String constraintName = (String)constraintNames.next();
            int i = 1;
            for (int columnIndex : columnIndexes) {
                Object columnValue = data[columnIndex - 1];
                statement.setObject(i++, columnValue);
            }
            ResultSet pkResultset = statement.executeQuery();
            ArrayList pk = null;
            int pkColumnCount = this.table.getPkNames().size();
            while (pkResultset.next()) {
                if (pk != null) {
                    log.warn((Object)String.format("More than one row when check unique constraints %s, when expected only one row.", constraintName));
                    break;
                }
                pk = Lists.newArrayListWithCapacity((int)pkColumnCount);
                for (int j = 1; j <= pkColumnCount; ++j) {
                    Object value = this.getObject(pkResultset, j);
                    pk.add(value);
                }
            }
            if (pk != null) {
                result.put(constraintName, pk);
            }
            Daos.closeSilently(pkResultset);
        }
        return result;
    }

    protected ResultSet getDataByFkUsingIn(String fkColumnName, List<List<Object>> values, Map<String, Object> bindings) throws SQLException {
        String sql = this.createSelectByFkWithInQuery(this.table.getSelectAllQuery(), fkColumnName, values.size());
        Preconditions.checkNotNull((Object)sql, (Object)String.format("Columns %s is not referenced for table %s", fkColumnName, this.table.getName()));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] Prepare select query: %s", this.table.getName(), sql));
        }
        PreparedStatement statement = this.prepareAndBindSelectStatement(sql, bindings, "select");
        this.registerSelectStatementAndClosePrevious(statement);
        int paramIndex = 1;
        for (List<Object> value : values) {
            statement.setObject(paramIndex, value.iterator().next());
            ++paramIndex;
        }
        statement.setFetchSize(this.batchSize);
        ResultSet result = statement.executeQuery();
        return result;
    }

    protected ResultSet getDataByFkUsingTempParameterTable(String fkColumnName, List<Object> values, Map<String, Object> bindings) throws SQLException {
        Integer userId;
        String queryParameterName = fkColumnName;
        String sql = this.createSelectByOneFkUsingTempParameterTable(this.table.getSelectAllQuery(), fkColumnName, queryParameterName);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] Prepare select query: %s", this.table.getName(), sql));
        }
        if ((userId = (Integer)bindings.get("userId")) == null) {
            userId = new Integer(-1);
        }
        this.delegate.executeInsertIntoTempQueryParameter(values, queryParameterName, userId);
        PreparedStatement statement = this.prepareAndBindSelectStatement(sql, bindings, "selectByFk");
        this.registerSelectStatementAndClosePrevious(statement);
        statement.setFetchSize(this.batchSize);
        ResultSet result = statement.executeQuery();
        return result;
    }

    protected ResultSet getDataByFksUsingTempParameterTable(Set<String> columnNames, List<List<Object>> columnValues, Map<String, Object> bindings) throws SQLException {
        Integer userId;
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columnNames));
        String baseSql = this.table.getSelectAllQuery();
        String sql = this.createSelectByManyFksUsingTempParameterTable(baseSql, columnNames, TEMP_QUERY_PARAMETER_PARAM_NAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] Prepare select query: %s", this.table.getName(), sql));
        }
        if ((userId = (Integer)bindings.get("userId")) == null) {
            userId = new Integer(-1);
        }
        this.executeInsertIntoTempQueryParameter(columnNames, columnValues, TEMP_QUERY_PARAMETER_PARAM_NAME, userId, false);
        PreparedStatement statement = this.prepareAndBindSelectStatement(sql, bindings, "select");
        this.registerSelectStatementAndClosePrevious(statement);
        statement.setFetchSize(this.batchSize);
        ResultSet result = statement.executeQuery();
        return result;
    }

    private SynchroInterceptor createReadInterceptor(SynchroTableMetadata table) {
        List<SynchroInterceptor> interceptors = table.getInterceptors();
        if (CollectionUtils.isEmpty(interceptors)) {
            return null;
        }
        ArrayList readInterceptors = Lists.newArrayList();
        try {
            for (SynchroInterceptor interceptor : interceptors) {
                if (!interceptor.enableOnRead()) continue;
                readInterceptors.add(interceptor);
            }
        }
        catch (Exception e) {
            throw new SynchroTechnicalException("Could not initialize DAO read interceptors.", e);
        }
        if (CollectionUtils.isEmpty((Collection)readInterceptors)) {
            return null;
        }
        return SynchroInterceptorUtils.chain(readInterceptors, SynchroInterceptorBase.class);
    }

    private SynchroInterceptor createWriteInterceptor(SynchroTableMetadata table) {
        List<SynchroInterceptor> interceptors = table.getInterceptors();
        if (CollectionUtils.isEmpty(interceptors)) {
            return null;
        }
        ArrayList writeInterceptors = Lists.newArrayList();
        try {
            for (SynchroInterceptor interceptor : interceptors) {
                if (!interceptor.enableOnWrite()) continue;
                SynchroInterceptor newInterceptor = interceptor.clone();
                writeInterceptors.add(newInterceptor);
            }
        }
        catch (Exception e) {
            throw new SynchroTechnicalException("Could not initialize DAO read interceptors.", e);
        }
        if (CollectionUtils.isEmpty((Collection)writeInterceptors)) {
            return null;
        }
        return SynchroInterceptorUtils.chain(writeInterceptors, SynchroInterceptorBase.class);
    }

    protected String createSelectSequenceNextValString(Dialect dialect, SynchroTableMetadata table) {
        String sequenceName = table.getSequenceName();
        if (StringUtils.isBlank((CharSequence)sequenceName)) {
            return null;
        }
        return dialect.getSelectSequenceNextValString(sequenceName);
    }

    protected String createSequenceNextValString(Dialect dialect, SynchroTableMetadata table) {
        String sequenceName = table.getSequenceName();
        if (StringUtils.isBlank((CharSequence)sequenceName)) {
            return null;
        }
        if (dialect.getClass().getSimpleName().startsWith("Oracle")) {
            int maxSequenceName = 30;
            if (sequenceName.length() > maxSequenceName) {
                throw new SynchroTechnicalException(String.format("Sequence name '%s': exceed the database max length of %s caracters", sequenceName, maxSequenceName));
            }
        }
        return dialect.getSequenceNextValString(sequenceName);
    }

    protected int createIncomingDataColumnCount(SynchroTableMetadata table) {
        String selectSql = table.getSelectAllQuery();
        int selectColumnCount = SynchroQueryBuilder.newBuilder(selectSql).getColumnCount();
        return selectColumnCount;
    }

    protected PreparedStatement createInsertStatement(Connection connection, Dialect dialect, SynchroTableMetadata table) throws SQLException {
        String sql = table.getInsertQuery();
        String dialectSelectSequenceNextValString = this.createSelectSequenceNextValString(dialect, table);
        String oldSequenceNextValString = table.getSelectSequenceNextValString();
        if (StringUtils.isNotBlank((CharSequence)dialectSelectSequenceNextValString) && StringUtils.isNotBlank((CharSequence)oldSequenceNextValString) && sql.contains(oldSequenceNextValString)) {
            sql = sql.replaceAll(oldSequenceNextValString, dialectSelectSequenceNextValString);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] Prepare insert query: %s", table.getName(), sql));
        }
        PreparedStatement statement = connection.prepareStatement(sql);
        return statement;
    }

    protected String createInsertWithPkBindQuery(SynchroTableMetadata table) throws SQLException {
        Preconditions.checkArgument((CollectionUtils.size(table.getPkNames()) > 0 ? 1 : 0) != 0, (Object)"Table should have a PK to create insert query with PK Bind");
        SynchroQueryBuilder query = SynchroQueryBuilder.newBuilder(table.getInsertQuery());
        for (String pkName : table.getPkNames()) {
            query.setColumnValue(pkName, "?");
        }
        String sql = query.build();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] Prepare insert query (force PK binding): %s", table.getName(), sql));
        }
        return sql;
    }

    private int[] initInsertPkIndexes(String insertWithPkBindQuery) {
        Set<String> pkNames = this.table.getPkNames();
        SynchroInsertQuery insertQuery = (SynchroInsertQuery)SynchroQueryBuilder.newBuilder(insertWithPkBindQuery);
        int[] insertPkIndexes = new int[pkNames.size()];
        int i = 0;
        for (String pkName : pkNames) {
            int pkIndex = insertQuery.getBindingColumnNames().indexOf(pkName);
            if (pkIndex != -1) {
                insertPkIndexes[i++] = pkIndex + 1;
                continue;
            }
            throw new SynchroTechnicalException(String.format("Could not retrieve PK column %s in the sinsert query", pkName));
        }
        return insertPkIndexes;
    }

    private String initCountAllApproxQuery(Dialect dialect, SynchroDatabaseConfiguration configuration, SynchroTableMetadata table) {
        String result = null;
        if (Daos.isOracleDatabase(configuration.getUrl())) {
            String jdbcSchema = configuration.getJdbcSchema();
            String jdbcUser = configuration.getJdbcUser();
            result = StringUtils.isBlank((CharSequence)jdbcSchema) || jdbcSchema.equalsIgnoreCase(jdbcUser) ? String.format("SELECT num_rows FROM user_tables WHERE table_name='%s'", table.getName()) : String.format("SELECT num_rows FROM all_tables WHERE owner='%s' AND table_name='%s'", jdbcSchema, table.getName());
        }
        return result;
    }

    private PreparedStatement createUpdateStatement(Connection connection, SynchroTableMetadata table) throws SQLException {
        String sql = table.getUpdateQuery();
        Preconditions.checkArgument((boolean)sql.toUpperCase().startsWith("UPDATE"), (Object)String.format("[%s] Update SQL query should be like 'UPDATE ...' but was: %s", table.getName(), sql));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] Prepare update query: %s", table.getName(), sql));
        }
        PreparedStatement statement = connection.prepareStatement(sql);
        return statement;
    }

    private PreparedStatement createDeleteStatement(Connection connection, SynchroTableMetadata table) throws SQLException {
        String sql = table.getDeleteByPkQuery();
        Preconditions.checkArgument((boolean)sql.toUpperCase().startsWith("DELETE"), (Object)String.format("[%s] Update SQL query should be like 'DELETE ...' but was: %s", table.getName(), sql));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] Prepare delete query: %s", table.getName(), sql));
        }
        PreparedStatement statement = connection.prepareStatement(sql);
        return statement;
    }

    private PreparedStatement createLockStatement(Connection connection, SynchroTableMetadata table) throws SQLException {
        LockMode lockMode = table.getLockModeOnUpdate();
        String selectPkSql = StringUtils.trimToNull((String)table.getSelectPksQuery());
        String forUpdateString = StringUtils.trimToNull((String)this.dialect.getForUpdateString(lockMode));
        if (lockMode == LockMode.NONE || selectPkSql == null || forUpdateString == null) {
            return null;
        }
        String sql = String.format("%s WHERE %s %s", selectPkSql, table.createPkWhereClause("t"), forUpdateString);
        PreparedStatement statement = connection.prepareStatement(sql);
        return statement;
    }

    private Map<PreparedStatement, int[]> createSelectPkByIndexStatement(Connection connection, SynchroTableMetadata table) throws SQLException {
        Map<String, List<String>> uniqueConstraints = table.getUniqueConstraints();
        if (MapUtils.isEmpty(uniqueConstraints)) {
            return null;
        }
        String pkName = null;
        if (this.enableInsertWithPkBind) {
            pkName = table.getPkNames().iterator().next();
        }
        SynchroQueryBuilder insertQuery = SynchroQueryBuilder.newBuilder(table.getInsertQuery());
        HashMap columnNameIndexes = Maps.newHashMap();
        int i = 1;
        for (String columnName : insertQuery.getColumnNames()) {
            String insertColumnValue = insertQuery.getColumnValue(columnName);
            if ("?".equals(insertColumnValue) || insertColumnValue.startsWith(":")) {
                columnNameIndexes.put(columnName, i);
            } else if (this.enableInsertWithPkBind && columnName.equals(pkName)) {
                columnNameIndexes.put(pkName, i);
            }
            ++i;
        }
        LinkedHashMap results = Maps.newLinkedHashMap();
        block1: for (Map.Entry<String, List<String>> entry : uniqueConstraints.entrySet()) {
            String indexName = entry.getKey();
            List<String> columnNames = entry.getValue();
            String sql = table.getSelectPkByIndex(indexName);
            PreparedStatement statement = connection.prepareStatement(sql);
            this.selectStatements.add(statement);
            int[] bindingColumnIndexes = new int[columnNames.size()];
            results.put(statement, bindingColumnIndexes);
            int j = 0;
            for (String columnName : columnNames) {
                Integer bindingColumnIndex = (Integer)columnNameIndexes.get(columnName);
                if (bindingColumnIndex == null) {
                    log.warn((Object)String.format("[%s] Ignore unique constraints %s, because column %s not bind in insert query", table.getName(), indexName, columnName));
                    results.remove(statement);
                    continue block1;
                }
                bindingColumnIndexes[j++] = bindingColumnIndex;
            }
        }
        return results;
    }

    protected int[] createIncomingDataIndexedNeedForIndex(Map<PreparedStatement, int[]> selectPkByIndexStatements, int incomingDataColumnCount) {
        if (MapUtils.isEmpty(selectPkByIndexStatements)) {
            return null;
        }
        int[] indexes = new int[incomingDataColumnCount];
        int length = 0;
        for (int[] indexForUniqueConstraint : selectPkByIndexStatements.values()) {
            for (int i : indexForUniqueConstraint) {
                indexes[length++] = i - 1;
            }
        }
        return Arrays.copyOf(indexes, length);
    }

    protected String createSelectByFkWithInQuery(String selectQuery, String columnName, int nbValues) {
        StringBuilder params = new StringBuilder();
        for (int i = 0; i < nbValues; ++i) {
            params.append(",?");
        }
        SynchroSelectQuery query = null;
        if (this.keepWhereClauseOnQueriesByFks) {
            query = (SynchroSelectQuery)SynchroQueryBuilder.newBuilder(selectQuery);
        } else {
            List<String> columnNames = SynchroQueryBuilder.newBuilder(selectQuery).getColumnNamesWithAlias();
            query = new SynchroSelectQuery(null, this.table.getName(), columnNames, null);
            query.setWhereClause(null);
        }
        query.setTableAlias("t");
        query.addWhere(SynchroQueryOperator.AND, String.format("t.%s IN (%s)", columnName, params.substring(1)));
        return query.build();
    }

    protected String createSelectByOneFkUsingTempParameterTable(String selectQuery, String fkColumnName, String queryParameterName) {
        SynchroSelectQuery query = null;
        if (this.keepWhereClauseOnQueriesByFks) {
            query = (SynchroSelectQuery)SynchroQueryBuilder.newBuilder(selectQuery);
        } else {
            List<String> columnNames = SynchroQueryBuilder.newBuilder(selectQuery).getColumnNamesWithAlias();
            query = new SynchroSelectQuery(null, this.table.getName(), columnNames, null);
            query.setWhereClause(null);
        }
        query.setTableAlias("t");
        query.addJoin(String.format("INNER JOIN TEMP_QUERY_PARAMETER p on t.%s = p.ALPHANUMERICAL_VALUE AND p.PARAMETER_NAME='%s' AND p.PERSON_FK=:userId", fkColumnName, queryParameterName));
        return query.build();
    }

    protected String createSelectByManyFksUsingTempParameterTable(String selectQuery, Set<String> fkColumnNames, String queryParameterName) {
        SynchroSelectQuery query = null;
        if (this.keepWhereClauseOnQueriesByFks) {
            query = (SynchroSelectQuery)SynchroQueryBuilder.newBuilder(selectQuery);
        } else {
            List<String> columnNames = SynchroQueryBuilder.newBuilder(selectQuery).getColumnNamesWithAlias();
            query = new SynchroSelectQuery(null, this.table.getName(), columnNames, null);
            query.setWhereClause(null);
        }
        query.setTableAlias("t");
        query.addJoin(this.createJoinUsingTempParameterTable(fkColumnNames, queryParameterName));
        return query.build();
    }

    protected String createJoinUsingTempParameterTable(Set<String> fkColumnNames, String queryParameterName) {
        int index = 0;
        StringBuilder joinBuffer = new StringBuilder();
        for (String columnName : fkColumnNames) {
            String alias = "tqp_" + index;
            joinBuffer.append(String.format(" INNER JOIN TEMP_QUERY_PARAMETER %s", alias));
            joinBuffer.append(String.format(" ON %s.alphanumerical_value=t.%s", alias, columnName));
            joinBuffer.append(String.format(" AND %s.parameter_name='%s_%s'", alias, queryParameterName, index));
            if (index > 0) {
                joinBuffer.append(String.format(" AND %s.numerical_value=tqp_0.numerical_value", alias));
            }
            ++index;
        }
        return joinBuffer.toString();
    }

    protected String createSelectNotMatchManyFksUsingTempParameterTable(String selectQuery, Set<String> fkColumnNames, String queryParameterName) {
        SynchroSelectQuery query = null;
        if (this.keepWhereClauseOnQueriesByFks) {
            query = (SynchroSelectQuery)SynchroQueryBuilder.newBuilder(selectQuery);
        } else {
            List<String> columnNames = SynchroQueryBuilder.newBuilder(selectQuery).getColumnNamesWithAlias();
            query = new SynchroSelectQuery(null, this.table.getName(), columnNames, null);
            query.setWhereClause(null);
        }
        query.setTableAlias("t");
        this.addNotInUsingTempParameterTable(query, fkColumnNames, queryParameterName);
        return query.build();
    }

    protected SynchroSelectQuery addNotInUsingTempParameterTable(SynchroSelectQuery query, Set<String> fkColumnNames, String queryParameterName) {
        int index = 0;
        StringBuilder joinBuffer = new StringBuilder();
        StringBuilder whereBuffer = new StringBuilder();
        for (String columnName : fkColumnNames) {
            String alias = "tqp_" + index;
            joinBuffer.append(String.format(" LEFT OUTER JOIN TEMP_QUERY_PARAMETER %s", alias));
            joinBuffer.append(String.format(" ON %s.alphanumerical_value=t.%s", alias, columnName));
            joinBuffer.append(String.format(" AND %s.parameter_name='%s_%s'", alias, queryParameterName, index));
            if (index > 0) {
                joinBuffer.append(String.format(" AND %s.numerical_value=tqp_0.numerical_value", alias));
            }
            if (index > 0) {
                whereBuffer.append(" AND ");
            }
            whereBuffer.append(String.format("%s.id is null", alias));
            ++index;
        }
        query.addJoin(joinBuffer.toString());
        query.addWhere(SynchroQueryOperator.AND, whereBuffer.toString());
        return query;
    }

    protected String createUpdateColumnQuery(String columnName, String referenceTableName) {
        if (CollectionUtils.isEmpty(this.table.getPkNames())) {
            return null;
        }
        String result = String.format("UPDATE %s SET %s = ? WHERE %s", this.table.getName(), columnName, this.table.createPkWhereClause());
        return result;
    }

    protected PreparedStatement prepareAndBindSelectStatement(String sql, Map<String, Object> bindingMap, String queryTypeName) throws SQLException {
        PreparedStatement statement = this.prepareAndBindStatement(sql, bindingMap, queryTypeName);
        statement.setFetchSize(this.batchSize);
        statement.setFetchDirection(1000);
        return statement;
    }

    protected PreparedStatement prepareAndBindStatement(String sql, Map<String, Object> bindingMap, String queryTypeName) throws SQLException {
        StringBuilder sb = new StringBuilder();
        StringBuilder debugParams = null;
        if (this.debug) {
            debugParams = new StringBuilder();
        }
        ArrayList orderedBindingValues = Lists.newArrayList();
        Matcher paramMatcher = Pattern.compile(":[a-zA-Z_0-9]+").matcher(sql);
        int offset = 0;
        while (paramMatcher.find()) {
            String bindingName = sql.substring(paramMatcher.start() + 1, paramMatcher.end());
            Object bindingValue = bindingMap.get(bindingName);
            if (bindingValue == null && !bindingMap.containsKey(bindingName)) {
                log.error((Object)I18n.t((String)"adagio.synchro.bindingQuery.error.log", (Object[])new Object[]{this.table.getName(), bindingName, sql}));
                throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.bindingQuery.error", (Object[])new Object[]{this.table.getName()}));
            }
            orderedBindingValues.add(bindingValue);
            sb.append(sql.substring(offset, paramMatcher.start())).append("?");
            offset = paramMatcher.end();
            if (!this.debug) continue;
            debugParams.append(", ").append(bindingValue);
        }
        if (offset > 0) {
            if (offset < sql.length()) {
                sb.append(sql.substring(offset));
            }
            sql = sb.toString();
        }
        if (this.debug) {
            log.debug((Object)String.format("[%s] Execute %s query: %s", this.table.getName(), queryTypeName, sql));
            log.debug((Object)String.format("[%s]          with params: [%s]", this.table.getName(), debugParams.length() > 2 ? debugParams.substring(2) : "no binding"));
        }
        PreparedStatement statement = this.connection.prepareStatement(sql);
        int index = 1;
        for (Object value : orderedBindingValues) {
            statement.setObject(index, value);
            ++index;
        }
        return statement;
    }

    protected Map<String, Object> prepareBindings(Map<String, Object> bindings) {
        if (MapUtils.isEmpty(bindings)) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap(bindings);
        for (Map.Entry<String, Object> entry : bindings.entrySet()) {
            String bindingName = entry.getKey();
            Object bindingValue = entry.getValue();
            if (!(bindingValue instanceof Date)) continue;
            bindingValue = new Timestamp(((Date)bindingValue).getTime());
            result.put(bindingName, bindingValue);
        }
        return result;
    }

    protected PreparedStatement createUpdateColumnStatement(String columnName) throws SQLException {
        SynchroColumnMetadata column = this.table.getColumn(columnName);
        if (column == null) {
            throw new SynchroTechnicalException(String.format("No column %s found in table %s", columnName.toUpperCase(), this.table.getName()));
        }
        SynchroJoinMetadata join = column.getParentJoin();
        String referenceTableName = null;
        if (join != null) {
            referenceTableName = join.getTargetTable().getName();
        }
        String sql = this.createUpdateColumnQuery(columnName, referenceTableName);
        PreparedStatement updateColumnStatement = this.connection.prepareStatement(sql);
        return updateColumnStatement;
    }

    protected void checkPkNotUsedBeforeDelete(List<Object> pk) throws SQLException, DataIntegrityViolationOnDeleteException {
        Map<String, String> countPkReferenceQueries = this.table.getCountPkReferenceQueries(this.getConnection().getMetaData());
        if (MapUtils.isEmpty(countPkReferenceQueries)) {
            return;
        }
        HashSet existingReferenceTables = Sets.newHashSet();
        for (String fkTableName : countPkReferenceQueries.keySet()) {
            String countQuery = countPkReferenceQueries.get(fkTableName);
            long count = this.executeCountQueryByPk(countQuery, pk);
            if (count <= 0L) continue;
            existingReferenceTables.add(fkTableName);
        }
        if (CollectionUtils.isNotEmpty((Collection)existingReferenceTables)) {
            throw new DataIntegrityViolationOnDeleteException(I18n.t((String)"adagio.synchro.synchronize.checkPkNotUsed.error", (Object[])new Object[]{this.table.getName(), SynchroTableMetadata.toPkStr(pk), Joiner.on((char)',').join((Iterable)existingReferenceTables)}), this.table.getName(), SynchroTableMetadata.toPkStr(pk), existingReferenceTables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long executeCountQueryByPk(String countQuery, List<Object> pk) throws SQLException {
        long l;
        HashMap bindings = Maps.newHashMap();
        int i = 1;
        for (Object value : pk) {
            bindings.put("pk" + i, value);
            ++i;
        }
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareAndBindStatement(countQuery, bindings, "countQueryByPk");
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                throw new SynchroTechnicalException(String.format("Invalid count query, because no row are returned [%s]", countQuery));
            }
            Object value = resultSet.getObject(1);
            if (value == null || !(value instanceof Number)) {
                throw new SynchroTechnicalException(String.format("Invalid count query, because not returning a Number value [%s]", countQuery));
            }
            Number count = (Number)value;
            l = count.longValue();
        }
        catch (Throwable throwable) {
            Daos.closeSilently(resultSet);
            Daos.closeSilently(statement);
            throw throwable;
        }
        Daos.closeSilently(resultSet);
        Daos.closeSilently(statement);
        return l;
    }

    private void checkWriteEnable() {
        Preconditions.checkArgument((boolean)this.enableWrite, (Object)"Unable to write data, because the target database is read only.");
    }
}

