/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.swing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.spi.UIHandler;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.editor.FileEditor;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.SimpleTimeEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.swing.editor.cell.NumberCellEditor;
import jaxx.runtime.swing.editor.gis.DmdCoordinateEditor;
import jaxx.runtime.swing.editor.gis.DmsCoordinateEditor;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.swing.renderer.DecoratorTableCellRenderer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationConfiguration;
import org.nuiton.jaxx.application.bean.JavaBeanObjectUtil;
import org.nuiton.jaxx.application.swing.AbstractApplicationFormUIModel;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.ApplicationUIConfiguration;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUI;
import org.nuiton.jaxx.application.swing.action.ApplicationUIAction;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;
import org.nuiton.jaxx.application.swing.util.ApplicationUIUtil;
import org.nuiton.jaxx.application.swing.util.Cancelable;
import org.nuiton.jaxx.application.type.ApplicationProgressionModel;
import org.nuiton.validator.bean.AbstractValidator;
import org.nuiton.validator.bean.list.BeanListValidator;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public abstract class AbstractApplicationUIHandler<M, UI extends ApplicationUI<M, ?>>
implements UIHandler<UI> {
    private static final Log log = LogFactory.getLog(AbstractApplicationUIHandler.class);
    private ApplicationUIContext context;
    protected UI ui;
    private Set<SimpleBeanValidator> simpleValidators;
    private Set<BeanListValidator> listValidators;
    public static final String CONFIRMATION_FORMAT = "<html>%s<hr/><br/>%s</html>";

    public abstract void onCloseUI();

    @Deprecated
    public abstract SwingValidator<M> getValidator();

    public abstract Component getTopestUI();

    public abstract <E> Decorator<E> getDecorator(Class<E> var1, String var2);

    protected void beforeOpenPopup(int modelRowIndex, int modelColumnIndex) {
    }

    @Deprecated
    public DefaultComboBoxModel newComboModel(Object ... items) {
        return SwingUtil.newComboModel((Object[])items);
    }

    public final M getModel() {
        return this.ui.getModel();
    }

    public final UI getUI() {
        return this.ui;
    }

    public Set<SimpleBeanValidator> getSimpleValidators() {
        return this.simpleValidators;
    }

    public Set<BeanListValidator> getListValidators() {
        return this.listValidators;
    }

    public void beforeInit(UI ui) {
        this.ui = ui;
    }

    public ApplicationUIContext getContext() {
        if (this.context == null) {
            this.context = ApplicationUIUtil.getApplicationContext(this.ui);
        }
        return this.context;
    }

    public void setText(KeyEvent event, String property) {
        JTextComponent field = (JTextComponent)event.getSource();
        String value = field.getText();
        JavaBeanObjectUtil.setProperty(this.getModel(), (String)property, (Object)value);
    }

    public void setFile(ActionEvent event, String property) {
        FileEditor field = (FileEditor)event.getSource();
        File value = field.getSelectedFile();
        JavaBeanObjectUtil.setProperty(this.getModel(), (String)property, (Object)value);
    }

    public void setBoolean(ItemEvent event, String property) {
        boolean value = event.getStateChange() == 1;
        JavaBeanObjectUtil.setProperty(this.getModel(), (String)property, (Object)value);
    }

    public void setDate(ActionEvent event, String property) {
        JXDatePicker field = (JXDatePicker)event.getSource();
        Date value = field.getDate();
        JavaBeanObjectUtil.setProperty(this.getModel(), (String)property, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectListData(ListSelectionEvent event, String property) {
        if (!event.getValueIsAdjusting()) {
            JList list = (JList)event.getSource();
            ListSelectionModel selectionModel = list.getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            try {
                LinkedList selectedList = Lists.newLinkedList();
                for (int index : list.getSelectedIndices()) {
                    Object o = list.getModel().getElementAt(index);
                    selectedList.add(o);
                }
                JavaBeanObjectUtil.setProperty(this.getModel(), (String)property, (Object)selectedList);
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }

    public void openDialog(ApplicationUI dialogContent, String title, Dimension dim) {
        Component topestUI = this.getTopestUI();
        JDialog result = topestUI instanceof Frame ? new JDialog((Frame)topestUI, title, true) : new JDialog((Dialog)topestUI, title, true);
        result.add((Component)((Object)dialogContent));
        result.setResizable(true);
        result.setSize(dim);
        Object handler = dialogContent.getHandler();
        if (handler instanceof Cancelable) {
            JRootPane rootPane = result.getRootPane();
            KeyStroke shortcutClosePopup = this.getContext().getConfiguration().getShortcutClosePopup();
            rootPane.getInputMap(2).put(shortcutClosePopup, "close");
            rootPane.getActionMap().put("close", new AbstractAction((AbstractApplicationUIHandler)handler){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ AbstractApplicationUIHandler val$handler;
                {
                    this.val$handler = abstractApplicationUIHandler2;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Cancelable)((Object)this.val$handler)).cancel();
                }
            });
        }
        result.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Component ui = (Component)e.getSource();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Destroy ui " + ui));
                }
                JAXXUtil.destroy((Component)ui);
            }
        });
        SwingUtil.center((Component)this.getContext().getMainUI(), (Component)result);
        result.setVisible(true);
    }

    public void closeDialog() {
        this.getParentContainer(JDialog.class).setVisible(false);
    }

    public <U extends Container> U getParentContainer(Class<U> uiType) {
        return (U)SwingUtil.getParentContainer(this.ui, uiType);
    }

    public int askSaveBeforeLeaving(String message) {
        String htmlMessage = String.format(CONFIRMATION_FORMAT, message, I18n.t((String)"jaxx.application.common.askSaveBeforeLeaving.help", (Object[])new Object[0]));
        int result = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n.t((String)"jaxx.application.common.askSaveBeforeLeaving.title", (Object[])new Object[0]), 1, 3);
        return result;
    }

    public boolean askCancelEditBeforeLeaving(String message) {
        String htmlMessage = String.format(CONFIRMATION_FORMAT, message, I18n.t((String)"jaxx.application.common.askCancelEditBeforeLeaving.help", (Object[])new Object[0]));
        int i = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n.t((String)"jaxx.application.common.askCancelEditBeforeLeaving.title", (Object[])new Object[0]), 2, 3);
        boolean result = i == 0;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSuccessMessage(String title, String message) {
        Component topestUI = this.getTopestUI();
        boolean alwaysOnTop = false;
        if (topestUI instanceof JDialog) {
            alwaysOnTop = ((JDialog)topestUI).isAlwaysOnTop();
        }
        if (alwaysOnTop) {
            ((JDialog)topestUI).setAlwaysOnTop(false);
        }
        try {
            JOptionPane.showMessageDialog(topestUI, message, title, 1, UIManager.getIcon("info"));
        }
        finally {
            if (alwaysOnTop) {
                ((JDialog)topestUI).setAlwaysOnTop(true);
            }
        }
    }

    protected void addHighlighters(JXTable table) {
    }

    public void autoSelectRowInTable(MouseEvent e, JPopupMenu popup) {
        boolean rightClick = SwingUtilities.isRightMouseButton(e);
        if (rightClick || SwingUtilities.isLeftMouseButton(e)) {
            boolean stopEdit;
            Point p = e.getPoint();
            JXTable source = (JXTable)e.getSource();
            int[] selectedRows = source.getSelectedRows();
            int[] selectedColumns = source.getSelectedColumns();
            int rowIndex = source.rowAtPoint(p);
            int columnIndex = source.columnAtPoint(p);
            if (log.isDebugEnabled()) {
                log.debug((Object)("At point [" + p + "] found Row " + rowIndex + ", Column " + columnIndex));
            }
            boolean canContinue = true;
            if (source.isEditing() && !(stopEdit = source.getCellEditor().stopCellEditing())) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Could not stop edit cell...");
                }
                canContinue = false;
            }
            if (canContinue) {
                if (rowIndex == -1) {
                    source.clearSelection();
                } else if (!ArrayUtils.contains((int[])selectedRows, (int)rowIndex)) {
                    if (2 == source.getSelectionMode()) {
                        source.addRowSelectionInterval(rowIndex, rowIndex);
                    } else {
                        source.setRowSelectionInterval(rowIndex, rowIndex);
                    }
                }
                if (columnIndex == -1) {
                    source.clearSelection();
                } else if (!ArrayUtils.contains((int[])selectedColumns, (int)columnIndex)) {
                    source.setColumnSelectionInterval(columnIndex, columnIndex);
                }
                if (rightClick) {
                    int modelRowIndex = rowIndex == -1 ? -1 : source.convertRowIndexToModel(rowIndex);
                    int modelColumnIndex = columnIndex == -1 ? -1 : source.convertColumnIndexToModel(columnIndex);
                    this.beforeOpenPopup(modelRowIndex, modelColumnIndex);
                    popup.show((Component)source, e.getX(), e.getY());
                }
            }
        }
    }

    public void openRowMenu(KeyEvent e, JPopupMenu popup) {
        if (e.getKeyCode() == 525) {
            boolean stopEdit;
            JXTable source = (JXTable)e.getSource();
            int[] selectedRows = source.getSelectedRows();
            int lowestRow = -1;
            for (int row : selectedRows) {
                lowestRow = Math.max(lowestRow, row);
            }
            int selectedColumn = source.getSelectedColumn();
            Rectangle r = source.getCellRect(lowestRow, selectedColumn, true);
            Point p = new Point(r.x + r.width / 2, r.y + r.height);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Row " + lowestRow + " found t point [" + p + "]"));
            }
            boolean canContinue = true;
            if (source.isEditing() && !(stopEdit = source.getCellEditor().stopCellEditing())) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Could not stop edit cell...");
                }
                canContinue = false;
            }
            if (canContinue) {
                int rowIndex = source.convertRowIndexToModel(lowestRow);
                int columnIndex = source.convertColumnIndexToModel(selectedColumn);
                this.beforeOpenPopup(rowIndex, columnIndex);
                popup.show((Component)source, p.x, p.y);
            }
        }
    }

    protected void initUIComponent(Object component) {
        if (component instanceof NumberEditor) {
            this.initNumberEditor((NumberEditor)component);
        } else if (component instanceof JXDatePicker) {
            this.initDatePicker((JXDatePicker)component);
        } else if (component instanceof SimpleTimeEditor) {
            this.initTimeEditor((SimpleTimeEditor)component);
        } else if (component instanceof JLabel) {
            this.initLabel((JLabel)component);
        } else if (component instanceof JTextField) {
            this.initTextField((JTextField)component);
        } else if (component instanceof AbstractButton) {
            this.initButton((AbstractButton)component);
        } else if (component instanceof JScrollPane) {
            this.initScrollPane((JScrollPane)component);
        } else if (component instanceof DmsCoordinateEditor) {
            this.initCoordinateDMSEditor((DmsCoordinateEditor)component);
        } else if (component instanceof DmdCoordinateEditor) {
            this.initCoordinateDMDEditor((DmdCoordinateEditor)component);
        } else if (component instanceof SimpleBeanValidator) {
            this.simpleValidators.add((SimpleBeanValidator)component);
        } else if (component instanceof BeanListValidator) {
            this.listValidators.add((BeanListValidator)component);
        }
    }

    protected void initUI(UI ui) {
        this.simpleValidators = Sets.newHashSet();
        this.listValidators = Sets.newHashSet();
        for (Map.Entry entry : ui.get$objectMap().entrySet()) {
            Object component = entry.getValue();
            this.initUIComponent(component);
        }
        this.simpleValidators = Collections.unmodifiableSet(this.simpleValidators);
        this.listValidators = Collections.unmodifiableSet(this.listValidators);
        this.initValidators(this.simpleValidators, this.listValidators);
        this.initComponentToFocus((Component)ui);
    }

    protected void initComponentToFocus(Component ui) {
        ui.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                JComponent component = AbstractApplicationUIHandler.this.getComponentToFocus();
                if ((e.getChangeFlags() & 4L) > 0L && e.getChanged().isShowing() && component != null) {
                    component.requestFocus();
                }
            }
        });
    }

    protected abstract JComponent getComponentToFocus();

    protected void initTextField(JTextField jTextField) {
        if (this.isAutoSelectOnFocus(jTextField)) {
            this.addAutoSelectOnFocus(jTextField);
        }
    }

    protected void initLabel(JLabel jLabel) {
    }

    protected void initButton(AbstractButton abstractButton) {
        String key;
        Class actionName = (Class)abstractButton.getClientProperty("applicationAction");
        if (actionName != null) {
            ApplicationUIAction action = this.getContext().getActionFactory().createUIAction(this, abstractButton, actionName);
            abstractButton.setAction(action);
        }
        if (abstractButton.getAction() != null && (key = (String)abstractButton.getClientProperty("applicationActionKey")) != null) {
            this.affectKeyStroke(abstractButton, key);
        }
    }

    protected void affectKeyStroke(AbstractButton abstractButton, String key) {
        if (abstractButton.getAction() == null) {
            log.warn((Object)("the buton '" + abstractButton.getName() + "' has no action. can't affect key stroke."));
            return;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(key);
        if (keyStroke == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not transform keyStroke: " + key));
            }
        } else {
            abstractButton.getInputMap(2).put(keyStroke, key);
            abstractButton.getActionMap().put(key, abstractButton.getAction());
            boolean modifyText = true;
            boolean modifyTip = false;
            ApplicationConfiguration configuration = this.context.getConfiguration();
            if (configuration instanceof ApplicationUIConfiguration) {
                ApplicationUIConfiguration applicationUIConfiguration = (ApplicationUIConfiguration)configuration;
                modifyText = applicationUIConfiguration.isShowKeyStrokeOnText();
                modifyTip = applicationUIConfiguration.isShowKeyStrokeOnTip();
            }
            String text = abstractButton.getText();
            if (modifyText && !StringUtils.isBlank((CharSequence)text)) {
                text = text + " (" + key.toUpperCase() + ")";
                abstractButton.setText(text);
            }
            String tip = abstractButton.getToolTipText();
            if (modifyTip && !StringUtils.isBlank((CharSequence)tip)) {
                tip = tip + " (" + key.toUpperCase() + ")";
                abstractButton.setToolTipText(tip);
            }
        }
    }

    protected <E> void initBeanFilterableComboBox(BeanFilterableComboBox<E> comboBox, List<E> data, E selectedData) {
        this.initBeanFilterableComboBox(comboBox, data, selectedData, null);
    }

    protected <E> void initBeanFilterableComboBox(BeanFilterableComboBox<E> comboBox, List<E> data, E selectedData, String decoratorContext) {
        Preconditions.checkNotNull(comboBox, (Object)"No comboBox!");
        Class beanType = comboBox.getBeanType();
        Preconditions.checkNotNull((Object)beanType, (Object)"No beanType on the combobox!");
        Decorator<E> decorator = this.getDecorator(beanType, decoratorContext);
        if (data == null) {
            data = Lists.newArrayList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("entity comboBox list [" + beanType.getName() + "] : " + data.size()));
        }
        comboBox.setI18nPrefix(this.getContext().getI18nPrefix());
        comboBox.init((JXPathDecorator)decorator, (List)data);
        comboBox.setSelectedItem(selectedData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("combo [" + beanType.getName() + "] : " + comboBox.getData().size()));
        }
    }

    protected <E> void initBeanComboBox(BeanComboBox<E> comboBox, List<E> data, E selectedData) {
        this.initBeanComboBox(comboBox, data, selectedData, null);
    }

    protected <E> void initBeanComboBox(BeanComboBox<E> comboBox, List<E> data, E selectedData, String decoratorContext) {
        Preconditions.checkNotNull(comboBox, (Object)"No comboBox!");
        Class beanType = comboBox.getBeanType();
        Preconditions.checkNotNull((Object)beanType, (Object)"No beanType on the combobox!");
        Decorator<E> decorator = this.getDecorator(beanType, decoratorContext);
        if (data == null) {
            data = Lists.newArrayList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("entity comboBox list [" + beanType.getName() + "] : " + data.size()));
        }
        comboBox.setI18nPrefix(this.getContext().getI18nPrefix());
        comboBox.init((JXPathDecorator)decorator, (List)data);
        comboBox.setSelectedItem(selectedData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("combo [" + beanType.getName() + "] : " + comboBox.getData().size()));
        }
    }

    protected <E> void initBeanList(BeanDoubleList<E> list, List<E> data, List<E> selectedData, Decorator<E> selectedDecorator) {
        Preconditions.checkNotNull(list, (Object)"No list!");
        Class beanType = list.getBeanType();
        Preconditions.checkNotNull((Object)beanType, (Object)"No beanType on the double list!");
        Decorator<E> decorator = this.getDecorator(beanType, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("entity list [" + beanType.getName() + "] : " + (data == null ? 0 : data.size())));
        }
        list.setI18nPrefix(this.getContext().getI18nPrefix());
        list.init((JXPathDecorator)decorator, (JXPathDecorator)selectedDecorator, data, selectedData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Jlist [" + beanType.getName() + "] : " + list.getUniverseList().getModel().getSize()));
        }
    }

    protected <E> void initBeanList(BeanDoubleList<E> list, List<E> data, List<E> selectedData) {
        this.initBeanList(list, data, selectedData, null);
    }

    protected void initNumberEditor(NumberEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init number editor " + editor.getName()));
        }
        editor.init();
        Number model = editor.getModel();
        if (model != null) {
            editor.setModel(null);
            editor.setModel(model);
        }
        if (this.isAutoSelectOnFocus((JComponent)editor)) {
            this.addAutoSelectOnFocus(editor.getTextField());
        }
    }

    protected void initTimeEditor(SimpleTimeEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init time editor " + editor.getName() + " for property " + editor.getModel().getProperty()));
        }
        editor.init();
        if (this.isAutoSelectOnFocus((JComponent)editor)) {
            this.addAutoSelectOnFocus(((JSpinner.DefaultEditor)editor.getHour().getEditor()).getTextField());
            this.addAutoSelectOnFocus(((JSpinner.DefaultEditor)editor.getMinute().getEditor()).getTextField());
        }
    }

    protected void initCoordinateDMSEditor(DmsCoordinateEditor editor) {
        Object property = editor.getClientProperty((Object)"longitudeEditor");
        boolean longitudeEditor = property != null && Boolean.valueOf(property.toString()) != false;
        editor.init(longitudeEditor);
    }

    protected void initCoordinateDMDEditor(DmdCoordinateEditor editor) {
        Object property = editor.getClientProperty((Object)"longitudeEditor");
        boolean longitudeEditor = property != null && Boolean.valueOf(property.toString()) != false;
        editor.init(longitudeEditor);
    }

    protected void initDatePicker(final JXDatePicker picker) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("disable JXDatePicker editor" + picker.getName()));
        }
        String dateFormat = this.getContext().getDateFormat();
        picker.setFormats(new String[]{dateFormat});
        picker.setToolTipText(I18n.t((String)"jaxx.application.common.datefield.tip", (Object[])new Object[]{dateFormat}));
        picker.getEditor().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    picker.commitEdit();
                }
                catch (ParseException ex) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"format error", (Throwable)ex);
                    }
                    picker.requestFocus();
                }
            }
        });
        if (this.isAutoSelectOnFocus((JComponent)picker)) {
            this.addAutoSelectOnFocus(picker.getEditor());
        }
    }

    protected void initScrollPane(JScrollPane scrollPane) {
        Boolean onlyVerticalScrollable = (Boolean)scrollPane.getClientProperty("onlyVerticalScrollable");
        if (onlyVerticalScrollable != null && onlyVerticalScrollable.booleanValue()) {
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setVerticalScrollBarPolicy(20);
            final JViewport viewport = scrollPane.getViewport();
            viewport.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Dimension newDimension = new Dimension(viewport.getExtentSize().width, viewport.getViewSize().height);
                    viewport.setViewSize(newDimension);
                }
            });
        }
    }

    protected void initValidators(Set<SimpleBeanValidator> simpleValidators, Set<BeanListValidator> listValidators) {
        M model = this.getModel();
        if (this.useSimpleValidators() || this.useListValidators()) {
            HashSet validators = Sets.newHashSet();
            validators.addAll(simpleValidators);
            validators.addAll(listValidators);
            ValidatorsValidPropertyChangeListener listener = new ValidatorsValidPropertyChangeListener((AbstractApplicationFormUIModel)((Object)model), validators);
            for (AbstractValidator validator : validators) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Listen valid state of validator: " + validator));
                }
                validator.addPropertyChangeListener("valid", (PropertyChangeListener)listener);
            }
        }
    }

    protected boolean useListValidators() {
        return this.getModel() instanceof AbstractApplicationFormUIModel && !this.listValidators.isEmpty();
    }

    protected boolean useSimpleValidators() {
        return this.getModel() instanceof AbstractApplicationFormUIModel && !this.simpleValidators.isEmpty();
    }

    protected boolean isAutoSelectOnFocus(JComponent comp) {
        Object selectOnFocus = comp.getClientProperty("selectOnFocus");
        return selectOnFocus != null && Boolean.valueOf(selectOnFocus.toString()) != false;
    }

    protected void addAutoSelectOnFocus(JTextField jTextField) {
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(final FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField source = (JTextField)e.getSource();
                        source.selectAll();
                    }
                });
            }
        });
    }

    @Deprecated
    protected boolean quitScreen(boolean modelIsValid, boolean modelIsModify, String askGiveUpMessage, String askSaveMessage, Action saveAction) {
        boolean result = this.quitScreen(modelIsValid, modelIsModify, askGiveUpMessage, askSaveMessage, saveAction, false);
        return result;
    }

    @Deprecated
    protected boolean quitInternalScreen(boolean modelIsValid, boolean modelIsModify, String askGiveUpMessage, String askSaveMessage, Action saveAction) {
        boolean result = this.quitScreen(modelIsValid, modelIsModify, askGiveUpMessage, askSaveMessage, saveAction, true);
        return result;
    }

    protected boolean quitScreen(boolean modelIsValid, boolean modelIsModify, String askGiveUpMessage, String askSaveMessage, Action saveAction, boolean runInternal) {
        boolean result;
        if (!modelIsValid) {
            result = this.askCancelEditBeforeLeaving(askGiveUpMessage);
        } else if (modelIsModify) {
            int answer = this.askSaveBeforeLeaving(askSaveMessage);
            switch (answer) {
                case 0: {
                    if (runInternal) {
                        ApplicationUIAction uiAction = (ApplicationUIAction)saveAction;
                        this.getContext().getActionEngine().runFullInternalAction(uiAction.getLogicAction());
                    } else {
                        saveAction.actionPerformed(null);
                    }
                    result = true;
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    protected String decorate(Serializable object) {
        return this.decorate(object, null);
    }

    protected String decorate(Serializable object, String context) {
        String result = "";
        if (object != null) {
            result = this.getDecorator(object.getClass(), context).toString((Object)object);
        }
        return result;
    }

    protected <O> ListCellRenderer newListCellRender(Class<O> type) {
        return this.newListCellRender(type, null);
    }

    protected <O> ListCellRenderer newListCellRender(Class<O> type, String name) {
        Decorator<O> decorator = this.getDecorator(type, name);
        return this.newListCellRender(decorator);
    }

    protected <O> ListCellRenderer newListCellRender(Decorator<O> decorator) {
        Preconditions.checkNotNull(decorator);
        DecoratorListCellRenderer result = new DecoratorListCellRenderer(decorator);
        return result;
    }

    protected <B> void changeValidatorContext(String newContext, SwingValidator<B> validator) {
        Object bean = validator.getBean();
        validator.setContext(newContext);
        validator.setBean(bean);
    }

    protected <R> TableColumnExt addColumnToModel(TableColumnModel model, TableCellEditor editor, TableCellRenderer renderer, ColumnIdentifier<R> identifier) {
        TableColumnExt col = new TableColumnExt(model.getColumnCount());
        col.setCellEditor(editor);
        col.setCellRenderer(renderer);
        String label = I18n.t((String)identifier.getHeaderI18nKey(), (Object[])new Object[0]);
        col.setHeaderValue((Object)label);
        String tip = I18n.t((String)identifier.getHeaderTipI18nKey(), (Object[])new Object[0]);
        col.setToolTipText(tip);
        col.setIdentifier(identifier);
        model.addColumn((TableColumn)col);
        col.setSortable(false);
        return col;
    }

    protected <R> TableColumnExt addColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier) {
        return this.addColumnToModel(model, null, null, identifier);
    }

    protected <R> TableColumnExt addFloatColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, String numberPattern, boolean sign, JTable table) {
        NumberCellEditor editor = JAXXWidgetUtil.newNumberTableCellEditor(Float.class, (boolean)sign);
        editor.getNumberEditor().setSelectAllTextOnError(Boolean.valueOf(true));
        editor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
        editor.getNumberEditor().setNumberPattern(numberPattern);
        TableCellRenderer renderer = this.newNumberCellRenderer(table.getDefaultRenderer(Number.class));
        return this.addColumnToModel(model, (TableCellEditor)editor, renderer, identifier);
    }

    protected <R> TableColumnExt addFloatColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, String numberPattern, JTable table) {
        return this.addFloatColumnToModel(model, identifier, numberPattern, false, table);
    }

    protected <R> TableColumnExt addIntegerColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, String numberPattern, boolean sign, JTable table) {
        NumberCellEditor editor = JAXXWidgetUtil.newNumberTableCellEditor(Integer.class, (boolean)sign);
        editor.getNumberEditor().setSelectAllTextOnError(Boolean.valueOf(true));
        editor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
        editor.getNumberEditor().setNumberPattern(numberPattern);
        TableCellRenderer renderer = this.newNumberCellRenderer(table.getDefaultRenderer(Number.class));
        return this.addColumnToModel(model, (TableCellEditor)editor, renderer, identifier);
    }

    protected <R> TableColumnExt addIntegerColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, String numberPattern, JTable table) {
        return this.addIntegerColumnToModel(model, identifier, numberPattern, false, table);
    }

    protected TableCellRenderer newNumberCellRenderer(final TableCellRenderer defaultRenderer) {
        TableCellRenderer result = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component result = defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (result instanceof JLabel) {
                    JLabel jLabel = (JLabel)result;
                    jLabel.setHorizontalTextPosition(4);
                }
                return result;
            }
        };
        return result;
    }

    protected <R> TableColumnExt addBooleanColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, JTable table) {
        return this.addColumnToModel(model, table.getDefaultEditor(Boolean.class), table.getDefaultRenderer(Boolean.class), identifier);
    }

    protected <R, B> TableColumnExt addComboDataColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, Decorator<B> decorator, List<B> data) {
        JComboBox comboBox = new JComboBox();
        comboBox.setRenderer(this.newListCellRender(decorator));
        ArrayList dataToList = Lists.newArrayList(data);
        if (!dataToList.isEmpty() && dataToList.get(0) != null) {
            dataToList.add(0, null);
        }
        SwingUtil.fillComboBox(comboBox, (Collection)dataToList, null);
        ObjectToStringConverter converter = BeanUIUtil.newDecoratedObjectToStringConverter(decorator);
        BeanUIUtil.decorate(comboBox, (ObjectToStringConverter)converter);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(comboBox);
        return this.addColumnToModel(model, (TableCellEditor)editor, this.newTableCellRender(decorator), identifier);
    }

    protected <O> TableCellRenderer newTableCellRender(Class<O> type) {
        return this.newTableCellRender(type, null);
    }

    protected <O> TableCellRenderer newTableCellRender(Class<O> type, String name) {
        Decorator<O> decorator = this.getDecorator(type, name);
        TableCellRenderer result = this.newTableCellRender(decorator);
        return result;
    }

    protected <O> TableCellRenderer newTableCellRender(Decorator<O> decorator) {
        Preconditions.checkNotNull(decorator);
        DecoratorTableCellRenderer result = new DecoratorTableCellRenderer(decorator, true);
        return result;
    }

    protected void incrementsMessage(String message) {
        ApplicationProgressionModel progressionModel;
        ApplicationActionUI actionUI = this.getContext().getActionUI();
        if (actionUI != null && (progressionModel = actionUI.getModel().getProgressionModel()) != null) {
            progressionModel.increments(message);
        }
    }

    protected static class RunFullInternalActionListener
    implements PropertyChangeListener {
        private final ApplicationUIContext context;
        private final AbstractApplicationAction uiAction;

        public RunFullInternalActionListener(ApplicationUIContext context, AbstractApplicationUIHandler handler, Class actionName) {
            this.context = context;
            this.uiAction = context.getActionFactory().createLogicAction(handler, actionName);
        }

        protected boolean doPropertyChange(PropertyChangeEvent evt) {
            return true;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean doPropertyChange = this.doPropertyChange(evt);
            if (doPropertyChange) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Execute action start: " + (Object)((Object)this.uiAction)));
                }
                this.context.getActionEngine().runFullInternalAction(this.uiAction);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Execute action end: " + (Object)((Object)this.uiAction)));
                }
            }
        }
    }

    private static class ValidatorsValidPropertyChangeListener
    implements PropertyChangeListener {
        private final AbstractApplicationFormUIModel model;
        private final Set<AbstractValidator> validators;

        public ValidatorsValidPropertyChangeListener(AbstractApplicationFormUIModel model, Set<AbstractValidator> validators) {
            this.model = model;
            this.validators = validators;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean valid = true;
            for (AbstractValidator validator : this.validators) {
                if (validator.isValid()) continue;
                valid = false;
                break;
            }
            this.model.setValid(valid);
        }
    }
}

