/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.converter;

import javax.swing.KeyStroke;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.converter.NuitonConverter;

public class KeyStrokeConverter
implements NuitonConverter<KeyStroke> {
    private static final Log LOGGER = LogFactory.getLog(KeyStrokeConverter.class);

    public <T> T convert(Class<T> aClass, Object value) {
        if (value == null) {
            throw new ConversionException(String.format("No value specified for converter %s", this));
        }
        if (this.isEnabled(aClass)) {
            if (this.isEnabled(value.getClass())) {
                Object result = value;
                return aClass.cast(result);
            }
            if (value instanceof String) {
                KeyStroke result = KeyStroke.getKeyStroke((String)value);
                return aClass.cast(result);
            }
        }
        throw new ConversionException(String.format("no convertor found for type %2$s and objet '%1$s'", aClass.getName(), value));
    }

    protected boolean isEnabled(Class<?> aClass) {
        return KeyStroke.class.equals(aClass);
    }

    @Override
    public Class<KeyStroke> getType() {
        return KeyStroke.class;
    }

    public KeyStrokeConverter() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("init keystroke converter " + this));
        }
    }
}

