/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltInsForDates;
import freemarker.core.BuiltInsForHashes;
import freemarker.core.BuiltInsForMultipleTypes;
import freemarker.core.BuiltInsForNodes;
import freemarker.core.BuiltInsForNumbers;
import freemarker.core.BuiltInsForSequences;
import freemarker.core.BuiltInsForStringsBasic;
import freemarker.core.BuiltInsForStringsEncoding;
import freemarker.core.BuiltInsForStringsMisc;
import freemarker.core.BuiltInsForStringsRegexp;
import freemarker.core.EvalUtil;
import freemarker.core.ExistenceBuiltins;
import freemarker.core.Expression;
import freemarker.core.ICIChainMember;
import freemarker.core.Interpret;
import freemarker.core.MessageUtil;
import freemarker.core.NewBI;
import freemarker.core.ParameterRole;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

abstract class BuiltIn
extends Expression
implements Cloneable {
    protected Expression target;
    protected String key;
    static final HashMap builtins = new HashMap();

    BuiltIn() {
    }

    static BuiltIn newBuiltIn(int incompatibleImprovements, Expression target, String key) throws ParseException {
        BuiltIn bi = (BuiltIn)builtins.get(key);
        if (bi == null) {
            StringBuffer buf = new StringBuffer("Unknown built-in: " + StringUtil.jQuote(key) + ". " + "Help (latest version): http://freemarker.org/docs/ref_builtins.html; " + "you're using FreeMarker " + Configuration.getVersion() + ".\n" + "The alphabetical list of built-ins:");
            ArrayList names = new ArrayList(builtins.keySet().size());
            names.addAll(builtins.keySet());
            Collections.sort(names);
            char lastLetter = '\u0000';
            Iterator it = names.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                char firstChar = name.charAt(0);
                if (firstChar != lastLetter) {
                    lastLetter = firstChar;
                    buf.append('\n');
                }
                buf.append(name);
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
            throw new ParseException(buf.toString(), target);
        }
        while (bi instanceof ICIChainMember && incompatibleImprovements < ((ICIChainMember)((Object)bi)).getMinimumICIVersion()) {
            bi = (BuiltIn)((ICIChainMember)((Object)bi)).getPreviousICIChainMember();
        }
        try {
            bi = (BuiltIn)bi.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        bi.target = target;
        bi.key = key;
        return bi;
    }

    public String getCanonicalForm() {
        return this.target.getCanonicalForm() + this.getNodeTypeSymbol();
    }

    String getNodeTypeSymbol() {
        return "?" + this.key;
    }

    boolean isLiteral() {
        return false;
    }

    protected final void checkMethodArgCount(List args, int expectedCnt) throws TemplateModelException {
        this.checkMethodArgCount(args.size(), expectedCnt);
    }

    protected final void checkMethodArgCount(int argCnt, int expectedCnt) throws TemplateModelException {
        if (argCnt != expectedCnt) {
            throw MessageUtil.newArgCntError("?" + this.key, argCnt, expectedCnt);
        }
    }

    protected final void checkMethodArgCount(List args, int minCnt, int maxCnt) throws TemplateModelException {
        this.checkMethodArgCount(args.size(), minCnt, maxCnt);
    }

    protected final void checkMethodArgCount(int argCnt, int minCnt, int maxCnt) throws TemplateModelException {
        if (argCnt < minCnt || argCnt > maxCnt) {
            throw MessageUtil.newArgCntError("?" + this.key, argCnt, minCnt, maxCnt);
        }
    }

    protected final String getOptStringMethodArg(List args, int argIdx) throws TemplateModelException {
        return args.size() > argIdx ? this.getStringMethodArg(args, argIdx) : null;
    }

    protected final String getStringMethodArg(List args, int argIdx) throws TemplateModelException {
        TemplateModel arg = (TemplateModel)args.get(argIdx);
        if (!(arg instanceof TemplateScalarModel)) {
            throw MessageUtil.newMethodArgMustBeStringException("?" + this.key, argIdx, arg);
        }
        return EvalUtil.modelToString((TemplateScalarModel)arg, null, null);
    }

    protected final Number getNumberMethodArg(List args, int argIdx) throws TemplateModelException {
        TemplateModel arg = (TemplateModel)args.get(argIdx);
        if (!(arg instanceof TemplateNumberModel)) {
            throw MessageUtil.newMethodArgMustBeNumberException("?" + this.key, argIdx, arg);
        }
        return EvalUtil.modelToNumber((TemplateNumberModel)arg, null);
    }

    protected final TemplateModelException newMethodArgInvalidValueException(int argIdx, Object[] details) {
        return MessageUtil.newMethodArgInvalidValueException("?" + this.key, argIdx, details);
    }

    protected final TemplateModelException newMethodArgsInvalidValueException(Object[] details) {
        return MessageUtil.newMethodArgsInvalidValueException("?" + this.key, details);
    }

    protected final Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        try {
            BuiltIn clone = (BuiltIn)this.clone();
            clone.target = this.target.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Internal error: " + e);
        }
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.target;
            }
            case 1: {
                return this.key;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.LEFT_HAND_OPERAND;
            }
            case 1: {
                return ParameterRole.RIGHT_HAND_OPERAND;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    static {
        builtins.put("abs", new BuiltInsForNumbers.absBI());
        builtins.put("ancestors", new BuiltInsForNodes.ancestorsBI());
        builtins.put("boolean", new BuiltInsForStringsMisc.booleanBI());
        builtins.put("byte", new BuiltInsForNumbers.byteBI());
        builtins.put("c", new BuiltInsForMultipleTypes.cBI());
        builtins.put("cap_first", new BuiltInsForStringsBasic.cap_firstBI());
        builtins.put("capitalize", new BuiltInsForStringsBasic.capitalizeBI());
        builtins.put("ceiling", new BuiltInsForNumbers.ceilingBI());
        builtins.put("children", new BuiltInsForNodes.childrenBI());
        builtins.put("chop_linebreak", new BuiltInsForStringsBasic.chop_linebreakBI());
        builtins.put("contains", new BuiltInsForStringsBasic.containsBI());
        builtins.put("date", new BuiltInsForMultipleTypes.dateBI(2));
        builtins.put("date_if_unknown", new BuiltInsForDates.dateType_if_unknownBI(2));
        builtins.put("datetime", new BuiltInsForMultipleTypes.dateBI(3));
        builtins.put("datetime_if_unknown", new BuiltInsForDates.dateType_if_unknownBI(3));
        builtins.put("default", new ExistenceBuiltins.defaultBI());
        builtins.put("double", new BuiltInsForNumbers.doubleBI());
        builtins.put("ends_with", new BuiltInsForStringsBasic.ends_withBI());
        builtins.put("ensure_ends_with", new BuiltInsForStringsBasic.ensure_ends_withBI());
        builtins.put("ensure_starts_with", new BuiltInsForStringsBasic.ensure_starts_withBI());
        builtins.put("eval", new BuiltInsForStringsMisc.evalBI());
        builtins.put("exists", new ExistenceBuiltins.existsBI());
        builtins.put("first", new BuiltInsForSequences.firstBI());
        builtins.put("float", new BuiltInsForNumbers.floatBI());
        builtins.put("floor", new BuiltInsForNumbers.floorBI());
        builtins.put("chunk", new BuiltInsForSequences.chunkBI());
        builtins.put("has_content", new ExistenceBuiltins.has_contentBI());
        builtins.put("html", new BuiltInsForStringsEncoding.htmlBI());
        builtins.put("if_exists", new ExistenceBuiltins.if_existsBI());
        builtins.put("index_of", new BuiltInsForStringsBasic.index_ofBI(false));
        builtins.put("int", new BuiltInsForNumbers.intBI());
        builtins.put("interpret", new Interpret());
        builtins.put("is_boolean", new BuiltInsForMultipleTypes.is_booleanBI());
        builtins.put("is_collection", new BuiltInsForMultipleTypes.is_collectionBI());
        BuiltInsForMultipleTypes.is_dateLikeBI bi = new BuiltInsForMultipleTypes.is_dateLikeBI();
        builtins.put("is_date", bi);
        builtins.put("is_date_like", bi);
        builtins.put("is_date_only", new BuiltInsForMultipleTypes.is_dateOfTypeBI(2));
        builtins.put("is_unknown_date_like", new BuiltInsForMultipleTypes.is_dateOfTypeBI(0));
        builtins.put("is_datetime", new BuiltInsForMultipleTypes.is_dateOfTypeBI(3));
        builtins.put("is_directive", new BuiltInsForMultipleTypes.is_directiveBI());
        builtins.put("is_enumerable", new BuiltInsForMultipleTypes.is_enumerableBI());
        builtins.put("is_hash_ex", new BuiltInsForMultipleTypes.is_hash_exBI());
        builtins.put("is_hash", new BuiltInsForMultipleTypes.is_hashBI());
        builtins.put("is_infinite", new BuiltInsForNumbers.is_infiniteBI());
        builtins.put("is_indexable", new BuiltInsForMultipleTypes.is_indexableBI());
        builtins.put("is_macro", new BuiltInsForMultipleTypes.is_macroBI());
        builtins.put("is_method", new BuiltInsForMultipleTypes.is_methodBI());
        builtins.put("is_nan", new BuiltInsForNumbers.is_nanBI());
        builtins.put("is_node", new BuiltInsForMultipleTypes.is_nodeBI());
        builtins.put("is_number", new BuiltInsForMultipleTypes.is_numberBI());
        builtins.put("is_sequence", new BuiltInsForMultipleTypes.is_sequenceBI());
        builtins.put("is_string", new BuiltInsForMultipleTypes.is_stringBI());
        builtins.put("is_time", new BuiltInsForMultipleTypes.is_dateOfTypeBI(1));
        builtins.put("is_transform", new BuiltInsForMultipleTypes.is_transformBI());
        builtins.put("iso_utc", new BuiltInsForDates.iso_utc_or_local_BI(null, 6, true));
        builtins.put("iso_utc_fz", new BuiltInsForDates.iso_utc_or_local_BI(Boolean.TRUE, 6, true));
        builtins.put("iso_utc_nz", new BuiltInsForDates.iso_utc_or_local_BI(Boolean.FALSE, 6, true));
        builtins.put("iso_utc_ms", new BuiltInsForDates.iso_utc_or_local_BI(null, 7, true));
        builtins.put("iso_utc_ms_nz", new BuiltInsForDates.iso_utc_or_local_BI(Boolean.FALSE, 7, true));
        builtins.put("iso_utc_m", new BuiltInsForDates.iso_utc_or_local_BI(null, 5, true));
        builtins.put("iso_utc_m_nz", new BuiltInsForDates.iso_utc_or_local_BI(Boolean.FALSE, 5, true));
        builtins.put("iso_utc_h", new BuiltInsForDates.iso_utc_or_local_BI(null, 4, true));
        builtins.put("iso_utc_h_nz", new BuiltInsForDates.iso_utc_or_local_BI(Boolean.FALSE, 4, true));
        builtins.put("iso_local", new BuiltInsForDates.iso_utc_or_local_BI(null, 6, false));
        builtins.put("iso_local_nz", new BuiltInsForDates.iso_utc_or_local_BI(Boolean.FALSE, 6, false));
        builtins.put("iso_local_ms", new BuiltInsForDates.iso_utc_or_local_BI(null, 7, false));
        builtins.put("iso_local_ms_nz", new BuiltInsForDates.iso_utc_or_local_BI(Boolean.FALSE, 7, false));
        builtins.put("iso_local_m", new BuiltInsForDates.iso_utc_or_local_BI(null, 5, false));
        builtins.put("iso_local_m_nz", new BuiltInsForDates.iso_utc_or_local_BI(Boolean.FALSE, 5, false));
        builtins.put("iso_local_h", new BuiltInsForDates.iso_utc_or_local_BI(null, 4, false));
        builtins.put("iso_local_h_nz", new BuiltInsForDates.iso_utc_or_local_BI(Boolean.FALSE, 4, false));
        builtins.put("iso", new BuiltInsForDates.iso_BI(null, 6));
        builtins.put("iso_nz", new BuiltInsForDates.iso_BI(Boolean.FALSE, 6));
        builtins.put("iso_ms", new BuiltInsForDates.iso_BI(null, 7));
        builtins.put("iso_ms_nz", new BuiltInsForDates.iso_BI(Boolean.FALSE, 7));
        builtins.put("iso_m", new BuiltInsForDates.iso_BI(null, 5));
        builtins.put("iso_m_nz", new BuiltInsForDates.iso_BI(Boolean.FALSE, 5));
        builtins.put("iso_h", new BuiltInsForDates.iso_BI(null, 4));
        builtins.put("iso_h_nz", new BuiltInsForDates.iso_BI(Boolean.FALSE, 4));
        builtins.put("j_string", new BuiltInsForStringsEncoding.j_stringBI());
        builtins.put("join", new BuiltInsForSequences.joinBI());
        builtins.put("js_string", new BuiltInsForStringsEncoding.js_stringBI());
        builtins.put("json_string", new BuiltInsForStringsEncoding.json_stringBI());
        builtins.put("keep_after", new BuiltInsForStringsBasic.keep_afterBI());
        builtins.put("keep_before", new BuiltInsForStringsBasic.keep_beforeBI());
        builtins.put("keys", new BuiltInsForHashes.keysBI());
        builtins.put("last_index_of", new BuiltInsForStringsBasic.index_ofBI(true));
        builtins.put("last", new BuiltInsForSequences.lastBI());
        builtins.put("left_pad", new BuiltInsForStringsBasic.padBI(true));
        builtins.put("length", new BuiltInsForStringsBasic.lengthBI());
        builtins.put("long", new BuiltInsForNumbers.longBI());
        builtins.put("lower_case", new BuiltInsForStringsBasic.lower_caseBI());
        builtins.put("namespace", new BuiltInsForMultipleTypes.namespaceBI());
        builtins.put("new", new NewBI());
        builtins.put("node_name", new BuiltInsForNodes.node_nameBI());
        builtins.put("node_namespace", new BuiltInsForNodes.node_namespaceBI());
        builtins.put("node_type", new BuiltInsForNodes.node_typeBI());
        builtins.put("number", new BuiltInsForStringsMisc.numberBI());
        builtins.put("number_to_date", new BuiltInsForNumbers.number_to_dateBI(2));
        builtins.put("number_to_time", new BuiltInsForNumbers.number_to_dateBI(1));
        builtins.put("number_to_datetime", new BuiltInsForNumbers.number_to_dateBI(3));
        builtins.put("parent", new BuiltInsForNodes.parentBI());
        builtins.put("reverse", new BuiltInsForSequences.reverseBI());
        builtins.put("right_pad", new BuiltInsForStringsBasic.padBI(false));
        builtins.put("root", new BuiltInsForNodes.rootBI());
        builtins.put("round", new BuiltInsForNumbers.roundBI());
        builtins.put("remove_ending", new BuiltInsForStringsBasic.remove_endingBI());
        builtins.put("remove_beginning", new BuiltInsForStringsBasic.remove_beginningBI());
        builtins.put("rtf", new BuiltInsForStringsEncoding.rtfBI());
        builtins.put("seq_contains", new BuiltInsForSequences.seq_containsBI());
        builtins.put("seq_index_of", new BuiltInsForSequences.seq_index_ofBI(1));
        builtins.put("seq_last_index_of", new BuiltInsForSequences.seq_index_ofBI(-1));
        builtins.put("short", new BuiltInsForNumbers.shortBI());
        builtins.put("size", new BuiltInsForMultipleTypes.sizeBI());
        builtins.put("sort_by", new BuiltInsForSequences.sort_byBI());
        builtins.put("sort", new BuiltInsForSequences.sortBI());
        builtins.put("split", new BuiltInsForStringsBasic.split_BI());
        builtins.put("starts_with", new BuiltInsForStringsBasic.starts_withBI());
        builtins.put("string", new BuiltInsForMultipleTypes.stringBI());
        builtins.put("substring", new BuiltInsForStringsBasic.substringBI());
        builtins.put("time", new BuiltInsForMultipleTypes.dateBI(1));
        builtins.put("time_if_unknown", new BuiltInsForDates.dateType_if_unknownBI(1));
        builtins.put("trim", new BuiltInsForStringsBasic.trimBI());
        builtins.put("uncap_first", new BuiltInsForStringsBasic.uncap_firstBI());
        builtins.put("upper_case", new BuiltInsForStringsBasic.upper_caseBI());
        builtins.put("url", new BuiltInsForStringsEncoding.urlBI());
        builtins.put("url_path", new BuiltInsForStringsEncoding.urlPathBI());
        builtins.put("values", new BuiltInsForHashes.valuesBI());
        builtins.put("web_safe", builtins.get("html"));
        builtins.put("word_list", new BuiltInsForStringsBasic.word_listBI());
        builtins.put("xhtml", new BuiltInsForStringsEncoding.xhtmlBI());
        builtins.put("xml", new BuiltInsForStringsEncoding.xmlBI());
        builtins.put("matches", new BuiltInsForStringsRegexp.matchesBI());
        builtins.put("groups", new BuiltInsForStringsRegexp.groupsBI());
        builtins.put("replace", new BuiltInsForStringsRegexp.replace_reBI());
    }
}

