package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.actions.AddBenthosFrequencyLengthStepCaracteristicAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.actions.CancelEditBenthosFrequencyAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.actions.GenerateBenthosFrequencyLengthStepsAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.actions.ResetBenthosFrequencyAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.actions.SaveAndCloseBenthosFrequencyAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.actions.SaveAndContinueBenthosFrequencyAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class BenthosFrequencyUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<BenthosFrequencyUIModel, BenthosFrequencyUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_AUTO_GEN_MODE_BUTTON_SELECTED = "autoGenModeButton.selected";
    public static final String BINDING_DATA_FIELD_LAYOUT_SELECTED = "dataFieldLayout.selected";
    public static final String BINDING_DATA_IN_FREQUENCIES_WARNING_CONTAINER_VISIBLE = "dataInFrequenciesWarningContainer.visible";
    public static final String BINDING_GENERATE_LENGTH_STEPS_ACTION_ENABLED = "generateLengthStepsAction.enabled";
    public static final String BINDING_LENGTHSTEP_SETTINGS_BLOCK_VISIBLE = "lengthstepSettingsBlock.visible";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_ENABLED = "lengthStepCaracteristicComboBox.enabled";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM = "lengthStepCaracteristicComboBox.selectedItem";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_LABEL_ENABLED = "lengthStepCaracteristicLabel.enabled";
    public static final String BINDING_MAX_STEP_FIELD_NUMBER_PATTERN = "maxStepField.numberPattern";
    public static final String BINDING_MAX_STEP_FIELD_NUMBER_VALUE = "maxStepField.numberValue";
    public static final String BINDING_MIN_STEP_FIELD_NUMBER_PATTERN = "minStepField.numberPattern";
    public static final String BINDING_MIN_STEP_FIELD_NUMBER_VALUE = "minStepField.numberValue";
    public static final String BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED = "modeConfigurationLayout.selected";
    public static final String BINDING_RAFALE_MODE_BUTTON_SELECTED = "rafaleModeButton.selected";
    public static final String BINDING_RAFALE_STEP_FIELD_ENABLED = "rafaleStepField.enabled";
    public static final String BINDING_RAFALE_STEP_FIELD_NUMBER_PATTERN = "rafaleStepField.numberPattern";
    public static final String BINDING_SAVE_AND_CLOSE_ACTION_ENABLED = "saveAndCloseAction.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_ACTION_ENABLED = "saveAndContinueAction.enabled";
    public static final String BINDING_SIMPLE_COUNTING_FIELD_NUMBER_PATTERN = "simpleCountingField.numberPattern";
    public static final String BINDING_SIMPLE_COUNTING_FIELD_NUMBER_VALUE = "simpleCountingField.numberValue";
    public static final String BINDING_SIMPLE_COUNTING_MODE_BUTTON_SELECTED = "simpleCountingModeButton.selected";
    public static final String BINDING_STEP_FIELD_ENABLED = "stepField.enabled";
    public static final String BINDING_STEP_FIELD_NUMBER_PATTERN = "stepField.numberPattern";
    public static final String BINDING_STEP_FIELD_NUMBER_VALUE = "stepField.numberValue";
    public static final String BINDING_STEP_LABEL_ENABLED = "stepLabel.enabled";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";
    public static final String BINDING_TOTAL_NUMBER_FIELD_TEXT = "totalNumberField.text";
    public static final String BINDING_TOTAL_NUMBER_LABEL_ENABLED = "totalNumberLabel.enabled";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_BEAN = "totalWeightField.bean";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_NUMBER_VALUE = "totalWeightField.numberValue";
    public static final String BINDING_TOTAL_WEIGHT_LABEL_ENABLED = "totalWeightLabel.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(BenthosFrequencyUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actionPanel;
    protected AddBenthosFrequencyLengthStepCaracteristicAction addLengthStepCaracteristicAction;
    protected JButton addLengthStepCaracteristicButton;
    protected JRadioButton autoGenModeButton;
    protected JPanel autoGenModePanel;
    protected TuttiHelpBroker broker;
    protected CancelEditBenthosFrequencyAction cancelAction;
    protected JButton cancelButton;
    protected JPanel configurationPanel;
    protected CardLayout2Ext dataFieldLayout;
    protected JPanel dataFieldPanel;
    protected JLabel dataInFrequenciesWarning;
    protected JPanel dataInFrequenciesWarningContainer;
    protected BenthosFrequencyUI editBenthosFrequenciesTopPanel = this;
    protected JSplitPane firstSplitPane;
    protected JButton generateButton;
    protected GenerateBenthosFrequencyLengthStepsAction generateLengthStepsAction;
    protected final BenthosFrequencyUIHandler handler = createHandler();
    protected JPanel histogramPanel;
    @ValidatorField( validatorId = "validator",  propertyName = "lengthStepCaracteristic",  editorName = "lengthStepCaracteristicComboBox")
    protected BeanFilterableComboBox<Caracteristic> lengthStepCaracteristicComboBox;
    protected JLabel lengthStepCaracteristicLabel;
    protected Table lengthstepSettingsBlock;
    protected JScrollPane logsScrollPane;
    protected JXTable logsTable;
    protected NumberEditor maxStepField;
    protected JLabel maxStepLabel;
    protected NumberEditor minStepField;
    protected JLabel minStepLabel;
    protected JAXXButtonGroup mode;
    protected CardLayout2Ext modeConfigurationLayout;
    protected JPanel modeConfigurationPanel;
    protected VBox modePanel;
    protected BenthosFrequencyUIModel model;
    protected JRadioButton rafaleModeButton;
    protected JPanel rafaleModePanel;
    protected NumberEditor rafaleStepField;
    protected JLabel rafaleStepLabel;
    protected ResetBenthosFrequencyAction resetAction;
    protected JButton resetButton;
    protected SaveAndCloseBenthosFrequencyAction saveAndCloseAction;
    protected JButton saveAndCloseButton;
    protected SaveAndContinueBenthosFrequencyAction saveAndContinueAction;
    protected JButton saveAndContinueButton;
    protected JSplitPane secondSplitPane;
    protected NumberEditor simpleCountingField;
    protected JLabel simpleCountingLabel;
    protected JRadioButton simpleCountingModeButton;
    protected JLabel simpleCountingModeLabel;
    protected JPanel simpleCountingModePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "step",  editorName = "stepField")
    protected NumberEditor stepField;
    protected JLabel stepLabel;
    protected JXTable table;
    @ValidatorField( validatorId = "validator",  propertyName = "rows",  editorName = "tableScrollPane")
    protected JScrollPane tableScrollPane;
    protected JTextField totalNumberField;
    protected JLabel totalNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "totalWeight",  editorName = "totalWeightField")
    protected ComputableDataEditor<Float> totalWeightField;
    protected JLabel totalWeightLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<BenthosFrequencyUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JSeparator $JSeparator0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BenthosFrequencyUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public BenthosFrequencyUI() {
        $initialize();
    }

    public BenthosFrequencyUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosFrequencyUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BenthosFrequencyUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosFrequencyUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BenthosFrequencyUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosFrequencyUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public BenthosFrequencyUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__autoGenModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(FrequencyConfigurationMode.AUTO_GEN);
    }

    public void doActionPerformed__on__rafaleModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(FrequencyConfigurationMode.RAFALE);
    }

    public void doActionPerformed__on__simpleCountingModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(FrequencyConfigurationMode.SIMPLE_COUNTING);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActionPanel() {
        return actionPanel;
    }

    public AddBenthosFrequencyLengthStepCaracteristicAction getAddLengthStepCaracteristicAction() {
        return addLengthStepCaracteristicAction;
    }

    public JButton getAddLengthStepCaracteristicButton() {
        return addLengthStepCaracteristicButton;
    }

    public JRadioButton getAutoGenModeButton() {
        return autoGenModeButton;
    }

    public JPanel getAutoGenModePanel() {
        return autoGenModePanel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public CancelEditBenthosFrequencyAction getCancelAction() {
        return cancelAction;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public CardLayout2Ext getDataFieldLayout() {
        return dataFieldLayout;
    }

    public JPanel getDataFieldPanel() {
        return dataFieldPanel;
    }

    public JLabel getDataInFrequenciesWarning() {
        return dataInFrequenciesWarning;
    }

    public JPanel getDataInFrequenciesWarningContainer() {
        return dataInFrequenciesWarningContainer;
    }

    public JSplitPane getFirstSplitPane() {
        return firstSplitPane;
    }

    public JButton getGenerateButton() {
        return generateButton;
    }

    public GenerateBenthosFrequencyLengthStepsAction getGenerateLengthStepsAction() {
        return generateLengthStepsAction;
    }

    public BenthosFrequencyUIHandler getHandler() {
        return handler;
    }

    public JPanel getHistogramPanel() {
        return histogramPanel;
    }

    public BeanFilterableComboBox<Caracteristic> getLengthStepCaracteristicComboBox() {
        return lengthStepCaracteristicComboBox;
    }

    public JLabel getLengthStepCaracteristicLabel() {
        return lengthStepCaracteristicLabel;
    }

    public Table getLengthstepSettingsBlock() {
        return lengthstepSettingsBlock;
    }

    public JScrollPane getLogsScrollPane() {
        return logsScrollPane;
    }

    public JXTable getLogsTable() {
        return logsTable;
    }

    public NumberEditor getMaxStepField() {
        return maxStepField;
    }

    public JLabel getMaxStepLabel() {
        return maxStepLabel;
    }

    public NumberEditor getMinStepField() {
        return minStepField;
    }

    public JLabel getMinStepLabel() {
        return minStepLabel;
    }

    public JAXXButtonGroup getMode() {
        return mode;
    }

    public CardLayout2Ext getModeConfigurationLayout() {
        return modeConfigurationLayout;
    }

    public JPanel getModeConfigurationPanel() {
        return modeConfigurationPanel;
    }

    public VBox getModePanel() {
        return modePanel;
    }

    public BenthosFrequencyUIModel getModel() {
        return model;
    }

    public JRadioButton getRafaleModeButton() {
        return rafaleModeButton;
    }

    public JPanel getRafaleModePanel() {
        return rafaleModePanel;
    }

    public NumberEditor getRafaleStepField() {
        return rafaleStepField;
    }

    public JLabel getRafaleStepLabel() {
        return rafaleStepLabel;
    }

    public ResetBenthosFrequencyAction getResetAction() {
        return resetAction;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public SaveAndCloseBenthosFrequencyAction getSaveAndCloseAction() {
        return saveAndCloseAction;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public SaveAndContinueBenthosFrequencyAction getSaveAndContinueAction() {
        return saveAndContinueAction;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public JSplitPane getSecondSplitPane() {
        return secondSplitPane;
    }

    public NumberEditor getSimpleCountingField() {
        return simpleCountingField;
    }

    public JLabel getSimpleCountingLabel() {
        return simpleCountingLabel;
    }

    public JRadioButton getSimpleCountingModeButton() {
        return simpleCountingModeButton;
    }

    public JLabel getSimpleCountingModeLabel() {
        return simpleCountingModeLabel;
    }

    public JPanel getSimpleCountingModePanel() {
        return simpleCountingModePanel;
    }

    public NumberEditor getStepField() {
        return stepField;
    }

    public JLabel getStepLabel() {
        return stepLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JTextField getTotalNumberField() {
        return totalNumberField;
    }

    public JLabel getTotalNumberLabel() {
        return totalNumberLabel;
    }

    public ComputableDataEditor<Float> getTotalWeightField() {
        return totalWeightField;
    }

    public JLabel getTotalWeightLabel() {
        return totalWeightLabel;
    }

    public SwingValidator<BenthosFrequencyUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(cancelButton);
        actionPanel.add(resetButton);
        actionPanel.add(saveAndContinueButton);
        actionPanel.add(saveAndCloseButton);
    }

    protected void addChildrenToAutoGenModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; autoGenModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(autoGenModeButton); }
    }

    protected void addChildrenToAutoGenModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        autoGenModePanel.add($Table0, BorderLayout.SOUTH);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(modePanel, BorderLayout.WEST);
        configurationPanel.add(modeConfigurationPanel, BorderLayout.CENTER);
        configurationPanel.add(lengthstepSettingsBlock, BorderLayout.SOUTH);
    }

    protected void addChildrenToDataFieldPanel() {
        if (!allComponentsCreated) {
            return;
        }
        dataFieldPanel.add(firstSplitPane, "lengthCaracteristicPmfm");
        dataFieldPanel.add($Table2, "noLengthCaracteristicPmfm");
    }

    protected void addChildrenToDataInFrequenciesWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        dataInFrequenciesWarningContainer.add(dataInFrequenciesWarning, BorderLayout.CENTER);
    }

    protected void addChildrenToEditBenthosFrequenciesTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(dataFieldPanel, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToFirstSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        firstSplitPane.add(secondSplitPane, JSplitPane.LEFT);
        firstSplitPane.add(histogramPanel, JSplitPane.RIGHT);
    }

    protected void addChildrenToLengthstepSettingsBlock() {
        if (!allComponentsCreated) {
            return;
        }
        lengthstepSettingsBlock.add($JSeparator0, new GridBagConstraints(0, 0, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(lengthStepCaracteristicLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add($JPanel1, new GridBagConstraints(1, 1, 5, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(stepLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(SwingUtil.boxComponentWithJxLayer(stepField), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalNumberLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalNumberField, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalWeightLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(SwingUtil.boxComponentWithJxLayer(totalWeightField), new GridBagConstraints(5, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToLogsScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        logsScrollPane.getViewport().add(logsTable);
    }

    protected void addChildrenToModeConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        modeConfigurationPanel.add(autoGenModePanel, "autoGenMode");
        modeConfigurationPanel.add(rafaleModePanel, "rafaleMode");
        modeConfigurationPanel.add(simpleCountingModePanel, "simpleCountingMode");
    }

    protected void addChildrenToModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        modePanel.add(autoGenModeButton);
        modePanel.add(rafaleModeButton);
        modePanel.add(simpleCountingModeButton);
    }

    protected void addChildrenToRafaleModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; rafaleModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(rafaleModeButton); }
    }

    protected void addChildrenToRafaleModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        rafaleModePanel.add($Table1, BorderLayout.SOUTH);
    }

    protected void addChildrenToSecondSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        secondSplitPane.add(logsScrollPane, JSplitPane.LEFT);
        secondSplitPane.add(SwingUtil.boxComponentWithJxLayer(tableScrollPane), JSplitPane.RIGHT);
    }

    protected void addChildrenToSimpleCountingModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; simpleCountingModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(simpleCountingModeButton); }
    }

    protected void addChildrenToSimpleCountingModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        simpleCountingModePanel.add(simpleCountingModeLabel, BorderLayout.CENTER);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new JPanel());
        
        actionPanel.setName("actionPanel");
        actionPanel.setLayout(new GridLayout(1, 0));
    }

    protected void createAddLengthStepCaracteristicAction() {
        $objectMap.put("addLengthStepCaracteristicAction", addLengthStepCaracteristicAction = new AddBenthosFrequencyLengthStepCaracteristicAction(this));
    }

    protected void createAddLengthStepCaracteristicButton() {
        $objectMap.put("addLengthStepCaracteristicButton", addLengthStepCaracteristicButton = new JButton());
        
        addLengthStepCaracteristicButton.setName("addLengthStepCaracteristicButton");
        addLengthStepCaracteristicButton.putClientProperty("help", "tutti.editBenthosFrequencies.action.addLengthStepCaracteristic.help");
    }

    protected void createAutoGenModeButton() {
        $objectMap.put("autoGenModeButton", autoGenModeButton = new JRadioButton());
        
        autoGenModeButton.setName("autoGenModeButton");
        autoGenModeButton.setText(t("tutti.editBenthosFrequencies.field.mode.autoGen"));
        { autoGenModeButton.putClientProperty("$value", "autoGenMode");  Object $buttonGroup = autoGenModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        autoGenModeButton.setToolTipText(t("tutti.editBenthosFrequencies.field.mode.autoGen.tip"));
        autoGenModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__autoGenModeButton"));
        autoGenModeButton.putClientProperty("help", "tutti.editBenthosFrequencies.field.mode.autoGen.help");
    }

    protected void createAutoGenModePanel() {
        $objectMap.put("autoGenModePanel", autoGenModePanel = new JPanel());
        
        autoGenModePanel.setName("autoGenModePanel");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editBenthosFrequencies.help"));
    }

    protected void createCancelAction() {
        $objectMap.put("cancelAction", cancelAction = new CancelEditBenthosFrequencyAction(this));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.putClientProperty("help", "tutti.editBenthosFrequencies.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new BorderLayout());
    }

    protected void createDataFieldLayout() {
        $objectMap.put("dataFieldLayout", dataFieldLayout = new CardLayout2Ext(this, "dataFieldPanel"));
    }

    protected void createDataFieldPanel() {
        $objectMap.put("dataFieldPanel", dataFieldPanel = new JPanel());
        
        dataFieldPanel.setName("dataFieldPanel");
        dataFieldPanel.setLayout(dataFieldLayout);
    }

    protected void createDataInFrequenciesWarning() {
        $objectMap.put("dataInFrequenciesWarning", dataInFrequenciesWarning = new JLabel());
        
        dataInFrequenciesWarning.setName("dataInFrequenciesWarning");
        dataInFrequenciesWarning.setText(t("tutti.editBenthosFrequencies.simpleCountingAndFrequencies"));
    }

    protected void createDataInFrequenciesWarningContainer() {
        $objectMap.put("dataInFrequenciesWarningContainer", dataInFrequenciesWarningContainer = new JPanel());
        
        dataInFrequenciesWarningContainer.setName("dataInFrequenciesWarningContainer");
        dataInFrequenciesWarningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createFirstSplitPane() {
        $objectMap.put("firstSplitPane", firstSplitPane = new JSplitPane());
        
        firstSplitPane.setName("firstSplitPane");
        firstSplitPane.setOneTouchExpandable(true);
        firstSplitPane.setResizeWeight(0.6);
    }

    protected void createGenerateButton() {
        $objectMap.put("generateButton", generateButton = new JButton());
        
        generateButton.setName("generateButton");
        generateButton.putClientProperty("help", "tutti.editBenthosFrequencies.action.generate.help");
    }

    protected void createGenerateLengthStepsAction() {
        $objectMap.put("generateLengthStepsAction", generateLengthStepsAction = new GenerateBenthosFrequencyLengthStepsAction(this));
    }

    protected BenthosFrequencyUIHandler createHandler() {
        return new BenthosFrequencyUIHandler();
    }

    protected void createHistogramPanel() {
        $objectMap.put("histogramPanel", histogramPanel = new JPanel());
        
        histogramPanel.setName("histogramPanel");
        histogramPanel.setLayout(new BorderLayout());
    }

    protected void createLengthStepCaracteristicComboBox() {
        $objectMap.put("lengthStepCaracteristicComboBox", lengthStepCaracteristicComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        lengthStepCaracteristicComboBox.setName("lengthStepCaracteristicComboBox");
        lengthStepCaracteristicComboBox.setProperty("lengthStepCaracteristic");
        lengthStepCaracteristicComboBox.setShowReset(true);
        lengthStepCaracteristicComboBox.putClientProperty("help", "tutti.editBenthosFrequencies.field.lengthStepCaracteristic.help");
        lengthStepCaracteristicComboBox.putClientProperty("validatorLabel", t("tutti.editBenthosFrequencies.field.lengthStepCaracteristic"));
    }

    protected void createLengthStepCaracteristicLabel() {
        $objectMap.put("lengthStepCaracteristicLabel", lengthStepCaracteristicLabel = new JLabel());
        
        lengthStepCaracteristicLabel.setName("lengthStepCaracteristicLabel");
        lengthStepCaracteristicLabel.setText(t("tutti.editBenthosFrequencies.field.lengthStepCaracteristic"));
        lengthStepCaracteristicLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.lengthStepCaracteristic.tip"));
        lengthStepCaracteristicLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.lengthStepCaracteristic.help");
    }

    protected void createLengthstepSettingsBlock() {
        $objectMap.put("lengthstepSettingsBlock", lengthstepSettingsBlock = new Table());
        
        lengthstepSettingsBlock.setName("lengthstepSettingsBlock");
    }

    protected void createLogsScrollPane() {
        $objectMap.put("logsScrollPane", logsScrollPane = new JScrollPane());
        
        logsScrollPane.setName("logsScrollPane");
    }

    protected void createLogsTable() {
        $objectMap.put("logsTable", logsTable = new JXTable());
        
        logsTable.setName("logsTable");
        logsTable.setSortable(false);
    }

    protected void createMaxStepField() {
        $objectMap.put("maxStepField", maxStepField = new NumberEditor(this));
        
        maxStepField.setName("maxStepField");
        maxStepField.setProperty("maxStep");
        maxStepField.setShowReset(true);
        maxStepField.putClientProperty("help", "tutti.editBenthosFrequencies.field.maxStep.help");
        maxStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createMaxStepLabel() {
        $objectMap.put("maxStepLabel", maxStepLabel = new JLabel());
        
        maxStepLabel.setName("maxStepLabel");
        maxStepLabel.setText(t("tutti.editBenthosFrequencies.field.maxStep"));
        maxStepLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.maxStep.tip"));
        maxStepLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.maxStep.help");
    }

    protected void createMinStepField() {
        $objectMap.put("minStepField", minStepField = new NumberEditor(this));
        
        minStepField.setName("minStepField");
        minStepField.setProperty("minStep");
        minStepField.setShowReset(true);
        minStepField.putClientProperty("help", "tutti.editBenthosFrequencies.field.minStep.help");
        minStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createMinStepLabel() {
        $objectMap.put("minStepLabel", minStepLabel = new JLabel());
        
        minStepLabel.setName("minStepLabel");
        minStepLabel.setText(t("tutti.editBenthosFrequencies.field.minStep"));
        minStepLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.minStep.tip"));
        minStepLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.minStep.help");
    }

    protected void createMode() {
        $objectMap.put("mode", mode = new JAXXButtonGroup());
    }

    protected void createModeConfigurationLayout() {
        $objectMap.put("modeConfigurationLayout", modeConfigurationLayout = new CardLayout2Ext(this, "modeConfigurationPanel"));
    }

    protected void createModeConfigurationPanel() {
        $objectMap.put("modeConfigurationPanel", modeConfigurationPanel = new JPanel());
        
        modeConfigurationPanel.setName("modeConfigurationPanel");
        modeConfigurationPanel.setLayout(modeConfigurationLayout);
    }

    protected void createModePanel() {
        $objectMap.put("modePanel", modePanel = new VBox());
        
        modePanel.setName("modePanel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(BenthosFrequencyUIModel.class));
    }

    protected void createRafaleModeButton() {
        $objectMap.put("rafaleModeButton", rafaleModeButton = new JRadioButton());
        
        rafaleModeButton.setName("rafaleModeButton");
        rafaleModeButton.setText(t("tutti.editBenthosFrequencies.field.mode.rafale"));
        { rafaleModeButton.putClientProperty("$value", "rafaleMode");  Object $buttonGroup = rafaleModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        rafaleModeButton.setToolTipText(t("tutti.editBenthosFrequencies.field.mode.rafale.tip"));
        rafaleModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__rafaleModeButton"));
        rafaleModeButton.putClientProperty("help", "tutti.editBenthosFrequencies.field.mode.rafale.help");
    }

    protected void createRafaleModePanel() {
        $objectMap.put("rafaleModePanel", rafaleModePanel = new JPanel());
        
        rafaleModePanel.setName("rafaleModePanel");
    }

    protected void createRafaleStepField() {
        $objectMap.put("rafaleStepField", rafaleStepField = new NumberEditor(this));
        
        rafaleStepField.setName("rafaleStepField");
        rafaleStepField.setShowReset(true);
        rafaleStepField.putClientProperty("help", "tutti.editBenthosFrequencies.field.rafaleStep.help");
        rafaleStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createRafaleStepLabel() {
        $objectMap.put("rafaleStepLabel", rafaleStepLabel = new JLabel());
        
        rafaleStepLabel.setName("rafaleStepLabel");
        rafaleStepLabel.setText(t("tutti.editBenthosFrequencies.field.rafaleStep"));
        rafaleStepLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.rafaleStep.tip"));
        rafaleStepLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.rafaleStep.help");
    }

    protected void createResetAction() {
        $objectMap.put("resetAction", resetAction = new ResetBenthosFrequencyAction(this));
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.putClientProperty("help", "tutti.editBenthosFrequencies.action.reset.help");
    }

    protected void createSaveAndCloseAction() {
        $objectMap.put("saveAndCloseAction", saveAndCloseAction = new SaveAndCloseBenthosFrequencyAction(this));
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.putClientProperty("help", "tutti.editBenthosFrequencies.action.saveAndClose.help");
    }

    protected void createSaveAndContinueAction() {
        $objectMap.put("saveAndContinueAction", saveAndContinueAction = new SaveAndContinueBenthosFrequencyAction(this));
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.putClientProperty("help", "tutti.editBenthosFrequencies.action.saveAndContinue.help");
    }

    protected void createSecondSplitPane() {
        $objectMap.put("secondSplitPane", secondSplitPane = new JSplitPane());
        
        secondSplitPane.setName("secondSplitPane");
        secondSplitPane.setOneTouchExpandable(true);
        secondSplitPane.setResizeWeight(0.1);
    }

    protected void createSimpleCountingField() {
        $objectMap.put("simpleCountingField", simpleCountingField = new NumberEditor(this));
        
        simpleCountingField.setName("simpleCountingField");
        simpleCountingField.setProperty("simpleCount");
        simpleCountingField.setShowReset(true);
        simpleCountingField.putClientProperty("help", "tutti.editBenthosFrequencies.field.simpleCounting.help");
        simpleCountingField.putClientProperty("selectOnFocus", true);
    }

    protected void createSimpleCountingLabel() {
        $objectMap.put("simpleCountingLabel", simpleCountingLabel = new JLabel());
        
        simpleCountingLabel.setName("simpleCountingLabel");
        simpleCountingLabel.setText(t("tutti.editBenthosFrequencies.field.simpleCounting"));
        simpleCountingLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.simpleCounting.tip"));
        simpleCountingLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.simpleCounting.help");
    }

    protected void createSimpleCountingModeButton() {
        $objectMap.put("simpleCountingModeButton", simpleCountingModeButton = new JRadioButton());
        
        simpleCountingModeButton.setName("simpleCountingModeButton");
        simpleCountingModeButton.setText(t("tutti.editBenthosFrequencies.field.mode.simpleCounting"));
        { simpleCountingModeButton.putClientProperty("$value", "simpleCountingMode");  Object $buttonGroup = simpleCountingModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        simpleCountingModeButton.setToolTipText(t("tutti.editBenthosFrequencies.field.mode.simpleCounting.tip"));
        simpleCountingModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__simpleCountingModeButton"));
        simpleCountingModeButton.putClientProperty("help", "tutti.editBenthosFrequencies.field.mode.simpleCounting.help");
    }

    protected void createSimpleCountingModeLabel() {
        $objectMap.put("simpleCountingModeLabel", simpleCountingModeLabel = new JLabel());
        
        simpleCountingModeLabel.setName("simpleCountingModeLabel");
        simpleCountingModeLabel.setEnabled(false);
        simpleCountingModeLabel.setText(t("tutti.editBenthosFrequencies.label.no.configuration"));
    }

    protected void createSimpleCountingModePanel() {
        $objectMap.put("simpleCountingModePanel", simpleCountingModePanel = new JPanel());
        
        simpleCountingModePanel.setName("simpleCountingModePanel");
        simpleCountingModePanel.setLayout(new BorderLayout());
    }

    protected void createStepField() {
        $objectMap.put("stepField", stepField = new NumberEditor(this));
        
        stepField.setName("stepField");
        stepField.setProperty("step");
        stepField.setShowReset(true);
        stepField.putClientProperty("help", "tutti.editBenthosFrequencies.field.step.help");
        stepField.putClientProperty("validatorLabel", t("tutti.editBenthosFrequencies.field.step"));
        stepField.putClientProperty("selectOnFocus", true);
    }

    protected void createStepLabel() {
        $objectMap.put("stepLabel", stepLabel = new JLabel());
        
        stepLabel.setName("stepLabel");
        stepLabel.setText(t("tutti.editBenthosFrequencies.field.step"));
        stepLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.step.tip"));
        stepLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.step.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
        tableScrollPane.putClientProperty("validatorLabel", t("tutti.editBenthosFrequencies.field.rows"));
    }

    protected void createTotalNumberField() {
        $objectMap.put("totalNumberField", totalNumberField = new JTextField());
        
        totalNumberField.setName("totalNumberField");
        totalNumberField.setColumns(15);
        totalNumberField.setEnabled(false);
        totalNumberField.putClientProperty("help", "tutti.editBenthosFrequencies.field.totalNumber.help");
        totalNumberField.putClientProperty("computed", true);
    }

    protected void createTotalNumberLabel() {
        $objectMap.put("totalNumberLabel", totalNumberLabel = new JLabel());
        
        totalNumberLabel.setName("totalNumberLabel");
        totalNumberLabel.setText(t("tutti.editBenthosFrequencies.field.totalNumber"));
        totalNumberLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.totalNumber.tip"));
        totalNumberLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.totalNumber.help");
    }

    protected void createTotalWeightField() {
        $objectMap.put("totalWeightField", totalWeightField = new ComputableDataEditor<Float>(this));
        
        totalWeightField.setName("totalWeightField");
        totalWeightField.setShowReset(true);
        totalWeightField.putClientProperty("help", "tutti.editBenthosFrequencies.field.totalWeight.help");
        totalWeightField.putClientProperty("validatorLabel", t("tutti.editBenthosFrequencies.field.totalWeight"));
        totalWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createTotalWeightLabel() {
        $objectMap.put("totalWeightLabel", totalWeightLabel = new JLabel());
        
        totalWeightLabel.setName("totalWeightLabel");
        totalWeightLabel.setText(t("tutti.editBenthosFrequencies.field.totalWeight"));
        totalWeightLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.totalWeight.tip"));
        totalWeightLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.totalWeight.help");
        totalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(BenthosFrequencyUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditBenthosFrequenciesTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        addChildrenToModePanel();
        addChildrenToAutoGenModeButton();
        addChildrenToRafaleModeButton();
        addChildrenToSimpleCountingModeButton();
        addChildrenToModeConfigurationPanel();
        addChildrenToAutoGenModePanel();
        // inline complete setup of $Table0
        $Table0.add(minStepLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(minStepField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(maxStepLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(maxStepField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(generateButton);
        addChildrenToRafaleModePanel();
        // inline complete setup of $Table1
        $Table1.add(rafaleStepLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(rafaleStepField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToSimpleCountingModePanel();
        addChildrenToLengthstepSettingsBlock();
        // inline complete setup of $JPanel1
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(lengthStepCaracteristicComboBox), BorderLayout.CENTER);
        $JPanel1.add(addLengthStepCaracteristicButton, BorderLayout.EAST);
        addChildrenToDataFieldPanel();
        addChildrenToFirstSplitPane();
        addChildrenToSecondSplitPane();
        addChildrenToLogsScrollPane();
        addChildrenToTableScrollPane();
        // inline complete setup of $Table2
        $Table2.add(dataInFrequenciesWarningContainer, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(simpleCountingLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(simpleCountingField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToDataInFrequenciesWarningContainer();
        addChildrenToActionPanel();
        
        // apply 31 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 65 property setters
        modePanel.setVerticalAlignment(SwingConstants.CENTER);
        lengthStepCaracteristicComboBox.setBeanType(Caracteristic.class);
        configurationPanel.setBorder(new TitledBorder(null, null));
        autoGenModeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosFrequencies.field.mode.autoGen.mnemonic"),'Z'));
        rafaleModeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosFrequencies.field.mode.rafale.mnemonic"),'Z'));
        simpleCountingModeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosFrequencies.field.mode.simpleCounting.mnemonic"),'Z'));
        minStepLabel.setLabelFor(minStepField);
        minStepField.setBean(model);
        minStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        minStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        minStepField.setNumberType(Float.class);
        maxStepLabel.setLabelFor(maxStepField);
        maxStepField.setBean(model);
        maxStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        maxStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        maxStepField.setNumberType(Float.class);
        generateButton.setAction(generateLengthStepsAction);
        rafaleStepLabel.setLabelFor(rafaleStepField);
        rafaleStepField.setBean(model);
        rafaleStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        rafaleStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        rafaleStepField.setNumberType(Float.class);
        simpleCountingModeLabel.setHorizontalAlignment(JLabel.CENTER);
        lengthStepCaracteristicLabel.setLabelFor(lengthStepCaracteristicComboBox);
        lengthStepCaracteristicComboBox.setBean(model);
        addLengthStepCaracteristicButton.setAction(addLengthStepCaracteristicAction);
        stepLabel.setLabelFor(stepField);
        stepField.setBean(model);
        stepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        stepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        stepField.setNumberType(Float.class);
        totalNumberLabel.setLabelFor(totalNumberField);
        totalWeightLabel.setLabelFor(totalWeightField);
        totalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        totalWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        totalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        totalWeightField.setNumberType(Float.class);
        logsTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        logsTable.setSelectionForeground(Color.BLACK);
        logsTable.setSelectionBackground(null);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        dataInFrequenciesWarningContainer.setBackground(new java.awt.Color(245, 218, 88));
        dataInFrequenciesWarning.setIcon(SwingUtil.createActionIcon("warning"));
        dataInFrequenciesWarning.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        simpleCountingLabel.setLabelFor(simpleCountingField);
        simpleCountingField.setBean(model);
        simpleCountingField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        simpleCountingField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        simpleCountingField.setNumberType(Integer.class);
        cancelButton.setAction(cancelAction);
        resetButton.setAction(resetAction);
        saveAndContinueButton.setAction(saveAndContinueAction);
        saveAndCloseButton.setAction(saveAndCloseAction);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editBenthosFrequenciesTopPanel, "tutti.editBenthosFrequencies.help");
        registerHelpId(_broker, autoGenModeButton, "tutti.editBenthosFrequencies.field.mode.autoGen.help");
        registerHelpId(_broker, rafaleModeButton, "tutti.editBenthosFrequencies.field.mode.rafale.help");
        registerHelpId(_broker, simpleCountingModeButton, "tutti.editBenthosFrequencies.field.mode.simpleCounting.help");
        registerHelpId(_broker, minStepLabel, "tutti.editBenthosFrequencies.field.minStep.help");
        registerHelpId(_broker, minStepField, "tutti.editBenthosFrequencies.field.minStep.help");
        registerHelpId(_broker, maxStepLabel, "tutti.editBenthosFrequencies.field.maxStep.help");
        registerHelpId(_broker, maxStepField, "tutti.editBenthosFrequencies.field.maxStep.help");
        registerHelpId(_broker, generateButton, "tutti.editBenthosFrequencies.action.generate.help");
        registerHelpId(_broker, rafaleStepLabel, "tutti.editBenthosFrequencies.field.rafaleStep.help");
        registerHelpId(_broker, rafaleStepField, "tutti.editBenthosFrequencies.field.rafaleStep.help");
        registerHelpId(_broker, lengthStepCaracteristicLabel, "tutti.editBenthosFrequencies.field.lengthStepCaracteristic.help");
        registerHelpId(_broker, lengthStepCaracteristicComboBox, "tutti.editBenthosFrequencies.field.lengthStepCaracteristic.help");
        registerHelpId(_broker, addLengthStepCaracteristicButton, "tutti.editBenthosFrequencies.action.addLengthStepCaracteristic.help");
        registerHelpId(_broker, stepLabel, "tutti.editBenthosFrequencies.field.step.help");
        registerHelpId(_broker, stepField, "tutti.editBenthosFrequencies.field.step.help");
        registerHelpId(_broker, totalNumberLabel, "tutti.editBenthosFrequencies.field.totalNumber.help");
        registerHelpId(_broker, totalNumberField, "tutti.editBenthosFrequencies.field.totalNumber.help");
        registerHelpId(_broker, totalWeightLabel, "tutti.editBenthosFrequencies.field.totalWeight.help");
        registerHelpId(_broker, totalWeightField, "tutti.editBenthosFrequencies.field.totalWeight.help");
        registerHelpId(_broker, simpleCountingLabel, "tutti.editBenthosFrequencies.field.simpleCounting.help");
        registerHelpId(_broker, simpleCountingField, "tutti.editBenthosFrequencies.field.simpleCounting.help");
        registerHelpId(_broker, cancelButton, "tutti.editBenthosFrequencies.action.cancel.help");
        registerHelpId(_broker, resetButton, "tutti.editBenthosFrequencies.action.reset.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.editBenthosFrequencies.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.editBenthosFrequencies.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editBenthosFrequenciesTopPanel", editBenthosFrequenciesTopPanel);
        createModel();
        createValidator();
        createBroker();
        createModeConfigurationLayout();
        createDataFieldLayout();
        createAddLengthStepCaracteristicAction();
        createGenerateLengthStepsAction();
        createCancelAction();
        createResetAction();
        createSaveAndCloseAction();
        createSaveAndContinueAction();
        createConfigurationPanel();
        createModePanel();
        createAutoGenModeButton();
        createRafaleModeButton();
        createSimpleCountingModeButton();
        createModeConfigurationPanel();
        createAutoGenModePanel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createMinStepLabel();
        createMinStepField();
        createMaxStepLabel();
        createMaxStepField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createGenerateButton();
        createRafaleModePanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createRafaleStepLabel();
        createRafaleStepField();
        createSimpleCountingModePanel();
        createSimpleCountingModeLabel();
        createLengthstepSettingsBlock();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createLengthStepCaracteristicLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createLengthStepCaracteristicComboBox();
        createAddLengthStepCaracteristicButton();
        createStepLabel();
        createStepField();
        createTotalNumberLabel();
        createTotalNumberField();
        createTotalWeightLabel();
        createTotalWeightField();
        createDataFieldPanel();
        createFirstSplitPane();
        createSecondSplitPane();
        createLogsScrollPane();
        createLogsTable();
        createTableScrollPane();
        createTable();
        createHistogramPanel();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createDataInFrequenciesWarningContainer();
        createDataInFrequenciesWarning();
        createSimpleCountingLabel();
        createSimpleCountingField();
        createActionPanel();
        createCancelButton();
        createResetButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        createMode();
        // inline creation of editBenthosFrequenciesTopPanel
        setName("editBenthosFrequenciesTopPanel");
        setLayout(new BorderLayout());
        editBenthosFrequenciesTopPanel.putClientProperty("help", "tutti.editBenthosFrequencies.help");
        
        // registers 31 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 31 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (mode != null) {
                    mode.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (mode != null) {
                    modeConfigurationLayout.setSelected(String.valueOf(mode.getSelectedValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (mode != null) {
                    mode.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATA_FIELD_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dataFieldLayout.setSelected(model.isSimpleCountingMode() ? "noLengthCaracteristicPmfm" : "lengthCaracteristicPmfm");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_LENGTH_STEPS_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canGenerate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateLengthStepsAction.setEnabled(model.isCanGenerate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canGenerate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseAction.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_ACTION_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nextEditableRowIndex", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueAction.setEnabled(model.getNextEditableRowIndex() != null && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nextEditableRowIndex", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AUTO_GEN_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("autoGenMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    autoGenModeButton.setSelected(model.isAutoGenMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("autoGenMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RAFALE_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rafaleMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rafaleModeButton.setSelected(model.isRafaleMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rafaleMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_COUNTING_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleCountingModeButton.setSelected(model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MIN_STEP_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minStepField.setNumberValue(model.getMinStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minStep", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MIN_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                minStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAX_STEP_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    maxStepField.setNumberValue(model.getMaxStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxStep", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MAX_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                maxStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RAFALE_STEP_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rafaleStepField.setEnabled(model.getLengthStepCaracteristic() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RAFALE_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                rafaleStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTHSTEP_SETTINGS_BLOCK_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthstepSettingsBlock.setVisible(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("canEditLengthStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicComboBox.setEnabled(!model.isSimpleCountingMode() && model.isCanEditLengthStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("canEditLengthStep", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicComboBox.setSelectedItem(model.getLengthStepCaracteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_FIELD_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("canEditLengthStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepField.setEnabled(!model.isSimpleCountingMode() && model.isCanEditLengthStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("canEditLengthStep", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepField.setNumberValue(model.getStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                stepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_NUMBER_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalNumberLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_NUMBER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(totalNumberField, getStringValue(model.getTotalNumber()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightLabel.setEnabled(model.getTotalWeight() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightField.setBean(model.getTotalComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightField.setNumberValue(model.getTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("step", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getLengthStepCaracteristic() != null && model.getStep() > 0f);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("step", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATA_IN_FREQUENCIES_WARNING_CONTAINER_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rowsInError", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("emptyRows", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("rows", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getRows() != null && model.getEmptyRows() != null && model.getRowsInError() != null) {
                    dataInFrequenciesWarningContainer.setVisible((model.getRowsInError().size() + model.getEmptyRows().size()) != model.getRows().size());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rowsInError", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("emptyRows", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("rows", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_COUNTING_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleCountingField.setNumberValue(model.getSimpleCount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCount", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SIMPLE_COUNTING_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                simpleCountingField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
    }

}