/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.RadioCheckField;
import java.io.IOException;
import org.w3c.dom.Element;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.AbstractFormField;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.RenderingContext;

public class CheckboxFormField
extends AbstractFormField {
    private static final String FIELD_TYPE = "Checkbox";

    public CheckboxFormField(LayoutContext c, BlockBox box, int cssWidth, int cssHeight) {
        this.initDimensions(c, box, cssWidth, cssHeight);
    }

    protected String getFieldType() {
        return FIELD_TYPE;
    }

    public void paint(RenderingContext c, ITextOutputDevice outputDevice, BlockBox box) {
        PdfContentByte cb = outputDevice.getCurrentPage();
        PdfWriter writer = outputDevice.getWriter();
        Element elm = box.getElement();
        Rectangle targetArea = outputDevice.createLocalTargetArea(c, (Box)box);
        String onValue = this.getValue(elm);
        RadioCheckField field = new RadioCheckField(writer, targetArea, this.getFieldName(outputDevice, elm), onValue);
        field.setChecked(this.isChecked(elm));
        field.setCheckType(1);
        field.setBorderStyle(0);
        field.setBorderColor(BaseColor.BLACK);
        field.setBorderWidth(1.0f);
        try {
            PdfFormField formField = field.getCheckField();
            if (this.isReadOnly(elm)) {
                formField.setFieldFlags(1);
            }
            writer.addAnnotation((PdfAnnotation)formField);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        catch (DocumentException de) {
            System.out.println((Object)de);
        }
    }

    public int getBaseline() {
        return 0;
    }

    public boolean hasBaseline() {
        return false;
    }
}

